/* Copyright 1990, Daniel J. Bernstein. All rights reserved. */

#ifndef PTY_H
#define PTY_H

extern int uid;
extern int euid;
extern int pid;
extern int pgrp;
extern long date;
extern char *username;

extern int fdin; /* input */
extern int fdout; /* output */
extern int fdmty; /* master side of pty */
extern int fdsty; /* slave side of pty */
extern int fdtty; /* current tty, if connected to one, or -1 */
extern int fdre; /* for reconnecting and fd passing, or -1 */
extern int fdpass; /* for passing master side up to controller */

extern int flagquiet; /* -q, don't make any noises at all */
extern int flagdetached; /* -d, we are detached to start */
extern int flagjobctrl; /* -j, we can stop/start */
extern int flagttymodes; /* -t, we change modes of original tty */
extern int flagsameerr; /* -e (3), we leave fds 2 (3) and up alone */
extern int flagfdpass; /* -fn, we pass master side up fd n */
extern int flagsession; /* -s, we can disconnect & reconnect */
extern int flagverbose; /* -v, complain about everything */

extern int flagxchown; /* -xc, change owner of pty */
extern int flagxutmp; /* -xu, add entry to utmp */
extern int flagxwtmp; /* -xw, add entry to wtmp */
extern int flagxexcl; /* -xx, set exclusive use */
extern int flagxerrwo; /* -xe, make stderr write-only */
extern int flagxchkopen; /* -xn, check if anyone has pty open */
extern int flagxskipopen; /* -xo, skip if anyone has pty open */
extern int flagxrandom; /* -xr, search through ptys randomly */
extern int flagxsetuid; /* -xs, we're running setuid */

#include "tty.h"

extern struct ttymodes tmotty;
extern struct ttymodes tmochartty;
extern struct ttymodes tmopty;

#define copy(dst,src,num) bcopy(src,dst,num)

#endif
