/* Copyright 1990, Daniel J. Bernstein. All rights reserved. */

#include <stdio.h>
#include "config.h"
#include "pty.h"
#include "err.h"

static void perr(e)
int e;
{
 if (!flagquiet)
  {
   if ((e < 0) || (e > sys_nerr))
     (void) fprintf(stderr,"error %d",e);
   else
     (void) fputs(sys_errlist[e],stderr);
  }
}

static void serr(s)
char *s;
{
 if (!flagquiet)
   (void) fputs(s,stderr);
}

void warnerr2(p,s)
char *p;
char *s;
{
 if (!flagquiet)
   (void) fprintf(stderr,p,s);
}

/* Note that accounting is based on the real uid, as it should be. */

void fatal(x)
int x;
{
 (void) setreuid(uid,uid);
 (void) exit(x);
 /*NOTREACHED*/
}

void fatalinfo(x,s)
int x;
char **s;
{
 while (*s)
  {
   serr(*(s++));
   serr("\n");
  }
 fatal(x);
 /*NOTREACHED*/
}

void fatalerr(x,s)
int x;
char *s;
{
 serr(s);
 fatal(x);
 /*NOTREACHED*/
}

void fatalerr2p(x,p,s,e)
int x;
char *p;
char *s;
int e;
{
 warnerr2(p,s);
 serr(": ");
 perr(e);
 serr("\n");
 fatal(x);
 /*NOTREACHED*/
}

void fatalerrp(x,s,e)
int x;
char *s;
int e;
{
 serr(s);
 serr(": ");
 perr(e);
 serr("\n");
 fatal(x);
 /*NOTREACHED*/
}
