/*
	pt.c	- show process family tree

	pt [-a] [user]

	Default compilation is for System V UNIX.
	To compile for a bsd system try :

	cc pt.c -o pt -O -DBSD
							*/

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#ifdef	BSD
#include <pwd.h>
#include <ctype.h>
#endif	BSD

#define	MAXLINE	256
#define	MYBUFSZ	256
#define	STDIN	0
#define	STDOUT	1
#define	STDERR	2

char line[MAXLINE], token[MAXLINE];
int firstr, cur_char, cur_row, cur_col;

#define	TRUE	1
#define	FALSE	0
#define	UNDEF	2

struct psl {
	char state[8];		/* S */
	char user[9];		/* UID */
	unsigned int pid;	/* PID */
	unsigned int ppid;	/* PPID */
	unsigned int pages;	/* SZ */
	char time[12];		/* TIME */
	char verb[32];		/* COMD */
};

struct plist {
	struct psl cp;
	struct plist *s;		/* sibling */
	struct plist *c;		/* child */
};

struct psl cp;
struct plist *proot;
struct plist *orphans;
int orphcnt;
int showroot = FALSE;
#ifdef	BSD
struct passwd *pe;
extern int errno;
#endif	BSD

extern char *malloc();
void strcpy2(), cp_plist(), pprint();
int pinsert();
struct plist *pfind();

void main(argc, argv)
int argc;
char **argv;
{
	int gls;
	int pfds[2];
	char who[9];
	int slen, wsp;
	char tbuf[32], tbuf2[32];
#ifdef	BSD
	char d1[32], d2[32], d3[32], d4[32], d5[32], d6[32], d7[32];
#endif
	struct plist *child;
	int fostered;
	int offset;
	int adopted;
	int i, j;

	if (argc == 1) who[0] = '\0';

	while (argc--) {
	  if (argc != 0) {
	    if (strcmp(argv[argc], "-a") == 0)
	      showroot = TRUE;
	    else
	      strcpy2(who, argv[argc], 8);
	  }
	}
	if (argc > 3) {
	  fprintf(stderr,"Usage : %s [-a] [user]\n", argv[0]);
	  exit(1);
	}
	if (strcmp(who, "root") == 0)
	  showroot = TRUE;

	orphcnt = 0;

	if (pipe(pfds) < 0) {
	    perror("pipe");
	    exit(1);
	}

	if (fork() == 0) {		/* BEGIN child processing */
	  if (close(STDOUT) < 0) {	/* release fd 1 */
	    perror("close1");
	    exit(1);
	  }
	  if (dup(pfds[1]) < 0) {	/* re-use fd 1 */
	    perror("dup1");
	    exit(1);
	  }
	  if (close(pfds[1]) < 0) {
	    perror("close2");
	    exit(1);
	  }
	  if (close(pfds[0]) < 0) {
	    perror("close3");
	    exit(1);
	  }
	  if (who[0] == '\0')
#ifdef	BSD
	    execl("/bin/ps","ps","-axlw",0);
#else
	    execl("/bin/ps","ps","-elf",0);
#endif	BSD
	  else 
#ifdef	BSD
	    execl("/bin/ps","ps","-axlw",0);	/* no single-user filter on bsd "ps" */
#else
	    execl("/bin/ps","ps","-u",who,"-lf",0);
#endif	BSD
	}				/* END child processing */

	if (close(STDIN) < 0) {		/* release fd 0 */
	  perror("close4");
	  exit(1);
	}
	if (dup(pfds[0]) < 0) {		/* re-use fd 0 */
	  perror("dup2");
	  exit(1);
	}
	if (close(pfds[0]) < 0) {
	  perror("close5");
	  exit(1);
	}
	if (close(pfds[1]) < 0) {
	  perror("close6");
	  exit(1);
	}

	firstr = TRUE;
	cur_row = 0;
	while ((gls = getline(STDIN, line, MAXLINE)) >= 0) {
	  if (gls == -2) break;
	  cur_char = 0;
	  cur_col = 0;
	  offset = FALSE;
#ifdef	BSD
	  d7[0] = '\0';
#endif	BSD
	  while (get_token(line, token, MAXLINE, &wsp) >= 0) {
	    if (cur_row > 0) {		/* skip column headings */
	      switch (cur_col) {
#ifdef	BSD
		case 0 :
		  if (((wsp > 0) && (strlen(token) > 5)) ||
		    ((wsp == 0) && (strlen(token) > 10))) {
		    j = 0;
		    for (i = (7 - wsp); i < strlen(token); i++)
		      tbuf[j++] = token[i];
		    tbuf[j+1] = '\0';
		    strcpy(token, tbuf);
		    cur_col += 1;
		    sscanf(token, "%d", &i);
		    if ((pe = getpwuid(i)) != NULL)
		      strcpy2(cp.user, pe->pw_name, 8);
		    else {
		      strcpy2(cp.user, "(bogus)", 8);
		      fprintf(stderr,"1: Checking UID %d : ",i);
		      perror("getpwuid");
		    }
		  }
		  else if ((wsp == 6) && (strlen(token) > 1)) {
		    cur_col += 1;
		    sscanf(token, "%d", &i);
		    if ((pe = getpwuid(i)) != NULL)
		      strcpy2(cp.user, pe->pw_name, 8);
		    else {
		      strcpy2(cp.user, "(bogus)", 8);
		      fprintf(stderr,"2: Checking UID %d : ",i);
		      perror("getpwuid");
		    }
		  }
		  break;	  
		case 1 :
		  sscanf(token, "%d", &i);
		  if ((pe = getpwuid(i)) != NULL)
		    strcpy2(cp.user, pe->pw_name, 8);
		  else {
		    strcpy2(cp.user, "(bogus)", 8);
		    fprintf(stderr,"3: Checking UID %d : ",i);
		    perror("getpwuid");
		  }	    
		  break;
		case 2 :
		  sscanf(token, "%d", &cp.pid);
		  break;
		case 3 :
		  sscanf(token, "%d", &cp.ppid);
		  break;
		case 7 :
		  if (strlen(token) > 4)
		    offset = TRUE;
		  break;
		case 8 :
		  if (offset == TRUE) {
		    strcpy2(d1, token, 32);
		  }
		  break;
		case 9 :
		  if (offset == TRUE) {
		    strcpy2(d2, token, 32);
		  }
		  else {
		    strcpy2(d1, token, 32);
		  }	    
		  break;
		case 10 :
		  if (offset == TRUE) {
		    strcpy2(d3,token, 32);
		  }
		  else {
		    strcpy2(d2, token, 32);
		  }	    
		  break;
		case 11 :
		  if (offset == TRUE) {
		    strcpy(d4, token, 32);
		  }
		  else {
		    strcpy2(d3, token, 32);
		  }
		  break;
		case 12 :
		  if (offset == TRUE) {
		    strcpy2(d5, token, 32);
		  }
		  else {
		    strcpy2(d4, token, 32);
		  }
		  break;
		case 13 :
		  if (offset == TRUE) { 
		    strcpy2(d6, token, 32);
		  }
		  else {
		    strcpy2(d5, token, 32);
		  }
		  break;
		case 14 :
		  if (offset == TRUE) {
		    strcpy2(d7, token, 32);
		  }
		  else {
		    strcpy2(d6, token, 32);
		  }
		  break;
#else
		case 1 :
		  cp.state[0] = token[0];
		  cp.state[1] = '\0';
		  if (strlen(token) > 1) {
		    strcpy2(cp.user, (token+1), 8);
		    cur_col += 1;
		  }
		  if ((cp.state[0] == 'R') || (cp.state[0] == 'O'))
		    offset = TRUE;	/* "WCHAN" is empty */
		  break;
		case 2 :
		  strcpy2(cp.user, token, 8);
		  break;
		case 3 :
		  sscanf(token, "%d", &cp.pid);
		  break;
		case 4 :
		  sscanf(token, "%d", &cp.ppid);
		  break;
		case 9 :
		  if (cp.state[0] == 'Z') {
		    cp.pages = 0;
		    break;
		  }
		  strcpy(tbuf,token);
		  if ((slen = strlen(token)) > 9 ) {
		    strcpy2(tbuf, token, (slen-9));
		    cur_col += 1;
		  }
		  sscanf(tbuf, "%d", &cp.pages);
		  break;
		case 12 :
		  if (offset == TRUE) {
		    strcpy2(cp.time, token, 12);
		  }
		  break;
		case 13 :
		  if (offset == TRUE) {
		    strcpy2(cp.verb, token, 32);
		  }
		  else {
		    strcpy2(cp.time, token, 12);
		  }
		  strcpy2(tbuf2, token, 12);
		  break;
		case 14 :
		  if (offset == FALSE) {
		    strcpy2(cp.verb, token, 32);
		  }
		  break;
#endif	BSD
	      }
	      cur_col += 1;
	    }
	  }
#ifdef	BSD
	
	  /* Sigh... */

	  if (isupper(d2[0]) || (d2[0] == 'p')) {
	    strcpy(cp.state, d2);
	    strcpy(cp.time, d4);
	    strcpy(cp.verb, d5);
	  }
	  else {
	    strcpy(cp.state, d3);
	    strcpy(cp.time, d5);
	    strcpy(cp.verb, d6);
	  }

#endif	BSD
	  if (cur_row > 0) {
#ifdef	BSD
	    if (who[0] == '\0')
	      pinsert(&cp, TRUE);
	    else
	      if (strcmp(cp.user, who) == 0)
	        pinsert(&cp, TRUE);
#else
	    pinsert(&cp, TRUE);
#endif	BSD
	  }
	  cur_row += 1;
	}
	wait(0);

	/* Place orphans into their foster homes */

	fostered = 0;

	while (orphcnt != fostered) {

	  adopted = FALSE;

	  for (child = orphans; child != NULL; child = child->s) {
	    if (strcmp(child->cp.state, "HOME") != 0) {
	      if (pinsert(&child->cp, FALSE) == TRUE) {
		strcpy(child->cp.state, "HOME");
	        fostered += 1;
		adopted = TRUE;
	      }
	    }
	  }
	  if (adopted == FALSE) {
	    break;
	  }
	}
	printf("PID\t\t\t    User     Time    Pages  S  Command\n");
	pprint(proot, 0, FALSE);
	if (orphcnt != fostered) {
	  printf("Orphans :\n");
	  printf("PID (PPID)\t\t    User     Time    Pages  S  Command\n");
	  pprint(orphans, 0, TRUE);
	}
}

int pinsert(cp, adopt)		/* TRUE = info inserted; FALSE = info orphaned */
struct psl *cp;
int adopt;			/* TRUE = add orphans to orphan list */
{
	struct plist *parent, *sibling;
	int iflag;

	iflag = TRUE;
	if (proot == NULL) {	/* call this one root for now */
	  if ((proot = (struct plist *) malloc(sizeof(struct plist))) == NULL) {
	    fprintf(stderr,"malloc failed\n");
	    exit(1);
	  }
	  cp_plist(proot, cp);
	}
	else {			/* find parent; traverse sibling list & insert */
	  if ((parent = pfind(proot, cp->ppid)) == NULL) {	/* no parent yet */
	    iflag = FALSE;
	    if (adopt == TRUE) {
	      orphcnt += 1;
	      if (orphans == NULL) {
	        if ((orphans = (struct plist *) malloc(sizeof(struct plist))) == NULL) {
	          fprintf(stderr,"malloc failed\n");
	          exit(1);
	        }
	        cp_plist(orphans, cp);
	      }
	      else {			/* chain orphans together (heartless!) */
	        for (sibling = orphans; sibling->s != NULL; sibling = sibling->s);
	        if ((sibling->s = (struct plist *) malloc(sizeof(struct plist))) == NULL) {
	          fprintf(stderr,"malloc failed\n");
	          exit(1);
	        }
	        cp_plist(sibling->s, cp);
	      }
	    }
	  }
	  else {			/* parent exists */
	    if (parent->c == NULL) {	/* first child */
	      if ((parent->c = (struct plist *) malloc(sizeof(struct plist))) == NULL) {
	        fprintf(stderr,"malloc failed\n");
	        exit(1);
	      }
	      cp_plist(parent->c, cp);
	    }
	    else {			/* siblings exist */
	      sibling = parent->c;
	      while (sibling->s != NULL) sibling = sibling->s;
	      if ((sibling->s = (struct plist *) malloc(sizeof(struct plist))) == NULL) {
	        fprintf(stderr,"malloc failed\n");
	        exit(1);
	      }
	      cp_plist(sibling->s, cp);
	    }
	  }
	}
	return(iflag);
}

struct plist *pfind(cp, ppid)
struct plist *cp;
int ppid;
{
	struct plist *p;

	if (cp == NULL) return(NULL);
	else if (cp->cp.pid == ppid) return(cp);
	else {
	  if ((p = pfind(cp->c, ppid)) == NULL)
	    return(pfind(cp->s, ppid));
	  else
	    return(p);
	}
}

void pprint(cp, cnt, orphflg)
struct plist *cp;
int cnt, orphflg;
{
	int i, j;
	char buf[16];

	if (cp == NULL) return;

	if (strcmp(cp->cp.state, "HOME") != 0) {
	  if (!((showroot == FALSE) && (strcmp(cp->cp.user, "root") == 0))) {
	    if (orphflg == TRUE) {
#ifdef	BSD
	      sprintf(buf, "%d (%d)",cp->cp.pid, cp->cp.ppid);
	      j = strlen(buf);
#else
	      j = sprintf(buf, "%d (%d)",cp->cp.pid, cp->cp.ppid);
#endif	BSD
	    }
	    else {
#ifdef	BSD
	      sprintf(buf, "%d", cp->cp.pid);
	      j = strlen(buf);
#else
	      j = sprintf(buf, "%d", cp->cp.pid);
#endif	BSD
	    }
	    for (i = 0; i < cnt; i++) printf(" ");
	    printf(" %s", buf);
	    for (i = 0; i < (3-(((cnt*1)+j+1)/8)); i++) printf("\t");
	    printf("%8s %8s %8d (%s) %s\n", cp->cp.user, cp->cp.time,
	      cp->cp.pages, cp->cp.state, cp->cp.verb);
	  }
	}

	pprint(cp->c, cnt+1, orphflg);
	pprint(cp->s, cnt, orphflg);
}

void cp_plist(pto, pfrom)
struct plist *pto;
struct psl *pfrom;
{
	strcpy(pto->cp.state, pfrom->state);
	strcpy(pto->cp.user, pfrom->user);
	pto->cp.pid = pfrom->pid;
	pto->cp.ppid = pfrom->ppid;
	pto->cp.pages = pfrom->pages;
	strcpy(pto->cp.time, pfrom->time);
	strcpy(pto->cp.verb, pfrom->verb);
	pto->c = pto->s = NULL;
}

int getline(fd,buf,max)
int fd;
char *buf;
int max;

/*
	getline(fd, buffer, max)

	Get a line from file *fd* up to *max* bytes into *buffer*.
	Return 0 if OK, -1 if hit EOF, -2 if first read is NULL,
	-3 if read failed.
								*/

{
	static char mybuf[MYBUFSZ];	/* internal buffer */
	static int myend = 0;		/* # bytes in mybuf */
	static int mycnt = 0;		/* # bytes already scanned */
	static char *curline = NULL;	/* beginning of current line to get */
	char *p, lastc;
	int nbytes;

	if (firstr == TRUE) curline = NULL;

	if (curline == NULL) {	/* empty buffer */
	  if ((myend = read(fd, mybuf, MYBUFSZ)) < 0) {
	    perror("read");
	    return(-3);
	  }
	  curline = mybuf;		/* new buffer filled */
	  mycnt = 0;
	}

	if ((myend == 0) && firstr) {	/* first read hit EOF (empty file) */
	  *buf = '\0';
	  return(-2);
	}

	if (myend == 0) {		/* later read hit EOF */
	  *buf = '\0';
	  return(-1);
	}

	firstr = FALSE;

	p = curline;
	nbytes = 0;

	read_loop:

	while ((*p != '\n') && (mycnt < myend) && (nbytes <= max)) {
	  *buf++ = *p++;
	  mycnt += 1;
	  nbytes += 1;
	}
	lastc = *p;
	p += 1;
	mycnt += 1;

	if ((mycnt >= myend) && (lastc != '\n')) {
	  if ((myend = read(fd, mybuf, MYBUFSZ)) < 0) {
	    perror("read");
	    return(-3);
	  }
	  p = curline = mybuf;
	  lastc = *p;
	  mycnt = 0;
	}
	if ((mycnt != myend) && (lastc != '\n')) goto read_loop;

	*buf += 1;
	*buf = '\0';
	curline = p;	/* set for next *getline* call */

	if (mycnt >= myend)
	  curline = NULL;	/* reached end of buffer */

	return(0);
}

int get_token(line, token, max, wsp)	/* return 0 = token, -1 = no tokens left on line */
char *line, *token;
int *wsp;				/* # of white spaces preceding token */
int max;
{
	int i, j;

	i = cur_char;
	j = 0;
	*wsp = 0;

	if ((i >= (max-1)) || (line[i] == '\0')) {
	  *token = '\0';
	  return(-1);
	}

	while((line[i] == ' ') || (line[i] == '\t')) {
	  i++;
	  *(wsp)++;
	}

	while ((line[i] != ' ') && (line[i] != '\t') && (line[i] != '\n')
	    && (line[i] != '\r') && (line[i] != '\0'))
	  token[j++] = line[i++];

	token[j] = '\0';

	if (line[i] != '\0') cur_char = i + 1;
	else cur_char = i;
	return(0);
}

void strcpy2(dst, src, max)
char *dst, *src;
int max;
{
	int i;

	i = 0;
	while ((src[i] != ' ') && (i < max) && (src[i] != '\0')) {
	  dst[i] = src[i];
	  i += 1;
	}
	dst[i] = '\0';
}
