#include <sys/types.h>
#include <sys/sysmacros.h>
#include <sys/param.h>
#include <sys/signal.h>
#include <sys/dir.h>
#include <sys/file.h>
#include <sys/proc.h>
#include <sys/lock.h>
#include <sys/user.h>
#include <stdio.h>

/*
 * psc - print status from core file
 *
 *	This program was written by John F. Haugh II, and is hereby
 *	placed in the public domain.  Use at your own risk ...
 *
 *	Author:
 *
 *	John F. Haugh II	(jfh@rpp386.uucp)
 *	19 July 1988
 *
 *	Synopsis:
 *
 *	psc [ corefile ]
 *
 *	Description:
 *
 *	psc reads the user page from the beginning of a core file and
 *	outputs some statistics.  The format is fairly similiar to the
 *	output produced by the `user' command in crash(1M).  Note that
 *	the I/O information is generally worthless since Unix sets
 *	up a write command to output the core file.
 *
 *	If corefile is omitted, psc defaults to the file named core in
 *	the current directory.
 *
 *	To Port:
 *
 *	The u-page is the first structure starting at the beginning
 *	of the core file.  This should be universally true for all AT&T
 *	Unixii and may be true for Berzerkeley Unix.  The only thing
 *	which may need to be changed is the u_base member of the user
 *	structure.  Look in /usr/include/sys/user.h for possible names
 *	for the base address for I/O.
 *
 *	The other big change has to do with the appropriate collection
 *	of include files.  There are dozens of possibilities.  But,
 *	fortunately only a finite number of combinations.
 *
 *	To Compile:
 *
 *	cc -o psc psc.c
 */

struct	user	user;
char	*corefile = "core";

main (argc, argv)
int	argc;
char	**argv;
{
	char	*segments[] = { "user", "system", "user i" };
	FILE	*cfp;

	if (argc != 0)
		corefile = argv[1];

	if ((cfp = fopen (corefile, "r")) == (FILE *) 0) {
		perror (corefile);
		exit (1);
	}
	if (fread ((char *) &user, sizeof user, 1, cfp) != 1) {
		perror (corefile);
		exit (1);
	}
	printf ("PER PROCESS USER AREA:\n");
	printf ("USER ID's:	uid: %d, gid: %d, real uid: %d, real gid: %d\n",
		user.u_uid, user.u_gid, user.u_ruid, user.u_rgid);
	printf ("PROCESS TIMES:	user: %d, sys: %d, child user: %d, child sys: %d\n",
		user.u_utime, user.u_stime, user.u_cutime, user.u_cstime);
	printf ("PROCESS MISC:	proc slot: %lx, cntrl tty: maj(%d) min(%d)\n",
		user.u_procp, major (user.u_ttyd), minor (user.u_ttyd));
	printf ("IPC:		locks:%s%s%s%s%s\n",
		user.u_lock == UNLOCK ? " unlocked":"",
		user.u_lock & PROCLOCK ? " proc":"",
		user.u_lock & TXTLOCK ? " text":"",
		user.u_lock & DATLOCK ? " data":"");
	printf ("FILE I/O:	user addr: %ld, file offset: %ld, bytes: %ld,\n",
#if defined(M_XENIX)
		user.u_baseu,
#else
		user.u_base,
#endif
		user.u_offset, user.u_count);
	printf ("		segment: %s, umask: %01o, ulimit: %ld\n",
		segments[user.u_segflg], user.u_cmask, user.u_limit);
	printf ("ACCOUNTING:	command: %s, memory: %ld, type: %s\n",
		user.u_comm, user.u_mem, user.u_acflag ? "fork":"exec");
	printf ("		start: %s",
		ctime (&user.u_start));
}
