;# ctime.pl is a simple Perl emulation for the well known ctime(3C) function.
;#
;# Waldemar Kebsch, Federal Republic of Germany, November 1988
;# kebsch.pad@nixpbe.UUCP
;# My private System: 80286 with Microport System V/AT 2.2
;#
;# usage:
;#
;#     #include <importenv.pl>      # see Perl library. We need the
;#                                  # environment variable TZ.
;#     #include <ctime.pl>          # see the -P and -I option in perl.man
;#     $Date = do ctime(time);

@DoW = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
@MoY = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

sub ctime {
    local($time) = @_;
    local($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
    local($date);

    ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst)
							  = localtime($time);
    $year += ($year < 70)? 2000: 1900;
    $date = sprintf("%s %s %2d %2d:%02d:%02d %s %4d\n",
	      $DoW[$wday], $MoY[$mon], $mday, $hour, $min, $sec, $TZ, $year);
    return $date;
}
