/*
 * make.h
 *
 * 88-10-01 v1.0	created by greg yachuk, placed in the public domain
 * 88-10-06 v1.1	changed prerequisite list handling
 * 88-11-11 v1.2	fixed some bugs and added environment variables
 * 89-07-12 v1.3	stop appending shell commands, and flush output
 * 89-08-01 v1.4 AB	lots of new options and code
 * 89-10-30 v1.5	-f -S -q options, took some changes from v1.4
 * 90-04-18 v1.6	-b -- -W options, emulate <<, non-BSD cleanup
 */

#define MAKEINI "default.mk"

#ifdef	MSDOS
#define	PATH_SEPARATOR	";"
#define	FILE_SEPARATOR	":/\\"
#define	SHELL_METAS	"<|>"
#else
#define	PATH_SEPARATOR	":"
#define	FILE_SEPARATOR	"/"
#define	SHELL_METAS	"<|>`*?()[];&$"
#endif

#define	MAXNEGTIME	0x80000000

#define	equal(s,t)		(!strcmp((s),(t)))
#define	get_target(t)		hash_target((t), NULL)
#define	get_file(f)		hash_file((f), NULL)
#define	append_preq(t,p)	(fileptr*)append_node((char**)(t),(char**)(p),sizeof(fileptr*))
#define	append_shell(t,s)	(shellptr*)append_node((char**)(t),(char**)(s),sizeof(shellptr*))

typedef unsigned short t_mask;

typedef struct targnode
{
	t_mask  tmask;		/* mask to avoid string compares */
	struct targnode *tnext;	/* next target in global target list */
	struct filenode *tfile;	/* file node for this target */
	struct filenode **tpreq;/* pre-req list for this target */
	struct shellnode **tshell;	/* command list for this target */
}       targnode, *targptr;

typedef struct filenode
{
	t_mask  fmask;		/* mask to avoid string compares */
	char   *fname;		/* name of this file (targ, preq...) */
	long    ftime;		/* last MODIFY time for this file */
	struct filenode *fnext;	/* next file node in global file list */
}       filenode, *fileptr;

typedef struct shellnode
{
	char   *scmd;		/* text of command */
	unsigned s_silent:1;	/* don't echo before executing */
	unsigned s_ignore:1;	/* ignore exit status */
	unsigned s_shell:1;	/* force spawning of command.com */
	struct shellnode *slink;/* next shell node in global list */
}       shellnode, *shellptr;

typedef struct symnode
{
	t_mask  smask;		/* mask to avoid string compares */
	char   *sname;		/* name of a symbol */
	char   *svalue;		/* value of a symbol */
	struct symnode *snext;	/* next symbol node in global list */
	int     scmd;		/* command line macro? */
	int     slevel;		/* level of new_make() */
}       symnode, *symptr;

typedef struct optnode
{
	unsigned depend;	/* -d */
	unsigned display:1;	/* -D */
	unsigned envirn:1;	/* -e */
	unsigned ignore:1;	/* -i */
	unsigned keepon:1;	/* -k */
	unsigned noexec:1;	/* -n */
	unsigned query:1;	/* -q */
	unsigned silent:1;	/* -s */
	unsigned touch:1;	/* -t */
	char   *make;		/* current value of $(MAKE) */
}       optnode;

extern targptr target_list;	/* global list of targets */
extern fileptr file_list;	/* global list of file nodes */
extern symptr symbol_list;	/* global list of symbol nodes */
extern shellptr shell_list;	/* global list of shell nodes */

extern char **shell_cmds;	/* commands which force usage of SHELL */

extern int make_level;		/* level of new_make() */

extern targptr first_targ;	/* first target (if nothing named) */
extern targptr suffix_targ;	/* target node of ".SUFFIXES" */

extern optnode opts;		/* various options */
extern char **tlist;		/* list of command line targets */
extern long now;		/* current time */

#ifndef	MSDOS
char   *getenv();

#define	P_WAIT		1
#define	P_NOWAIT	2
#define	P_OVERLAY	3
#endif				/* MSDOS */
