### this is the default makefile for Unix: default.mk

SUFFIXES = .o .C .cxx .ec .c .y .l .s .sh 
.SUFFIXES: $(SUFFIXES)

#	ASM section
AS	 = as
ASFLAGS	 =
COMPILE.s= $(AS) $(ASFLAGS)
.s:
	$(AS) $(ASFLAGS) $<
.s.o:
	$(AS) $(ASFLAGS) -o $@ $<

#	C section
CC	 = cc
CFLAGS	 = -O
CDEBUG	 = -g
COMPILE.c= $(CC) $(CFLAGS) -c
.c:
	$(LINK.c) -o $@ $< $(LDFLAGS)

.c.o:
	$(COMPILE.c) $<

.c.i:
	$(COMPILE.c) -P $<

#	CPP Section
CPP	 = CC
CPPFLAGS = -O
CPPDEBUG = -g
COMPILE.cpp = $(CPP) $(CPPFLAGS)
.C .cxx:
	$(CPP) $(CPPFLAGS) -o $@ $< $(LDFLAGS)

.C.o .cxx.o:
	$(COMPILE.cpp) $<

.C.c .cxx.c:
	$(COMPILE.cpp) -P $<

#	ESQL/C section
ESQL	 = esql
EFLAGS	 =
COMPILE.e= $(ESQL) $(EFLAGS)
.ec:
	$(COMPILE.e) -e $<
	$(LINK.c) -o $@ $*.c $(LDFLAGS)

.ec.o:
	$(COMPILE.e) -e $<
	$(COMPILE.c) $*.c

.ec.c:
	$(COMPILE.e) -e $<

#	Lex section
LEX	 = lex
LFLAGS	 =
LEX.l	 = $(LEX) $(LFLAGS) -t
.l:
	$(LEX.l) $< > $*.c
	$(LINK.c) -o $@ $*.c $(LDFLAGS) -ll

.l.o:
	$(LEX.l) $< > $*.c
	$(COMPILE.c) $*.c

.l.c:
	$(LEX.l) $< > $*.c

#	YACC section
YACC	 = yacc
YFLAGS	 =
YACC.y	 = $(YACC) $(YFLAGS)
.y:
	$(YACC.y) $<
	$(LINK.c) -o $@ y.tab.c $(LDFLAGS) -ly
	$(RM) y.tab.c

.y.o:
	$(YACC.y) $<
	$(COMPILE.c) -o $*.o y.tab.c
	$(RM) y.tab.c

.y.c:
	$(YACC) $(YFLAGS) $<
	$(MV) y.tab.c $@

.y.h:
	$(YACC) $(YFLAGS) -d $<
	$(RM) y.tab.c
	$(MV) y.tab.h $@

#	Shell script section
.sh:
	cp $< $@

#	BSD Unix Misc section
A        = .a
AR       = ar
ARFLAGS  =
BIN      = /usr/local/bin
CP       = cp
E        =
EDITOR   = /usr/bin/vi
GFLAGS   =
GET      = get
LDEBUG   =
LDFLAGS  =
LD       = ld
LIBDIR   =
LINK.c   = $(CC) $(CFLAGS)
MAKE     = make
MKDEPEND = makedepend
MODEL    =
MV       = mv
O        = .o
RANLIB   = ranlib
RM       = rm -f
SHELL    = /bin/csh
SHELLCMD =
STACK    =

#	DOS Misc section
#A        = .lib
#AR       = lib
#ARFLAGS  =
#BIN      = C:\bin
#CP       = cp
#E        = .exe
#EDITOR   = $(BIN)\vi
#GFLAGS   =
#GET      = echo cannot get
#LDEBUG   = /link /noe /noi /co /st:$(STACK) $(LIBS)
#LDFLAGS  = /link /noe /noi /st:$(STACK) $(LIBS)
#LD       = $(CC) $(CFLAGS)
#LIBDIR   = c:\msc5.1\lib
#LINK.c   = $(CC) $(CFLAGS)
#MAKE     = make
#MKDEPEND = mkdepend
#MODEL    = S
#MV       = mv
#O        = .o
#RANLIB   = echo cannot ranlib 
#RM       = rm -f
#SHELL    = command /c
#SHELLCMD = break call cd chcp chdir cls copy ctty date del dir \
#	   echo erase exit for goto if md mkdir path pause prompt \
#	   rd rem ren rename rmdir set shift time type ver verify vol
#STACK    = 2000
