/* work.c */
/**********************************************************************
*    File Name     : work.c
*    Function      : general pac subroutines
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"

clear_accwin()
{
    static char *fid = "clear_accwin";

    _TR
    mvaddstr(ACCUM,ULEFT,Sp44);
    TR_
}

/* pointer should sit on a null byte, as given by things like
   "buf + sizeof(buf)", fill backwards with spaces
   including the next null byte found. */
rev_clear(ptr)
char *ptr;
{
    register char *rp;
    static char *fid = "rev_clear";

    _TR
    for (rp = ptr;;)
        if (*--rp == '\0') {
            *rp = ' ';
             break;
        }
        else
             *rp = ' ';
    TR_
}

clear_wline(ver, lbound, rbound, video, lines)
int ver, lbound, rbound, video, lines;
{
    register ri, rj;
    static char *fid = "clear_wline";

    _TR
    if (!lines)
        lines = 1;
    if (video)
        standout();
    for (rj = ver+lines; --rj >= ver;) {
        move(rj, lbound);
        for (ri = rbound - lbound + 1; --ri >= 0; addch(' '));
    }
    if (video)
        standend();
    move(CY,CX);
    TR_
}

/* spacefills string to max: digit characters, appends '\0'; in Tokbuf.
   returns -1 if string is longer than digit */

spacefill(string, digits)
char *string;
int digits;
{
    register char *reg_c;
    register char r_count;
    static char *fid = "spacefill";

    _TR
    if ((r_count = strlen(string)) > digits) {
        TR_
        return(-1);
    }
    strcpy(Tokbuf, string);
    reg_c = &Tokbuf[r_count];
    while(r_count < digits ) {
        *reg_c++ = ' ';
        ++r_count;
    }
    Tokbuf[digits] = '\0';
    TR_
    return(0);
}

addto_controlbuf(c_ptr)
char *c_ptr;
{
    static char *fid = "addto_controlbuf";

    _TR
    strcat(Controlbuf, "\\\n"); /* prevent oversize input string */
    strcat(Controlbuf, c_ptr);
    TR_
}

addto_ubuf(c_ptr)
char *c_ptr;
{
    static char *fid = "addto_ubuf";

    _TR
    strcat(Ubuf, "\\\n"); /* prevent oversize input string */
    strcat(Ubuf, c_ptr);
    TR_
}

upcase(char_p)
char *char_p;
{
    register char *rcp = char_p;
    static char *fid = "upcase";

    _TR
    do
        if (isalpha(*rcp))
            *rcp &= 95;
    while (*rcp++ != '\0');
    TR_
}

pacinit()
{
    Format    = FORM_DFLT;
    (Format == COMMA_) ? (Separator = ',') : (Separator = ' ');
    Hf        = HF_DFLT;
    Ibase     = IB_DFLT;
    Oldib     = IB_DFLT;
    Obase     = OB_DFLT;
    Oldob     = OB_DFLT;
    Lastob    = OB_DFLT;
    Show      = SHOW_DFLT;
    Justify   = JUS_DFLT;
    Precision = PREC_DFLT;
    Stack     = STACK_DFLT;
    Staybase  = DISA;
    Autoconv  = DISA;
}

int
round(nump, endp)
char *nump, *endp;
{
    register char *fr, *to, *dp;
    int done = 0;
    int dpfound = 0;

    for (fr = nump, dp = endp; --dp >= fr;)
        if (*dp == '.') {
            dpfound = 1;
            break;
        }

    if (!dpfound)
        return(-1);

    fr = endp - 1;
    if (*fr < 53) { /* last digit less than 5 */
        *fr = '\0';
        return(0);
    }

    /* write new values in freed-up byte at right */
    for (to = endp - 1, done = 0; --fr > dp;) {
        if (*fr == '9')
            *to-- = '0';
        else {
            *to-- = *fr + 1;
            done = 1;
            break;
        }
    }

    if (done) { /* left-shift new values back 1 byte */
        for (dp = endp -1; to <= dp;)
            *fr++  = *++to;
        *dp = '\0';
        return(0);
    }

    *to-- = *fr; /* new decimal point */

    for (dp = nump, done = 0; --fr >= dp;) {
        if (*fr == '9')
            *to-- = '0';
        else {
            if (*fr > 47 && *fr < 57) {
                *to-- = *fr + 1;
                done = 1;
                break;
            }
            else {        /* fr got to the left of the first digit */
                *to = '1';
                return(1);
            }
        }
    }

    if (done) { /* left-shift new values back 1 byte */
        for (++to, dp = endp -1; to <= dp;)
            *fr++  = *to++;
        *dp = '\0';
        return(0);
    }

    *dp = '1';
    return(1);

}

