/* total.c */
/**********************************************************************
*    File Name     : total.c
*    Function      : pac checkbook balancer (totalizer)
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"
#define TOTALMAP
#include "maps.h"
#undef TOTALMAP

static double Su[FITCONV - 2];
static double Total;

total()
{
    int pyp, pxp;
    char curr_l[CONVMAX + 1];
    register int ri, rj;
    static int f_id = 0;
    int where, ck, copy;
    static char *fid = "total";
    
    _TR
    CYX;
    Tqlev = TALYREQ;
    if (Clockstat == DISA)
        Titlq[TALYREQ] = Sb[TALYREQ];
    else
        Titlq[TALYREQ] = Cb[TALYREQ];
    Basq[TALYREQ] = Bb[TALYREQ];
    standout();
    for (ri = FITCONV - 2, rj = 115; --ri >= 0; rj--)
        mvaddch(UTOP + ri, RBOUND, rj);
    mvaddch(TOP + FITCONV, RBOUND, 't');
    standend();
    clear_wline(TOP+FITCONV-1, CONVLEFT, RBOUND-2, 0, 1);
    show_items();
    show_total(0);
    update();
 
    while(1) {
    
        where = UTOP + f_id;
        if (Su[f_id] == 0.)
            clear_wline(where, CONVLEFT, RBOUND-2, 0, 1);
    

        ck = ledit(curr_l, tot_map, where, CONVLEFT, RBOUND-2, 0, 1, 1);
    
        if (!*curr_l)
            strcpy(curr_l, "0.0");

        switch(ck) {
            case 6:  /* wants to write file */
            case 16:
                if (Totcopy == ENA || Totcopy == AP) {
                    show_total(1);
                    Totcopy = DISA;
                    close(Tc);
                    Tc = -1;
                }
                else {
                    show_total(0);
                    (ck == 6) ? (Totcopy = ENA) : (Totcopy = AP);
                }
                hard(1);
                break;

            case 0:  /* normal return, did read line */
                show_line(f_id, curr_l);
                if (++f_id > FITCONV -3) {
                    show_total(1);
                    f_id = 1;
                    for (ri = FITCONV - 2; --ri > 0; Su[ri] = 0.);
                    Su[0] = Total;
                    show_items();
                }
                show_total(0);
                break;

            case 'T':
                show_line(f_id, curr_l);
                show_total(1);
                break;

            case 1:
                show_line(f_id, curr_l);
                show_total(ck);
                PYX;
                Basq[TALYREQ] = ZERO;
                update();
                pfresh();
                TR_
                return;

            case 3:   /* control-c, clear entire window */
                f_id = 0;
                for (ri = FITCONV - 2; --ri >= 0; Su[ri] = 0.);
                show_items();
                show_total(0);
                break;

            default:
                if (ck > 64 && ck < 84) {   /* A through S */
                    show_line(f_id, curr_l);
                    show_total(0);
                    f_id = ck - 'A';
                }
                else {
                    if ((copy = ck - 97) < FITCONV - 2) /* a to s */
                        sprintf(curr_l, "%*.*f", CONVMAX, Precision,
                            Su[copy]);
                    else /* t */
                        sprintf(curr_l, "%*.*f", CONVMAX, Precision,
                            Total);
                    show_line(f_id, curr_l);
                    if (++f_id > FITCONV -3) {
                        show_total(1);
                        f_id = 1;
                        for (ri = FITCONV - 2; --ri > 0; Su[ri] = 0.);
                        Su[0] = Total;
                        show_items();
                    }
                    show_total(0);
                }
                break;
        }
    }
}

show_total(transfer)
int transfer;
{
    char floatbuf[WINLINE];
    char hardbuf[WINLINE];
    register char *fb = floatbuf;
    register int rx;
    register int ri;
    struct  stk_cell *sr;
    static char *fid = "show_total";
    
    _TR
    Total = 0.;
    for (ri = FITCONV - 2; --ri >= 0; Total += Su[ri]);
    sprintf(fb, "%*.*f", CONVMAX, Precision, Total);
    if ((ri = strlen(floatbuf)) <= CONVMAX) {
        *(fb = floatbuf + ri++) = '.';
        *++fb = 0;
    }
    for (fb = floatbuf + ri; --fb >= floatbuf;)
        if (*fb == '.')
            break;
    if (fb < floatbuf)  {
        Total = 0.;
        sprintf(floatbuf, "%*.*f", CONVMAX, Precision, Total);
    }
    *((fb = floatbuf) + CONVMAX) = 0;
    mvaddstr(TOP + FITCONV, CONVLEFT, fb);
    if (transfer) {
        if (Tc != -1) {
            if (Hf != FXTER) {
                if ((write(Tc, "\n", 1)) != 1)
                    fatal("total write");
                for (ri = UTOP; ri < UTOP + FITCONV - 2; ri++) {
                    fb = hardbuf;
                    *fb++ = ri + 'a' - UTOP;
                    *fb++ = ' ';
                    *fb++ = ' ';
                    *fb++ = ' ';
                    for (rx = CONVLEFT; rx < RBOUND -1; rx++)
                        *fb++ = stdscr->_y[ri][rx] & 127;
                    *fb = '\n';
                    if ((write(Tc, hardbuf, 4+CONVMAX+1))
                        != 4+CONVMAX+1)
                        fatal("total 2 write");
                }
                if ((write(Tc,"    -----------------\nt   ", 26)) != 26)
                    fatal("total 3 write");
                if ((write(Tc, floatbuf, CONVMAX)) != CONVMAX)
                    fatal("total 4 write");
                if ((write(Tc, "\n\n", 2)) != 2)
                    fatal("total 5 write");
            }
            else {
                if ((write(Tc, floatbuf, CONVMAX)) != CONVMAX)
                    fatal("total 6 write");
                if ((write(Tc, "\n", 1)) != 1)
                    fatal("total 7 write");
            }
        }
        if (Stack == ENA)
            pushstack(1);
        /* strip trailing zeros */
        for (fb = floatbuf + strlen(floatbuf); --fb >= floatbuf;)
            if (*fb == '.')
                break;
        if (fb >= floatbuf) {
            for (fb += strlen(fb); *--fb == '0'; *fb = 0);
            if (*fb == '.')
                *fb = 0;
        }
        /* strip preceding spaces */
        for (fb = floatbuf; *fb == ' '; fb++);

        sr = find(1);
        sprintf(sr->cell, "%c %-*.*s", *(Base_str + 10),
            STACKMAX-2, STACKMAX-2, fb);
        show_stack();
    }
    TR_
}

show_line(f_id, buf)
int f_id;
char *buf;
{
    char floatbuf[WINLINE];
    char transbuf[WINLINE];
    register char *fb;
    register char *T = transbuf;
    char *secp;
    double thisval;
    double first = 0., second;
    int where, ri, oper = 0;
    static char *fid = "show_line";
    
    _TR
    where = UTOP + f_id;

    /* strip embedded spaces */
    fb = buf;
    while (*fb) {
        switch(*fb) {
            case ' ':
                break;
            case '*':
            case '@':
                *T++ = 0;
                secp = T;
                oper = 1;
                break;
            case '+':
                *T++ = 0;
                secp = T;
                oper = 2;
                break;
            default:
                *T++ = *fb;
                break;
        }
        fb++;
    }
    *T = 0;
    switch(oper) {
        case 0:
        default:
            thisval = atof(transbuf);
            break;
        case 1:
            if (*transbuf) 
                thisval = first = atof(transbuf);
            if (*secp) {
                second = atof(secp);
                thisval = first * second;
            }
            break;
        case 2:
            if (*transbuf) 
                thisval = first = atof(transbuf);
            if (*secp) {
                second = atof(secp);
                if (second != 0.)
                    thisval = first + second;
            }
            break;
    }
    Su[f_id] = thisval;
    sprintf(floatbuf, "%*.*f", CONVMAX, Precision, thisval);
    if ((ri = strlen(floatbuf)) <= CONVMAX) {
        *(fb = floatbuf + ri++) = '.';
        *++fb = 0;
    }
    for (fb = floatbuf + ri; --fb >= floatbuf;)
        if (*fb == '.')
            break;
    if (fb < floatbuf)  {
        Su[f_id] = 0.;
        sprintf(floatbuf, "%*.*f", CONVMAX, Precision, Su[f_id]);
    }
    *((fb = floatbuf) + CONVMAX) = 0;
    mvaddstr(where, CONVLEFT, floatbuf);
    TR_
}

show_items()
{
    char floatbuf[WINLINE];
    char *fb = floatbuf;
    register int ri;
    static char *fid = "show_items";

    _TR
    for (ri = FITCONV - 2; --ri >= 0;) {
        sprintf(fb, "%*.*f", CONVMAX, Precision, Su[ri]);
        *(fb + CONVMAX) = 0;
        mvaddstr(UTOP + ri, CONVLEFT, fb);
    }
    TR_
}
