/* time.c */
/**********************************************************************
*    File Name     : time.c
*    Author        : Istvan Mohos, 1987
***********************************************************************/


#ifdef pyr
#include <sys/time.h>
#else
#include <time.h>
#endif

#ifndef LOCALTEST
#include "defs.h"
#else
unsigned alarm();
int cdate();        /* signal has to know */
#include <stdio.h>
#include <signal.h>
char *Thisyear;
main()
{
    year();
    printf("%s<<\n", Thisyear);
    printf("%d", whichmonth("MAY"));
    cdate();
    for (;;);
}
#endif

#ifndef BADSIG
#define BADSIG        (int (*)())-1
#endif

cdate()
{
    long clock;
    int hour;
    register char *d;
    char ptr[30];
    int savy, savx, se;
    static char *fid = "cdate";

    _TR
    clock = time((long *) 0);    /* seconds since 1970 */
    d = ctime(&clock);
    strcpy(ptr, d);

    d = ptr + 8;
    if (*d == ' ') {
        *d = *(d+1);
        *++d = ' ';
    }
    d = ptr + 11;
    if (*d == '0')
        *d = ' ';
    if ((hour = atoi(d)) > 11) {    /* PM */
        if (hour > 12)
            sprintf(d, "%2d", hour -12);
        d+=2;
        *d = ':';
        d+=3;
        *d++ = '.';
    }
    else {
        d = ptr + 16;
        *d++ = ' ';
    }
    *d = '\0';  /* delete :seconds, year, newline */

#ifdef LOCALTEST
    printf("    01234567890123456789012\n>>>>%s<<<<\n", ptr);
    alarm(10);
    if (signal(SIGALRM, cdate) == BADSIG)
         exit(1);
#else
    getyx(stdscr, savy, savx);

#ifdef sun
    se = !((stdscr->_y[stdscr->_cury][stdscr->_curx] & 128));
#else
    se = (stdscr->_y[stdscr->_cury][stdscr->_curx] < 128);
#endif
    if (se)
        standout();
    mvaddstr(TOP,  CONVLEFT, ptr);
    if (se)
        standend();
    move(savy, savx);
    refresh();
    alarm(10);
    if (signal(SIGALRM, cdate) == BADSIG)
         fatal("clock signal");
    TR_
}

clockoff()
{
    static char *fid = "clockoff";

    _TR
    alarm(0);
    if (signal(SIGALRM, SIG_DFL) == BADSIG)
         fatal("clock signal at off");
    TR_
}

pfresh()
{
    static char *fid = "pfresh";
    _TR
    if (Clockstat == DISA)
        refresh();
    else {
        clockoff();
        refresh();
        cdate();
    }
#endif

    TR_
}

year()
{
    long clock;
    static char ptr[30];
    static char *fid = "year";

    _TR
    clock = time((long *) 0);
    strcpy(ptr, ctime(&clock));

    Thisyear = ptr + 20;
    *(ptr + 24) = '\0'; /* kill newline */
    TR_
}

whichmonth(ptr)
char *ptr;
{
    register int hv = 0;
    register char *hp;

    static char hashbuf[] = {
      12, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0,
       3, 0, 0, 4, 0, 0,10, 5, 9, 0, 0, 7, 0, 6, 0, 0, 0, 0, 0,11, };
    static char *fid = "whichmonth";

    _TR
    hp = ptr;
    if (hp == ZERO) {
        TR_
        return(0);
    }
    if (isalpha(*hp)) {
        hv += (*hp++ & 95);
        if (*hp) {
            hv += (*hp++ & 95);
            if (*hp)
                hv += (*hp & 95);
        }
        hv -= 204;
        if (hv < 0 || hv > 39) {
            TR_
            return(0);
    }
        return(hashbuf[hv]);
    }
    if ((hv = atoi(hp)) > 12 || hv < 1) {
        TR_
        return(0);
    }
    TR_
    return(hv);
}
