/* system.c */
/**********************************************************************
*    File Name     : system.c
*    Function      : clean up prior to pac exit, pipe readers
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"

go_away(message, die)
char *message;
int die;
{
    static char *fid = "go_away";
    int tput_ok = 1;

    _TR
    signal(SIGINT, SIG_IGN);
    signal(SIGHUP, SIG_IGN);
    signal(SIGTERM, SIG_IGN);
    signal(SIGQUIT, SIG_IGN);

    if (Context != INIT) {
        write_rc();
        clockoff();
        Clockstat = DISA;

        if (message != ZERO && *message == 'I') {
            standend();
            mvaddch(LINES-1, 0, ' ');
            clear();
            pfresh();
            mvcur(0, COLS-1, LINES-1, 0);
            endwin();
        }
        else {
            standend();
            mvaddch(LINES-1, 0, ' ');
            pfresh();
            mvcur(0, COLS-1, LINES-1, 0);
            endwin();
            fprintf(stderr, "\n");
        }
    }

    if (die)
        fprintf(stderr, "%s\n", ierbuf);
    TR_
    exit(die);
}

fatal(msg) /* kill pipes, print error messages and go_away */
char *msg;
{
    extern int errno, sys_nerr;
    extern char *sys_errlist[];

    if (A_ret)
        kill(A_ret, SIGTERM), A_ret = 0;
    if (B_ret)
        kill(B_ret, SIGTERM), B_ret = 0;
    go_away(ierbuf, ierror(msg, 1));
}

int
wait_main_pipe() /* empty main pipe to prevent deadlock */
          /* null delimited Mainbuf string may get PIPEMAX long */
{
    register ri;
    register char *accp1, *accp2;
    int done, totalread;
    static char *fid = "wait_main_pipe";

    _TR
    accp1 = Mainbuf;
    done = FALSE;
    totalread = 0;
    while (!done) {
        switch
           (Nread = read(A_read[0], accp1, PIPEMAX)) {
        case -1:
            fatal("wait main read");
        case  0:
            fatal("main bc: mysterious end of file");
        default:
            if ((totalread += Nread) >= PIPEMAX - 80)
                     fatal("main pipe overflow");
            accp2 = accp1;
            for (ri = Nread; --ri >= 0;) {
                if(*accp2 == '\n' && *(accp2 -1) != '\\') {
                    *(accp2) = '\0';
                    --totalread;
                    done = TRUE;
                    break;
                }
                ++accp2;
            }
            if (!done)
                accp1 = accp2;
            break;
        }
    }
    TR_
}

/* empty conv pipe into buf, to prevent deadlock.
   if  non-ZERO, buf size must not be less than PIPEMAX.
   if ZERO, Convbuf is used.  Null byte added at end of buf
*/
wait_conv_pipe(buf)
char *buf;
{
    register ri;
    register char *convp1, *convp2;
    int done, totalread;
    static char *fid = "wait_conv_pipe";

    _TR
    if (buf == ZERO)
        convp1 = Convbuf;
    else
        convp1 = buf;
    done = FALSE;
    totalread = 0;
    while (!done) {
        switch
           (Convread = read(B_read[0], convp1, PIPEMAX)) {
        case -1:
            fatal("wait conv read");
        case  0:
            fatal("conv: mysterious end of file");
        default:
            if ((totalread += Convread) >= PIPEMAX - 80)
                     fatal("conv pipe overflow");
            convp2 = convp1;
            for (ri = Convread; --ri >= 0;) {
                if(*convp2 == '\n' && *(convp2 -1) != '\\') {
                    *(convp2) = '\0';
                    --totalread;
                    done = TRUE;
                    break;
                }
                ++convp2;
            }
            if (!done)
                convp1 = convp2;
            break;
        }
    }
    TR_
}
