/* pactok.c */
/**********************************************************************
*    File Name     : pactok.c
*    Function      : pac calculator token recognizer
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"
#define PACTOK
#include "toktab.h"
#undef PACTOK

fill_spreadbuf(buffer)
char *buffer;
{
    register char *bp = buffer;
    register char *spr = Spreadbuf;
    register char prev_c = '\0';
    int first = 0;
    static char *fid = "fill_spreadbuf";

    _TR
    if (*bp == 42 || *bp == 43 || *bp == 45 || *bp == 47 || *bp == 94) {
        *spr++ = '\\';
        *spr++ = ' ';
    }
    while(*bp) {
        if ((ispunct(*bp)    && *bp != '.'    && *bp != '_')   ||
            (ispunct(prev_c) && prev_c != '.' && prev_c != '_'))
            *spr++ = ' ';   /* insert an extra space for pactok */

        if (*bp == ';')
            first = 1;
        else if (first) {
            if (*bp == 42 || *bp == 43 || *bp == 45 ||
                *bp == 47 || *bp == 94) {
                *spr++ = '\\';
                *spr++ = ' ';
                first = 0;
            }
            else if (!isspace(*bp))
                first = 0;
        }

        *spr++ = *bp;
        prev_c = *bp++;
    }
    *spr = '\0';
    if (Hc != -1) {
        *Tmpbuf = '\0';
        if (Hf == FVER) {
            strcpy(Tmpbuf,
"--------------------------------------------");
            spr = Tmpbuf + strlen(Tmpbuf);
            if (Ibase != 10) {
                sprintf(spr, " [ibase: %d]", Ibase);
                spr = Tmpbuf + strlen(Tmpbuf);
            }
            if (Obase != 10) {
                sprintf(spr, " [obase: %d]", Obase);
                spr = Tmpbuf + strlen(Tmpbuf);
            }
            strcat(Tmpbuf, "\n");
        }
        else if (Hf == FTER)
            strcpy(Tmpbuf, "===\n");
    }
    TR_
}

place_pointers()
{
    register int ri, rj;
    register char *cp;
    int thisnum;
    int prevnum;
    static char *fid = "place_pointers";

    _TR
    Tokp[0] = Mainbuf;
    /* take space and comma, unrecognized tokens (digits) will be
       automatically concatenated in Ubuf.
       This permits user formatted input. */

    if ((Tokp[1] = pactok(Spreadbuf, " ,")) == ZERO)
        strcpy(Spreadbuf, "\\");
    else {
        for (cp=Tokp[1], prevnum=1; *cp; cp++) {
            if (! (isdigit(*cp) || (*cp == '.') ||
                   (*cp >= 'a' && *cp <= 'f') ||
                   (*cp >= 'A' && *cp <= 'F'))  ) {
                prevnum = 0;
                break;
            }
        }
        ri = 1;
        while ((Tokp[++ri] = pactok(ZERO, " ,")) != ZERO) {
            for (cp=Tokp[ri], thisnum=1; *cp; cp++) {
                if (! (isdigit(*cp) || (*cp == '.') ||
                       (*cp >= 'a' && *cp <= 'f') ||
                       (*cp >= 'A' && *cp <= 'F'))  ) {
                    thisnum = prevnum = 0;
                    break;
                }
            }
            if (thisnum && prevnum) {
                strcat(Tokp[ri-1], Tokp[ri]);
                --ri;
            }
            if (thisnum)
                prevnum = 1;
        }
        Last = Tokp[ri];       /*  == ZERO */
    }

    if (Hc != -1) {
        if (Hf != FXTER) {
            for (rj = 1; rj < ri;) {
                strcat(Tmpbuf, Tokp[rj++]);
                strcat(Tmpbuf, " ");
            }
            strcat(Tmpbuf, "\n");
            rj = strlen(Tmpbuf);
            if (write(Hc, Tmpbuf, rj) != rj)
                fatal("hardcopy format write");
        }
    }
    TR_
    return(ri); /* # of non-ZERO tokens, including Tokp[0] = Mainbuf */
}

lookup(c_ptr)
char *c_ptr;
{
    int inlist_val;
    static char *fid = "lookup";

    _TR
        if ((inlist_val = spacefill(c_ptr, WORDSIZE)) != -1)
            inlist_val = mybsearch(Tokbuf, toklist, LISTSIZE);
    TR_
    return(inlist_val);
}

char *
pactok(s1, s2)
char *s1, *s2;
{
    register i;
    char *separator[128];
    int sepcount, tok_flag;
    static char *tokenp = ZERO, *parser = ZERO;
    static char *fid = "pactok";

    _TR
    if ((sepcount = strlen(s2)) == 0) {
        TR_
        return(ZERO);
    }
    if (s1 != ZERO)
        tokenp = parser = s1;
    for (i = sepcount; --i >= 0; separator[i] = s2 + i);

    /* move parser, tokenp to first non-separator character */
    while (*parser != '\0') {
        int sep_flag = 0;
        for (i = sepcount; --i >= 0;)
            if (*separator[i] == *parser) {
                ++parser;
                sep_flag = 1;
                break;
            }
        if (!sep_flag)
            break;
    }
    tokenp = parser;
    tok_flag = 0;

    /* move parser to first separator after token, replace value with '\0' */
    while (*parser != '\0') {
        int sep_flag = 0;
        for (i = sepcount; --i >= 0;)
            if (*separator[i] == *parser) {
                *parser++ = '\0';
                sep_flag = 1;
                break;
            }
        if (sep_flag)
            break;
        ++parser;
        tok_flag = 1;
    }

    if (tok_flag) {
        TR_
        return(tokenp);
    }
    TR_
    return(ZERO);
}

mybsearch (comparee, wordlist, listsize)
char *comparee;
char *wordlist[];
{
    register    m, mid, lo, hi;
    static char *fid = "mybsearch";

    _TR
    lo = 0, hi = listsize -1;
    while (lo <= hi) {
        mid = (lo + hi) >> 1;
        if ((m = strcmp(comparee, wordlist[mid])) < 0)
            hi = mid -1;
        else if (m > 0)
            lo = mid +1;
        else {
            TR_
            return(mid);
        }
    }
    TR_
    return (-1);
}
