/* pac.c */
/**********************************************************************
*    File Name     : pac.c
*    Object        : pac - 32 digit panel calculator
*    Compile       : makefile, use -DREALUNIX for sysV
*    Author        : Istvan Mohos, 1987
*    Version 1.0   : target completion date Aug 1987
*    Version 1.1   : sysV port, bug-fixes, tuning: Feb 1988
*    Version 1.2   : various excellent signal/attribute changes from
*                  :   uunet!auspex!guy (Guy Harris), Jul 19 1989
*                  : Xenix286 flags by rex!mgse!marks (Mark Seiffert)
***********************************************************************/

#define MAIN
#include "defs.h"
#undef MAIN
#define PACMAP
#include "maps.h"
#undef PACMAP

extern char *version;

main()
{

    char calbuf[LINEMAX];
    register char *uwcp;
    register int ri;
    int rj, wlen;
    int rc, intact = 0;

#ifdef DEBUG
    if ((Dfp = fopen("debugfile", "w")) == NULL)
        go_away("can't write debugfile", 1);
#endif

    Titlq[0] = Sb[0];
    Basq[0] = Bb[0];
    pipes();
    initscr();

/*  
even though I always strip off the eigth bit of fgetc, it may be a
good idea to set terminal parity to Space */
    raw();
    crmode();
    noecho();
    if (signal(SIGHUP, SIG_IGN) == SIG_DFL)
        signal(SIGHUP, go_away);
    if (signal(SIGINT, SIG_IGN) == SIG_DFL)
        signal(SIGINT, go_away);
    if (signal(SIGTERM, SIG_IGN) == SIG_DFL)
        signal(SIGTERM, go_away);
    if (signal(SIGQUIT, SIG_IGN) == SIG_DFL)
        signal(SIGQUIT, go_away);

    Context = TRUE;   /* go_away() instead of exit() on error */
    onlay();    /* don't need to "update()" */

    if ((Home = getenv("HOME")) == ZERO)
        Rcerr = TRUE;
    else {
        strcpy(Rcfile, Home);
        strcat(Rcfile, "/.pacrc");
    }
    if (!Rcerr) {
        if ((Rcfd = open(Rcfile, 0))  == -1)
            Rcerr = TRUE;
        else {
            read_rc();
            close(Rcfd);
        }
    }
    if (Rcerr) {
        setup_uconv();
        fill_stack(ZERO);
    }

    if (Autotime == ENA) {
        Clockstat = ENA;
        cdate();
    }
    Oldib = Ibase;
    Oldob = Obase;
    show_stack();
    show_uconv();
    show_loan(0);

/* window print field width:
123456789 123456789 123456789 123456789 1234
*/
    sprintf(Mop, "\
pac version: 1.2                            \
last remake: %-*.*s\
author: istvan mohos  0;ib a;pr %d;ob %c;ib %c",
        31,31,version,
        Precision, Base_str[Oldob], Base_str[Oldib]);

    strcpy(Uwin_copy, Mop);
    uwcp = Uwin_copy + strlen(Mop);  /* pad with spaces at end */
    wlen = (UBOT - UTOP) * (URIGHT+1 - ULEFT) - (uwcp - Uwin_copy);
    for (ri = wlen; --ri >= 0; *uwcp++ = ' ');
    *uwcp = '\0';

    interpret(Mop);
    move(CY=UTOP, CX=ULEFT);
    Painted = TRUE;   /* from now on, Mainbuf may be pushed on Stack */

    while (TRUE) {
        if (Clockstat == DISA)
            Titlq[Tqlev] = Sb[Tqlev];
        else
            Titlq[Tqlev] = Cb[Tqlev];

        if (O_conv == FALSE) {
            Basq[CONVREQ] = ZERO;
            update();
        }

        /* ledit starts with pfresh() */
        rc = ledit(calbuf,cal_map,0,ULEFT,URIGHT,0,0,intact);
        intact = 1;

        switch(rc) {

        default:
            break;

#ifdef DESIGN
        case 21 :                /* ^U */
            write_scr("rawscreen", 1);
            break;
        case 25 :                /* ^Y */
            write_scr("pacscreen", 0);
            break;
#endif

        case 1:                  /* ^A: ascii char to dec, hex, oct */
        case 4:                  /* ^D: 3 decimal digits to ... */
        case 15:                 /* ^O: 3 octal digits to ... */
        case 24:                 /* ^X: 2 hex digits to ... */
            byte_conv(rc);
            break;

        case 11 :
            if (Clockstat == DISA) { 
                Clockstat = ENA;
                cdate();
            }
            else {
                Clockstat = DISA;
                clockoff();
                update();
                pfresh();
            }
            break;                /* ^Klock  */

        case 6 :                  /* write to hardcopy */
        case 16 :
            if (Hardcopy == ENA || Hardcopy == AP) {
                Hardcopy = DISA;
                close(Hc);
                Hc = -1;
            }
            else
                (rc == 6) ? (Hardcopy = ENA) : (Hardcopy = AP);
            hard(0);
            break;

        case 12 :
            show_loan(1);
            break;                /* ^L show_loan */

        case 7:                   /* ^Globals */
            if (Statopts)
                show_stat();
            else
                show_param();
            break;

        case 14:                  /* ^N add new conversion */
            newconv();
            break;

        case 20:                  /* ^Total */
            total();
            break;

        case 61:                  /* '=' redo previous window */
            for (uwcp = Uwin_copy, rj = UTOP; rj <= UBOT; rj++)
                for (ri = ULEFT; ri <= URIGHT; ri++)
                    mvaddch(rj, ri, *uwcp++);
            move(CY=UTOP, CX=ULEFT);
            pfresh();
            break;

        case 0:
            intact = 0;
            if (*calbuf == '#') {
                if ( Hc != -1 && Hf != FXTER) {
                    for (uwcp=calbuf+strlen(calbuf); --uwcp > calbuf;)
                        if (*uwcp > 32)
                            break;
                    *++uwcp = '\n';
                    *++uwcp = '\0';
                    ri = strlen(calbuf);
                    if (write(Hc, calbuf, ri) != ri)
                        fatal("comment write");
                }
                break;
            }
            Oldib = Ibase;
            Oldob = Obase;
            strcpy(Uwin_copy, calbuf);
            interpret(calbuf);
            if (Staybase == DISA) {
                Obase = Oldob;
                Ibase = Oldib;
                sprintf(Mop, "ibase=A;obase=%d;ibase=%d\n",
                    Obase, Ibase);
                addto_controlbuf(Mop);
                show_result(0);
            }
            break;
        }
    }
}
