/* maps.h */
/**********************************************************************
*    File Name     : maps.h
*    Function      : input character mapping to line edit functions
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#ifdef AMORTMAP
static char loan_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  9, 10,  0,  1,  0,  0, 11,  7,  0,  0,  8,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
     10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  4,  0,  0,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL  */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11
};

static char date_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  0, 10,  0,  1,  0,  0, 11,  7,  0,  0,  0,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
     10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  2,  2,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  0,  4,  0,  0,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0, 11
};

static char amort_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  0, 10,  0,  1,  0,  0, 11,  7,  0,  0,  0,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
     10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  2,  2,  2,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  2,  0,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  4,  0,  2,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0, 11
};
#endif

#ifdef ATOIMAP
static char a_ed_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  0,  0,  0,  1,  0,  0, 11,  7,  0,  0,  0,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
     10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  4,  0,  0,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11
};

char *lotab[33] = {"asc NUL", "SOH  ^A", "STX  ^B", "ETX  ^C",
                   "EOT  ^D", "ENQ  ^E", "ACK  ^F", "BEL  ^G",
                   "BS   ^H", "HT   ^I", "LF   ^J", "VT   ^K",
                   "NP   ^L", "CR   ^M", "SO   ^N", "SI   ^O",
                   "DLE  ^P", "DC1  ^Q", "DC2  ^R", "DC3  ^S",
                   "DC4  ^T", "NAK  ^U", "SYN  ^V", "ETB  ^W",
                   "CAN  ^X", "EM   ^Y", "SUB  ^Z", "ESC  ^[",
                   "FS   ^|", "GS   ^]", "RS   ^`", "US   ^/",
                   "asc  SP"
};

#endif

#ifdef CONVMAP
static char c_ed_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  0, 10,  0,  1,  0,  0, 11,  7,  0,  0,  0,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
      2,  0,  0,  0,  0,  2,  0,  0,  2,  2,  2,  2,  0,  2,  2,  2,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  2, 20,  0, 19,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  4,  2,  2,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0, 11
};

static char eq_ed_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  0, 10,  0,  1,  0,  0, 11,  7,  0,  0,  0,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
      2,  0,  0,  0,  0,  2,  0,  0,  2,  2,  2,  2,  0,  2,  2,  2,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0, 20,  0, 19,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  2,  4,  2,  0,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11
};

static char c_sel_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  0,  0,  0,  1,  0,  0, 11,  7,  0,  0,  0,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  0,  0, 17,  0,  0,  0,  0,  0, 17,  0,  0,  0,  0,  0,  0,  
/*    P   Q  17   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  0,  0, 17,  0,  0,  0,  0,  0, 17,  0,  0,  0,  0,  0,  0,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL   */
      0,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11
};
#endif

#ifdef FILEMAP
static char f_ed_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  0, 10,  0,  1,  0,  0, 11,  7,  0,  0,  0,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
     10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  2,  2,  2,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0, 20,  2, 19,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  4,  0,  2,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0,  0,  0, 11
};
#endif

#ifdef PACMAP
static char cal_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0, 17, 17, 10, 17,  1, 17, 17, 11,  7, 17, 17, 17, 17, 17, 17,  
#ifdef DESIGN
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
     17,  0, 18,  0, 17, 17,  0,  0, 17, 17,  0, 20,  0,  0,  0,  0,  
#else
     17,  0, 18, 17, 17,  0,  0,  0, 17,  0,  0, 20,  0,  0,  0,  0,  
#endif
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
      2,  2,  0,  2,  0,  2,  0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  2, 20, 17, 19,  2,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  4,  2,  2,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL  */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 13, 15, 14,  0, 16
};
#endif

#ifdef TOTALMAP
static char tot_map[128] = {
/*   NL  ^A  ^B  ^C  ^D  ^E  ^F  ^G  ^H  ^I  ^J  ^K  ^L  ^M  ^N  ^O   */
      0,  0,  0, 12,  0,  1, 12,  0, 11,  7,  0,  0,  0,  0,  0,  0,  
/*   ^P  ^Q  ^R  ^S  ^T  ^U  ^V  ^W  ^X  ^Y  ^Z  ^[  ^|  ^]  ^`  ^/   */
     12,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  
/*   SP   !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   */
     10,  0,  0, 21,  0,  0,  0,  0,  0,  0,  2,  2,  0,  2,  2,  0,  
/*    0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   */
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  0, 20,  0, 19,  0,  
/*    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   */
      2, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  
/*    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   */
     12, 12, 12, 12, 12,  0,  0,  0,  0,  0,  0,  3,  0,  4,  0,  0,  
/*    `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   */
      0, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  
/*    p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~  DL  */
     12, 12, 12, 12, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11
};
#endif

#ifdef INTERMAP
static char *hundred[] = {
       "",        "", "1100100", "10201",
       "1210", "400", "244",     "202",
       "144",  "121", "100",     "91",
       "84",   "79",  "72",      "6A",
       "64" };

static char *sixteen[] = {
       "",    "",   "10000",  "121",
       "100", "31", "24",     "22",
       "20",  "17", "16",     "15",
       "14",  "13", "12",     "11",
       "10" };

 static char *factab[] = {
/*0*/ "x 0",
/*1*/ "x 1",
/*2*/ "x 2",
/*3*/ "x 6",
/*4*/ "x 18",
/*5*/ "x 78",
/*6*/ "x 2D0",
/*7*/ "x 13B0",
/*8*/ "x 9D80",
/*9*/ "x 58980",
/*10*/ "x 375F00",
/*11*/ "x 2611500",
/*12*/ "x 1C8CFC00",
/*13*/ "x 17328CC00",
/*14*/ "x 144C3B2800",
/*15*/ "x 13077775800",
/*16*/ "x 130777758000",
/*17*/ "x 1437EEECD8000",
/*18*/ "x 16BEECCA730000",
/*19*/ "x 1B02B9306890000",
/*20*/ "x 21C3677C82B40000",
/*21*/ "x 2C5077D36B8C40000",
/*22*/ "x 3CEEA4C2B3E0D80000",
/*23*/ "x 57970CD7E2933680000",
/*24*/ "x 83629343D3DCD1C00000",
/*25*/ "x CD4A0619FB0907BC00000",
/*26*/ "x 14D9849EA37EEAC91800000",
/*27*/ "x 232F0FCBB3E62C3358800000",
/*28*/ "x 3D925BA47AD2CD59DAE000000",
/*29*/ "x 6F99461A1E9E1432DCB6000000",
/*30*/ "x D13F6370F96865DF5DD54000000",
/*31*/ "x 1956AD0AAE33A4560C5CD2C000000",
/*32*/ "x 32AD5A155C6748AC18B9A580000000",
/*33*/ "x 688589CC0E9505E2F2FEE5580000000",
/*34*/ "x DE1BC4D19EFCAC82445DA75B00000000",
/*35*/ "x FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF"
};
#endif
