/* help.c */
/**********************************************************************
*    File Name     : help.c
*    Function      : overlay stack window with help list
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"
#include "toktab.h"

char *hlist[] = {
"!         factorial of n: 2*3*4*...n",
"#         comment from here to EOL  ",
"\'         sum ASCII bytes of nextok ",
";         separator btw. statements ",
"?         abbreviation for help     ",
"X         literal 16                ",
"\\         most recent result        ",
"amass     atomic mass unit, grams   ",
"and       binary bit-wise AND       ",
"arct      a(x) bc arctangent func.  ",
"astro     astronomical unit, km     ",
"at        abbreviation for autotime ",
"atto      * .000 000 000 000 000 001",
"au        abbreviation for autoconv ",
"auto      pac_err: defeat bc keyword",
"autoconv  on/off continuous convert ",
"autotime  turn clock on/off at start",
"avogadro  molecules per gram mole   ",
"boltzmann constant [k] ergs/Kelvin  ",
"break     pac_err: defeat bc keyword",
"bye       exit program; same as TAB ",
"chroma    440 * chroma: Bflat from A",
"clr       clear stack cell nextok   ",
"cm        use comma to format number",
"comma     use comma to format number",
"cos       c(x) bc cosine function   ",
"define    pac_err: defeat bc keyword",
"dontsave  don't write vars to .pacrc",
"dp        same as precision         ",
"ds        abbreviation for dontsave ",
"dup       duplicate stk cell nextok ",
"earthmass mass of earth in kg       ",
"earthrad  radius of earth in meters ",
"echarge   electron charge [e] esu   ",
"emass     electron mass at rest, g  ",
"euler     Euler-Mascheroni constant ",
"exa       *1,000,000,000,000,000,000",
"exit      exit program; same as ^E  ",
"exp       e(x) bc exponential func. ",
"faraday   constant [F] C/kmole      ",
"femto     * .000 000 000 000 001    ",
"fix       show fixed decimal point  ",
"fo        abbreviation for format   ",
"for       pac_err: defeat bc keyword",
"format    commas/spaces in result   ",
"g         acceleration at sea m/s2  ",
"gas       constant [Ro] erg/g mole K",
"giga      * 1,000,000,000           ",
"gravity   constant [G] N m2/kg2     ",
"h         value of stack cell h     ",
"hardform  verbose/terse/xt filedump ",
"heat      mechanical equiv [J] J/cal",
"help      briefly explain next token",
"hf        abbreviation for hardform ",
"i         value of stack cell i     ",
"ib        abbreviation for ibase    ",
"ibase     input radix (2 through 16)",
"if        pac_err: defeat bc keyword",
"init      pac to default parameters ",
"j         value of stack cell j     ",
"ju        abbreviation for justify  ",
"justify   left/right/fix display    ",
"k         value of stack cell k     ",
"kilo      * 1000                    ",
"l         value of stack cell l     ",
"le        abbreviation for left     ",
"left      ju le; print to left side ",
"length    pac_err: defeat bc keyword",
"light     velocity [c] km/s         ",
"lightyear distance covered/year km  ",
"log       l(x) bc log function      ",
"m         value of stack cell m     ",
"mega      * 1,000,000               ",
"micro     * .000 001                ",
"milli     * .001                    ",
"mod       integer mod, unlike bc %  ",
"mohos     clear to nextok, pactrace ",
"moonmass  lunar mass in kg          ",
"moonrad   radius of moon in meters  ",
"n         value of stack cell n     ",
"nano      * .000 000 001            ",
"natural   Naperian log base [e]     ",
"nmass     neutron mass at rest, g   ",
"not       bitwise, field nextok wide",
"o         value of stack cell o     ",
"ob        abbreviation of obase     ",
"obase     output radix (2 thru 16)  ",
"off       disable capability        ",
"on        enable capability         ",
"or        binary, bit-wise OR       ",
"p         value of stack cell p     ",
"parallax  solar, in seconds of arc  ",
"parsec    (parallax + sec2) in km   ",
"pd        percent diff (pdiff)      ",
"pdelta    percent diff (pdiff)      ",
"pdiff     % diff of curtok to nextok",
"pe        percent equal (pequal)    ",
"pequal    curtok% = nextok; total?  ",
"peta      * 1,000,000,000,000,000   ",
"pi        3.1415... (32 hex digits) ",
"pico      * .000 000 000 001        ",
"planck    constant [h] erg sec      ",
"pll       stk cell nextok to curres ",
"pm        percent minus (pminus)    ",
"pmass     proton mass at rest, g    ",
"pminus    subtract nextok percent   ",
"po        percent of (pof)          ",
"pof       what is curtok% of nextok ",
"pop       discard stack cell nextok ",
"pp        percent plus (pplus)      ",
"pplus     add nextok percent        ",
"pr        abbreviation of precision ",
"precision digits used past dp (0-32)",
"psh       curres to stk cell nextok ",
"pv        percent versus (pversus)  ",
"pversus   curtok = 100 %, nextok ? %",
"q         value of stack cell q     ",
"quit      exit program; same as ^E  ",
"r         value of stack cell r     ",
"ri        abbreviation of right     ",
"right     right justify result      ",
"rydberg   constant per meter        ",
"s         value of stack cell s     ",
"sb        abbreviation of staybase  ",
"scale     alias of precision        ",
"sin       s(x) bc sine function     ",
"sound     air speed @ 15 Celsius m/s",
"sp        use space to format number",
"space     use space to format number",
"sqrt      sqrt(x) bc square root    ",
"st        abbreviation of 'stack on'",
"stack     save last 16 results      ",
"staybase  make next radix permanent ",
"stefan    Stefan-Boltzmann J/m2 K4 s",
"sto       store curres in stack cell",
"sunmass   solar mass kg             ",
"sunrad    radius of sun in meters   ",
"swp       swap curres, stack nextok ",
"t         value of stack cell t     ",
"te        abbreviation of terse     ",
"tera      * 1,000,000,000,000       ",
"terse     hardcopy file format      ",
"to        convert curres to nextok  ",
"tomoon    distance from earth, km   ",
"tosun     distance from earth, km   ",
"tw        abbreviation of twoscomp  ",
"twoscomp  bitwise, field nextok wide",
"u         value of stack cell u     ",
"v         value of stack cell v     ",
"ver       abbreviation of verbose   ",
"verbose   hardcopy file format      ",
"w         value of stack cell w     ",
"while     pac_err: defeat bc keyword",
"wien      displacement constant cm K",
"x         the number 16             ",
"xor       curres xor-ed with nextok ",
"xt        abbreviation of xterse    ",
"xterse    hardcopy file format      ",
};

#define HCENTER 6
#define TOFIT   (STACKDEEP - HCENTER)

show_help(cursel)
int cursel;
{
    register ri;
    static int tophelp;
    static char *fid = "show_help";

    _TR
    if (cursel < HCENTER)
        tophelp = 0;
    else if (cursel >= LISTSIZE - TOFIT)
        tophelp = LISTSIZE - STACKDEEP;
    else
        tophelp = cursel - HCENTER + 1;

    for (ri = 0; ri < STACKDEEP; ri++) {
        mvaddstr(ri + STACKTOP, STACKLEFT, hlist[ri + tophelp]);
    }

    standout();
    for (ri = 0; ri < STACKDEEP; ri++) {
        mvaddch(ri + STACKTOP, LBOUND, ' ');
    }
    mvaddstr(STACKTOP + cursel - tophelp, STACKLEFT, hlist[cursel]);
    standend();
TR_
}

