/* file.c */
/**********************************************************************
*    File Name     : file.c
*    Function      : file i/o of pac: rc, hardcopies, debug files
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"
#define FILEMAP
#include "maps.h"
#undef FILEMAP

#define RCMIN  (STACKDEEP * (STACKMAX + 1) + 53) /* minimum count */
read_rc()
{
    char rcbuf[PIPEMAX];
    register char *rc = rcbuf;
    static char *fid = "read_rc";

    _TR
    if (read(Rcfd, rc, RCMIN) < RCMIN) {
        mvaddstr(2,4,"Rcerr after RCMIN");
        pfresh();
        Rcerr = TRUE;
        TR_
        return;
    }
    if ((Format = *rc++ -48)!=COMMA_ && Format!=SPACE_ && Format!=DISA)
        Format = FORM_DFLT;
    (Format == COMMA_) ? (Separator = ',') : (Separator = ' ');

    if ((Hf = *rc++ -48) != FVER && Hf != FTER && Hf != FXTER)
        Hf = HF_DFLT;
    if ((Ibase = *rc++ -48) < 2 || Ibase > 16)
        Ibase = IB_DFLT;
    if ((Justify = *rc++ -48) != JL && Justify != JF && Justify != JR)
        Justify = JUS_DFLT;
    if ((Obase = *rc++ -48) < 2 || Obase > 16)
        Obase = OB_DFLT;
    if ((Precision = *rc++ -48) < 0 || Precision > 32)
        Precision = PREC_DFLT;
    if ((Autotime = *rc++ -48) != ENA && Autotime != DISA)
        Autotime = DISA;
    if ((Stack = *rc++ -48) != ENA && Stack != DISA)
        Stack = STACK_DFLT;
    if ((Staybase = *rc++ -48) != ENA && Staybase != DISA)
        Staybase = SB_DFLT;
    if ((Convcount = atoi(rc)) > 255 || Convcount < CONVCOUNT) {
        mvaddstr(2,4,"Rcerr at Convcount");
        pfresh();
        Rcerr = TRUE;
        TR_
        return;
    }
    rc += 4;
    if ((Convsel = atoi(rc)) < 0 || Convsel > Convcount -1)
        Convsel = CONVSEL;
    rc += 4;
    if ((Convhsiz = atoi(rc)) < 1) {
        mvaddstr(2,4,"Rcerr after Convhsiz");
        pfresh();
        Rcerr = TRUE;
        TR_
        return;
    }
    rc += 6;
    if ((Amt = atof(rc)) < 0.)
        Amt = 0.;
    rc += 14;
    if ((Years = atof(rc)) < 0.)
        Years = 0.;
    rc += 8;
    if ((Rate = atof(rc)) < 0.)
        Rate = 0.;
    rc += 8;

    fill_stack(rc);

    if ((Convhom = malloc(Convhsiz)) == ZERO)
        fatal("malloc error at read_rc");

    if (read(Rcfd, Convhom, (int)Convhsiz) != Convhsiz) {
        mvaddstr(2,4,"Rcerr after Convhom");
        pfresh();
        Rcerr = TRUE;
        TR_
        return;
    }

    for (rc = Convhom + Convhsiz; --rc > Convhom;)
        if (*rc == '\n')
            *rc = 0;
 
    realign_conv();
    TR_
}

write_rc()
{
    char rcbuf[PIPEMAX];
    register char *rc = rcbuf;
    static char *fid = "write_rc";

    _TR
    if (Home != ZERO && !Dontsave) {
        if ((Rcfd = open(Rcfile, O_WRONLY | O_CREAT, 0600)) != -1) {

            *rc++ = Format +48;
            *rc++ = Hf +48;
            *rc++ = Ibase +48;
            *rc++ = Justify +48;
            *rc++ = Obase +48;
            *rc++ = Precision +48;
            *rc++ = Autotime +48;
            *rc++ = Stack +48;
            *rc++ = Staybase +48;
            sprintf(rc, "%3d;%3d;%5d\n", Convcount, Convsel, Convhsiz);
            rc += 14;
            sprintf(rc, "%13.2f", Amt);
            rc += 13;
            *rc++ = ';'; /* printf too generous on overflow*/
            sprintf(rc, "%7.3f", Years);
            rc += 7;
            *rc++ = ';';
            sprintf(rc, "%7.3f", Rate);
            rc += 7;
            *rc++ = '\n';

            save_stack(rc, 0);

            if ((write(Rcfd, rcbuf, RCMIN)) != RCMIN)
                fatal("pacrc stack write");

            for (rc = Convhom + Convhsiz; --rc > Convhom;)
                if (*rc == '\0')
                    *rc = '\n';
            if ((write(Rcfd, Convhom, (int)Convhsiz)) != (int)Convhsiz)
                fatal("pacrc conv write");

            close(Rcfd);
       }
    }
    TR_
}

#ifdef DESIGN
read_scr(name)        /* read screen image from named file */
char *name;
{
    FILE *fp;
    register rx, ry;
    static char *fid = "read_scr";

    _TR
    if ((fp = fopen(name, "r")) != NULL) {
        for (ry = 0; ry < LINES; ry++)
            for (rx=0; rx < COLS-1; rx++)
                stdscr->_y[ry][rx] = fgetc(fp);
        fclose(fp);
    }
    TR_
}

write_scr(name, rf)
char *name;
int rf;
{
    FILE *fp;
    register rx, ry;
    static char *fid = "write_scr";

    _TR
    if ((fp = fopen(name, "w")) == NULL)
        Status = 1, fatal("write image");
    if (rf)
        for (ry = 0; ry < LINES; ry++)
            for (rx=0; rx < COLS-1; rx++)
                putc(stdscr->_y[ry][rx] & 0377, fp);
    else
        for (ry = 0; ry < LINES; ry++) {
            for (rx=0; rx < COLS-1; rx++)
                putc(stdscr->_y[ry][rx] & 127, fp);
            putc('\n', fp);
        }
    fclose(fp);
    TR_
}
#endif

hard(fnum)
int fnum;
{
    int newlev;
    int pyp, pxp;
    int *whichfile, *whichfd;
    char *np;
    char *whichname;
    char namebuf[TITSIZ + 1];
    char spaceless[TITSIZ + 1];
    static char *fid = "hard";

    _TR
    if (fnum) {
        whichname = Totname;
        whichfd = &Tc;
        if (*(whichfile = &Totcopy) == ENA)
            newlev = TOTLREQ;
        else if (*whichfile == AP)
            newlev = TAPPREQ;
        else {
            newlev = TALYREQ;
            Basq[TOTLREQ] = ZERO;
            Basq[TAPPREQ] = ZERO;
        }
    }
    else {
        whichname = Hardname;
        whichfd = &Hc;
        if (*(whichfile = &Hardcopy) == ENA)
            newlev = FILEREQ;
        else if (*whichfile == AP)
            newlev = POSTREQ;
        else {
            newlev = 0;
            Basq[FILEREQ] = ZERO;
            Basq[POSTREQ] = ZERO;
        }
    }
    Basq[newlev] = Bb[newlev];
    Basq[EDITREQ] = Bb[newlev];
    CYX;  /* to save the caller's coordinates */
    update();  /* this returns to the original coordinates,
                  but does'nt pfresh */
    
    if (*whichfile == ENA || *whichfile == AP) {

redo:

        ledit(namebuf, f_ed_map, BOT, FBOUND, RBOUND, 1, 1, 0);

        if (strlen(namebuf) == 0) {
            strcpy(spaceless, whichname);
            for (np = spaceless; *np > 32; np++);
            *np = '\0';
            standout();
            mvaddstr(BOT, FBOUND, whichname);
            standend();
            pfresh();
        }
        else {
            strcpy(whichname, namebuf);
            strcpy(spaceless, namebuf);
        }

        if (*whichfile == ENA) {
            if ((*whichfd = open(spaceless,
            O_WRONLY | O_CREAT | O_TRUNC, 0644)) == -1) {
                standout();
                mvaddstr(BOT, ULEFT, "can't access:");
                standend();
                pfresh();
                goto redo;
            }
        }
        else if ((*whichfd = open(spaceless,
            O_WRONLY | O_APPEND | O_CREAT, 0644)) == -1) {
                standout();
                mvaddstr(BOT, ULEFT, "can't access:");
                standend();
                pfresh();
                goto redo;
        }
        /* make a copy of name in alternate buffer also */
        if (*whichfile == AP) {
            strcpy(Bb[newlev - 1] + BUFSTOP, whichname);
            rev_clear(Bb[newlev - 1] + TITSIZ);
        }
        else {
            strcpy(Bb[newlev + 1] + BUFSTOP, whichname);
            rev_clear(Bb[newlev + 1] + TITSIZ);
        }
        strcpy(Bb[newlev] + BUFSTOP, whichname);
        rev_clear(Bb[newlev] + TITSIZ);
        Basq[EDITREQ] = ZERO;
    }
    PYX;
    update();
    pfresh();
    TR_
}
