/* error.c */
/**********************************************************************
*    File Name     : error.c
*    Function      : handling of error messages
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"

e_syntax()
{
    static char *fid = "e_syntax";

    _TR
    if (strncmp(Mainbuf, "syntax error", 12) == 0) {
        if (write(A_write[1], "0\n", 2) == -1)
            fatal("error recovery to main pipe write");
        /* read back a zero, so next error won't hang bc pipe */
        wait_main_pipe();
        standout();
        move(MSG, MSGLEFT);
        printw("bc: syntax error                 ");
        if (Hc != -1 && Hf == FVER)
            if ((write(Hc, "ERROR: syntax\n", 14)) != 14)
                fatal("error recovery hardcopy write");
        standend();
        Bc_error = E_SYNTAX;
    }
TR_
}

e_bcexec()
{
    static char *fid = "e_bcexec";

    _TR
    if (strncmp(Mainbuf, "save:args", 9) == 0) {
        if (write(A_write[1], "0\n", 2) == -1)
            fatal("error recovery to main pipe write");
        /* read back a zero, so next error won't hang bc pipe */
        wait_main_pipe();
        standout();
        move(MSG, MSGLEFT);
        printw("bc: bc calculator failure        ");
        if (Hc != -1 && Hf == FVER)
            if ((write(Hc, "ERROR: bcexec\n", 14)) != 14)
                fatal("error recovery hardcopy write");
        standend();
        Bc_error = E_BCEXEC;
    }
TR_
}

e_divby0()
{
    static char *fid = "e_divby0";

    _TR
    if (strncmp(Mainbuf, "divide by 0", 11) == 0) {
        Mainbuf[0] = '0';
        Mainbuf[1] = '\0';
        standout();
        move(MSG, MSGLEFT);
        printw("bc: divide by 0 error            ");
        if (Hc != -1 && Hf == FVER)
            if ((write(Hc, "ERROR: divide by 0\n", 19)) != 19)
                fatal("divby0 hardcopy write");
        standend();
        Bc_error = E_DIVBY0;
    }
TR_
}

e_exponent()
{
    static char *fid = "e_exponent";

    _TR
    if (strncmp(Mainbuf, "exp not an integer", 18) == 0) {
        Mainbuf[0] = '0';
        Mainbuf[1] = '\0';
        standout();
        move(MSG, MSGLEFT);
        printw("bc: non-integer exponent error   ");
        if (Hc != -1 && Hf == FVER)
            if ((write(Hc, "ERROR: exponent not integer\n", 28)) != 28)
                fatal("non-int exponent hardcopy write");
        standend();
        Bc_error = E_EXPONENT;
    }
    else if (strncmp(Mainbuf, "exp too big", 11) == 0) {
        if (write(A_write[1], "0\n", 2) == -1)
            fatal("exp2big main pipe write");
        /* read back a zero, so next error won't hang bc pipe */
        wait_main_pipe();
        Mainbuf[0] = '0';
        Mainbuf[1] = '\0';
        standout();
        move(MSG, MSGLEFT);
        printw("bc: exponent too big error       ");
        if (Hc != -1 && Hf == FVER)
            if ((write(Hc, "ERROR: exponent too big\n", 24)) !=  24)
                fatal("exp2big hardcopy write");
        standend();
        Bc_error = E_EXPONENT;
    }
TR_
}

e_overflow()
{
    static char *fid = "e_overflow";

    _TR
    if (Has_dp == FALSE) { /* don't really care if some digits beyond
                              the dp fall off, in this case */
        standout();
        move(MSG, MSGLEFT);
        printw(" panel overflow: 32 digits max.  ");
        if (Hc != -1 && Hf == FVER)
            if ((write(Hc, "ERROR: overflow\n", 16)) !=  16)
                fatal("overflow hardcopy write");
        standend();
        Bc_error = E_OVERFLOW;
    }
TR_
}

pac_err(message)
char *message;
{ 
    char msg[35];
    static char *fid = "pac_err";

    _TR
    strcpy(msg, Sp34); 
    if (strlen(message) > 22)
        *(message + 22) = '\0';
    sprintf(msg, "pac error: %-*s", 22, message);
    standout();
    move(MSG, MSGLEFT);
    printw(msg);
    standend();
    pfresh();
TR_
}

