/* convbase.c */
/**********************************************************************
*    File Name     : convbase.c
*    Function      : use second bc pipe for conversion between radices
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"
#include "toktab.h"
#define INTERMAP
#include "maps.h"
#undef INTERMAP

char *
substivar(found, token, ib)
char *token;
int found, ib;
{ 
    static char res[PIPEMAX];
    static struct stk_cell *sr = &Stk[0];
    static char *fid = "substivar";
    char *ret = res;
    int tokval;

    _TR
    if (found == -1) {
        if (token == ZERO) {
            TR_
            return(ZERO);
        }
        tokval = lookup(token);
    }
    else
        tokval = found;

    switch(tokval) {
        case H_:
        case I_:
        case J_:
        case K_:
        case L_:
        case M_:
        case N_:
        case O_:
        case P_:
        case Q_:
        case R_:
        case S_:
        case T_:
        case U_:
        case V_:
        case W_:
            onereg(*token - 'g');
            conv_bc(Onebuf, res, 1, ib);
            break;

case PI: conv_bc("3.1415926535897932384626433832795028841971693993751",
                    res, 10, ib); break;
case ASTRO:     conv_bc("149504200", res, 10, ib); break;
                    /* km */
case AMASS:     conv_bc(".00000000000000000000000165975",
                    res, 10, ib); break; /* grams */
case AVOGADRO:  conv_bc("602502000000000000000000",
                    res, 10, ib); break; /* per g mole */
case BOLTZMANN: conv_bc(".000000000000000138040", res, 10, ib); break;
                    /* erg/Kelvin */
case ECHARGE:   conv_bc(".000000000160202", res, 10, ib); break;
                    /* esu */
case CHROMA:    conv_bc("1.0594631", res, 10, ib); break;
case EMASS:     conv_bc(".000000000000000000000000000910820",
                    res, 10, ib); break; /* grams */
case EULER:     conv_bc(".577216", res, 10, ib); break;
case FARADAY:   conv_bc("96521900", res, 10, ib); break;
                    /* C/kmole */
case G_:        conv_bc("9.80665", res, 10, ib); break;
                    /* m/s2 */
case GAS:       conv_bc("83169600", res, 10, ib); break;
                    /* erg/g mole Kelvin */
case GRAVITY:   conv_bc(".00000000006673", res, 10, ib); break;
                    /* N m2/kg2 */
case HEAT:      conv_bc("4.1855", res, 10, ib); break;
                    /* J/cal */
case LIGHT:     conv_bc("299792.50", res, 10, ib); break;
                    /* km/sec */
case LIGHTYEAR: conv_bc("9460530000000", res, 10, ib); break;
                    /* km */
case MOONMASS:  conv_bc("73430000000000000000000", res, 10, ib); break;
                    /* kg */
case SUNMASS:   conv_bc("1987000000000000000000000000000",
                    res, 10, ib); break; /* kg */
case EARTHMASS: conv_bc("5976500000000000000000000",
                    res, 10, ib); break; /* kg */
case NATURAL:   conv_bc("2.7182818284590452353602874713526",
                    res, 10, ib); break;
case NMASS:     conv_bc(".00000000000000000000000167465",
                    res, 10, ib); break; /* grams */
case PARSEC:    conv_bc("30837450000000", res, 10, ib); break;
                    /* km */
case PARALLAX:  conv_bc("8.794", res, 10, ib); break;
                    /* " */
case PLANCK:    conv_bc(".00000000000000000000000000662491",
                    res, 10, ib); break; /* erg sec */
case PMASS:     conv_bc(".00000000000000000000000167235",
                    res, 10, ib); break; /* grams */
case MOONRAD:   conv_bc("1738000", res, 10, ib); break;
                    /* meters */
case SUNRAD:    conv_bc("696500000", res, 10, ib); break;
                    /* meters */
case EARTHRAD:  conv_bc("6378388", res, 10, ib); break;
                    /* meters */
case RYDBERG:   conv_bc("10973732.8", res, 10, ib); break;
                    /* per meter */
case SOUND:     conv_bc("340.505", res, 10, ib); break;
                    /* meters/sec: 331.4 + (.607 * Celsius) */
case STEFAN:    conv_bc(".000000056693", res, 10, ib); break;
                    /* J/m2 Kelvin4 sec */
case TOMOON:    conv_bc("384400", res, 10, ib); break;
                    /* km */
case TOSUN:     conv_bc("149500000", res, 10, ib); break;
                    /* km */
case WIEN:      conv_bc(".289778", res, 10, ib); break;
                    /* cm Kelvin */

case MILLI:     conv_bc(".001", res, 10, ib); break;
case MICRO:     conv_bc(".000001", res, 10, ib); break;
case NANO:      conv_bc(".000000001", res, 10, ib); break;
case PICO:      conv_bc(".000000000001", res, 10, ib); break;
case FEMTO:     conv_bc(".000000000000001", res, 10, ib); break;
case ATTO:      conv_bc(".000000000000000001", res, 10, ib); break;
case KILO:      conv_bc("1000", res, 10, ib); break;
case MEGA:      conv_bc("1000000", res, 10, ib); break;
case GIGA:      conv_bc("1000000000", res, 10, ib); break;
case TERA:      conv_bc("1000000000000", res, 10, ib); break;
case PETA:      conv_bc("1000000000000000", res, 10, ib); break;
case EXA:       conv_bc("1000000000000000000", res, 10, ib); break;

        case X_LOWER:
        case X_UPPER:
            sprintf(res, "%s", sixteen[Ibase]);
            break;

        case BACKSLASH:
            conv_bc(sr->cell, res, 1, ib);
            break;

        case NOTINLIST:    /* presumably a digit string */
            upcase(token);
            ret = token;
            break;

        default: /* token in list, but is not variable or constant */
            ret = Convbuf;   /* just to warn the caller */
            break;
    }
    TR_
    return(ret);
}

/* translate frombuf number string in frombase radix,
   to string in tobuf in tobase radix.

   If frombase and tobase are identical no conversion is done;
   buffer is simply copied.
   Otherwise, conv_pipe's ibase is set to the frombase radix,
   conv_pipe's obase is set to tobase, and the frombuf
   string is executed through conv_pipe.

   If frombase is 0, Lastob is taken as frombase.
   If frombase is -1, Ibase is taken as frombase.
   If frombase is 1, frombase is deduced from the first character
       of frombuf in stack string format.

   If tobuf is ZERO, result goes to Convbuf.  Else tobuf must
   be at least PIPEMAX long.
*/

conv_bc(frombuf, tobuf, frombase, tobase)
char *frombuf, *tobuf;
int frombase, tobase;
{
    int value, maxchars;
    int charcount = 0;
    register char *bptr, *toasc_p;
    static char *fid = "conv_bc";

    _TR
    bptr = frombuf;
    if (tobase == 0)
        tobase = Ibase;
    maxchars = strlen(frombuf);
    if (tobuf == ZERO)
        tobuf = Convbuf;

    switch (frombase) {
        case 1:
            charcount = 1;
            value = *bptr & 127; /* ascii value of passed radix label */
            for (toasc_p = Base_str + 16;; toasc_p--) {
                if (*toasc_p == value) {
                    frombase = toasc_p - Base_str;
                    break;
                }
            }
            while ((*++bptr & 127) == ' ') /* get to digit string */
                ++charcount;
            break;

        case -1:
            frombase = Ibase;
            break;

        case 0:
            frombase = Lastob;
            break;

        default:
            break;

    }

    if (frombase == tobase) {
        toasc_p = tobuf;
        while(charcount++ < maxchars)
            if ((*bptr & 127) != ' ')
                *toasc_p++ = *bptr++ & 127;
            else
                ++bptr;
        *toasc_p = '\0';
    }
    else {
        sprintf(Mop, "ibase=A;obase=%d;ibase=%d\n", tobase, frombase);
        toasc_p = &Mop[strlen(Mop)];
        while(charcount++ < maxchars)
            *toasc_p++ = *bptr++ & 127;
        *toasc_p++ = '\n';
        *toasc_p = '\0';
        if (write (B_write[1], Mop, strlen(Mop)) == -1)
            fatal("wait_conv_pipe write");
        wait_conv_pipe(tobuf);
    }
    TR_
}

