/* conv.c */
/**********************************************************************
*    File Name     : conv.c
*    Function      : user conversion routines of pac
*                  : Recursion is too big a task to fit the framework
*                  :  (i.e. defining 'to foo' as 'to {to foo}' brings
*                  :  up all sorts of control problems).  To simplify,
*                  :  only numerical expressions and binary operands
*                  :  are permitted, in a single statement (no ';').
*                  : 
*    Author        : Istvan Mohos, 1987
***********************************************************************/


#include "defs.h"
#define CONVMAP
#include "maps.h"
#undef CONVMAP

show_uconv()
{
    register ri;
    static char *fid = "show_uconv";

    _TR
    if (Convsel < CENTER)
        Topconv = 0;
    else if (Convsel >= Convcount - CENTER)
        Topconv = Convcount - (2 * CENTER);
    else
        Topconv = Convsel - CENTER + 1;

    for (ri = 0; ri < FITCONV; ri++) {
        mvaddstr(ri + TOP+1, CONVLEFT, Convlist[ri + Topconv][0]);
        addch(' ');
        mvaddstr(ri + TOP+1, KEYLEFT, Convlist[ri + Topconv][1]);
    }

    standout();
    for (ri = 0; ri < FITCONV; ri++)
        mvaddch(UTOP + ri, RBOUND, ' ');

    mvaddstr(TOP+1 + Convsel - Topconv, CONVLEFT, Convlist[Convsel][0]);
    standend();
    TR_
}

setup_uconv()
{
    register char *rc;
    register int ri;
    static char *fid = "setup_uconv";

    _TR
    Convhsiz = Convcount * (FROMTOSIZ + KEYSIZ);
    for (ri = 0; ri < Convcount; ri++)
        Convhsiz += strlen(Convlist[ri][2]) + 1; /* conv string + \n */
    if ((Convhom = calloc(Convhsiz, 1)) == ZERO)
        fatal("calloc error in setup_uconv");

    /* move static defs to dynamically alterable Convhom buffer */
    for (rc = Convhom, ri = 0; ri < Convcount; ri++) {
        strcpy(rc, Convlist[ri][0]);
        rc += FROMTOSIZ;
        strcpy(rc, Convlist[ri][1]);
        rc += KEYSIZ;
        strcpy(rc, Convlist[ri][2]);
        while (*rc++ != '\0');
    }
    realign_conv();
    TR_
}

conv_id(c_ptr)
char *c_ptr;
{
    int inlist_val, under;
    static char *fid = "conv_id";

    _TR
    if ((inlist_val = spacefill(c_ptr, 3)) != -1)
        inlist_val = keysearch(Tokbuf, Convcount, &under);
    TR_
    return(inlist_val);
}

keysearch (key, max, under)
register char *key;
int max, *under;
{
    register int guess, mid, lo = 0, hi;
    static char *fid = "keysearch";

    _TR
    hi = max - 1;
    while (lo <= hi) {
        mid = (lo + hi) >> 1;
        if ((guess = strcmp(key, Convlist[mid][1])) < 0)
            hi = mid - 1;
        else if (guess > 0)
            lo = mid + 1;
        else {
            TR_
            return(mid);
        }
    }
    *under = lo;
    TR_
    return (-1);
}

newconv()
{
    int c;
    int lbound;
    char calbuf[LINEMAX];
    int pyp, pxp;
    int ri;
    register int rj;
    register char *rc;
    static char *fid = "newconv";

    _TR
    CYX;
    rc = calbuf;
    for (ri = UTOP; ri <= UBOT; ri++)
        for (rj = ULEFT; rj <= URIGHT; rj++)
            *rc++ = stdscr->_y[ri][rj];

    mvaddstr(UTOP, ULEFT, Sp44);
    mvaddstr(UTOP + 1, ULEFT, Sp44);
    mvaddstr(UTOP + 2, ULEFT, Sp44);

    if (Convcount == 255) {
        mvaddstr(UTOP, ULEFT,
            "SELECT:   ...full...    Remove     Change  _");
        lbound = ULEFT + strlen(
            "SELECT:   ...full...    Remove     Change  ");

        while((c = ledit(ZERO,c_sel_map,UTOP,lbound,lbound,0,0,0)
            | 32) != 'r' && c != 'c');
    }
    else if (Convcount == 22) {
        mvaddstr(UTOP, ULEFT,
            "SELECT:     Install   ...low...    Change  _");
        lbound = ULEFT + strlen(
            "SELECT:     Install   ...low...    Change  ");

        while((c = ledit(ZERO,c_sel_map,UTOP,lbound,lbound,0,0,0)
            | 32) != 'i' && c != 'c');
    }
    else {
        mvaddstr(UTOP, ULEFT,
            "SELECT:     Install     Remove     Change  _");
        lbound = ULEFT + strlen(
            "SELECT:     Install     Remove     Change  ");

        while((c = ledit(ZERO,c_sel_map,UTOP,lbound,lbound,0,0,0)
            | 32) != 'i' && c != 'r' && c != 'c');
    }

    mvaddstr(UTOP, ULEFT, Sp44);
    mvaddstr(UTOP + 1, ULEFT, Sp44);
    mvaddstr(UTOP + 2, ULEFT, Sp44);

    switch(c) {
        case 'i':
            addnew(specify(pyp, pxp));
            break;

        case 'r':
            remove(celect());
            break;

        case 'c':
            remove(celect());
            addnew(specify(pyp, pxp));
            break;
    }

    rc = calbuf;
    for (ri = UTOP; ri <= UBOT; ri++)
        for (rj = ULEFT; rj <= URIGHT; rj++)
            mvaddch(ri, rj, *rc++);

    PYX;
    pfresh();
    TR_
}

celect()
{
    int lbound, rbound;
    char *c_key;
    int keylen, old_id, dummy;
    static char *fid = "celect";

    _TR
    clear_wline(UTOP, ULEFT, URIGHT, 0, 3);
    c_key = "   ";
    mvaddstr(UTOP, ULEFT,
        "ENTER OLD 'TO' SEARCH KEY:   [");
    lbound = ULEFT + strlen(
        "ENTER OLD 'TO' SEARCH KEY:   [");
    rbound = lbound + 2;
    mvaddstr(UTOP, rbound + 1, "]");

    old_id = -1;
    while (old_id == -1) {
        mvaddstr(UTOP, lbound, c_key);
    

        ledit(&K_buf[0], c_ed_map, UTOP, lbound, rbound, 0, 1, 1);
        /* stripping surrounding spaces */

        if(!*K_buf)
            continue;
        keylen = strlen(K_buf);
        if (keylen < 3)
            K_buf[2] = ' ';
        else if (*(K_buf+1) == ' ')
            *(K_buf+1) = '_'; /* turn embedded space into _ */
        if (keylen < 2)
            K_buf[1] = ' ';
        old_id = keysearch(K_buf, Convcount, &dummy);
    }
    TR_
    return(old_id);
}

specify(pyp, pxp)
int pyp, pxp;
{
    int lbound, rbound;
    char *c_label, *c_key;
    int neednewkey = 1, keylen, insert;
    static char *fid = "specify";

    _TR
    clear_wline(UTOP, ULEFT, URIGHT, 0, 3);
    while (neednewkey) {
        c_key = "   ";
        mvaddstr(UTOP + 1, ULEFT,
            "ENTER NEW 'TO' SEARCH KEY:   [");
        lbound = ULEFT + strlen(
            "ENTER NEW 'TO' SEARCH KEY:   [");
        mvaddstr(UTOP + 1, lbound, c_key);
        rbound = lbound + 2;
        mvaddstr(UTOP + 1, rbound + 1, "]");
    

        ledit(&K_buf[0], c_ed_map, UTOP+1, lbound, rbound, 0, 1, 1);
        /* stripping surrounding spaces */

        if (keylen = strlen(K_buf)) {
            if (keylen < 3)
                K_buf[2] = ' ';
            else if (*(K_buf+1) == ' ')
                *(K_buf+1) = '_'; /* turn emmbedded space into _ */
            if (keylen < 2)
                K_buf[1] = ' ';
        }
        else
            continue;
        if (keysearch(K_buf, Convcount, &insert) == -1)
            neednewkey = FALSE;
        /* if it did find it, the proposed new key is a duplicate,
           and is disallowed */
    }

    c_label = "             ";
    mvaddstr(UTOP + 2, ULEFT, "ENTER 'CONVERSIONS' LABEL:   [");
    lbound = ULEFT + strlen( "ENTER 'CONVERSIONS' LABEL:   [");
    mvaddstr(UTOP + 2, lbound, c_label);
    rbound = lbound + 12;
    mvaddstr(UTOP + 2, rbound + 1, "]");


    ledit(&L_buf[0], c_ed_map, UTOP+2, lbound, rbound, 0, 0, 1);

    mvaddstr(UTOP, ULEFT, Sp44);
    mvaddstr(UTOP + 1, ULEFT, Sp44);
    mvaddstr(UTOP + 2, ULEFT, Sp44);

    mvaddstr(UTOP, ULEFT,
        "COMPLETE THE EQUATION USING THE BACKSLASH \\");
    mvaddstr(UTOP + 1, ULEFT,
        "CHARACTER TO REPRESENT THE 'FROM' QUANTITY.");
    mvaddstr(UTOP + 2, ULEFT,
        "CONSTANTS ARE INTERPRETED IN DECIMAL RADIX.");

    Basq[EDITREQ] = Bb[EDITREQ];
    update();  /* this returns to the original coordinates,
                  but does'nt pfresh */

enter_conv:

    ledit(&Eq_buf[0], eq_ed_map, BOT, FBOUND, RBOUND, 1, 1, 1);

    if (verify_uconv())
        goto enter_conv;

    Basq[EDITREQ] = ZERO;
    PYX;
    update();
    pfresh();
    TR_
    return(insert);
}

realign_conv()
{
    register int ri;
    register char *rc;
    static char *fid = "realign_conv";

    _TR
    for (rc = Convhom, ri = 0; ri < Convcount; ri++) {
        Convlist[ri][0] = rc; /* ptr to first word of conversion */
        rc += FROMTOSIZ;         /* buffer pointer to second word */
        Convlist[ri][1] = rc; /* ptr to 2nd word of conversion */
        rc += KEYSIZ;            /* buffer pointer to conv string */
        Convlist[ri][2] = rc; /* ptr to conversion string */
        while (*rc++ != '\0');   /* find next conversion in buffer */
    }
    TR_
}

remove(old_id)
int old_id;
{
/*
   malloc Convhsiz size temp buffer;
   copy Convhom into temp until old_id conversion;
   skip (do not copy) old_id conversion;
   copy rest of Convhom into temp;
   free Convhom;
   assign Convhom pointer to temp;
   decrement Convcount;
   adjust Convhsiz;
   realign Convlist pointers along new buffer;
*/

    char *Tmp;
    register char *tp;
    unsigned rmsiz;
    register int ri;
    static char *fid = "remove";

    _TR
    if ((Tmp = malloc(Convhsiz)) == ZERO)
        fatal("malloc error in remove");
    tp = Tmp;

    for (ri = 0; ri < old_id; ri++) {
        strcpy(tp, Convlist[ri][0]);
        tp += FROMTOSIZ;
        strcpy(tp, Convlist[ri][1]);
        tp += KEYSIZ;
        strcpy(tp, Convlist[ri][2]);
        while (*tp++ != '\0');
    }
    rmsiz = FROMTOSIZ + KEYSIZ + strlen(Convlist[ri][2]) + 1; 
    for (ri = old_id + 1; ri < Convcount; ri++) {
        strcpy(tp, Convlist[ri][0]);
        tp += FROMTOSIZ;
        strcpy(tp, Convlist[ri][1]);
        tp += KEYSIZ;
        strcpy(tp, Convlist[ri][2]);
        while (*tp++ != '\0');
    }
    free(Convhom);
    Convhom = Tmp;
    --Convcount;
    Convhsiz -= rmsiz;
    realign_conv();
    if (Convsel > old_id)
        --Convsel;
    else if (Convsel == old_id)
        Convsel = CONVSEL;
    show_uconv();
    TR_
}

addnew(insert)
int insert;
{
/*
   Malloc new buffer, to hold Convhom + size of new conversion.
   Copy Convhom into new buffer, until the alphabetic ordering
       of KEYs reaches the new KEY.
   Insert new conversion in new buffer.
   Finish copying old conversions from Convhom to new buffer.
   Free Convhom.
   Assign Convhom (pointer) to new buffer.
   Increment Convcount.
   adjust Convhsiz;
   Realign Convlist pointers along new buffer.
*/

    char *Tmp;
    register char *tp;
    unsigned addsiz;
    register int ri;
    static char *fid = "addnew";

    _TR
    addsiz = FROMTOSIZ + KEYSIZ + strlen(Eq_buf) + 1; 
    if ((Tmp = malloc(Convhsiz + addsiz)) == ZERO)
        fatal("malloc error in addnew");
    tp = Tmp;

    for (ri = 0; ri < insert; ri++) {
        strcpy(tp, Convlist[ri][0]);
        tp += FROMTOSIZ;
        strcpy(tp, Convlist[ri][1]);
        tp += KEYSIZ;
        strcpy(tp, Convlist[ri][2]);
        while (*tp++ != '\0');
    }
    strcpy(tp, L_buf);
    tp += FROMTOSIZ;
    strcpy(tp, K_buf);
    tp += KEYSIZ;
    strcpy(tp, Eq_buf);
    while (*tp++ != '\0');
    for (ri = insert; ri < Convcount; ri++) {
        strcpy(tp, Convlist[ri][0]);
        tp += FROMTOSIZ;
        strcpy(tp, Convlist[ri][1]);
        tp += KEYSIZ;
        strcpy(tp, Convlist[ri][2]);
        while (*tp++ != '\0');
    }
    free(Convhom);
    Convhom = Tmp;
    ++Convcount;
    Convhsiz += addsiz;
    realign_conv();
    Convsel = insert;
    show_uconv();
    TR_
}

verify_uconv()
{
    static char *fid = "verify_uconv";

    _TR
    if (strlen(Eq_buf) == 0) {
        strcpy(Eq_buf, "\\");
        TR_
        return(0);
    }

    TR_
    return(0);
}

/* the routine that interprets the user keyword TO */
conv_usr()
{
    char *ctab, *cb, cbuf[LINEMAX];
    char hardbuf[LINEMAX];
    int ri;
    int sav_ibase;
    static char *fid = "conv_usr";

    _TR
    e_syntax();
    e_divby0();
    e_exponent();
    e_bcexec();

    if (!Bc_error) {
        sav_ibase = Ibase;
        Ibase = 10;
        conv_bc(Mainbuf, ZERO, 0, 0);
        *(Convbuf + DIGMAX + 2) = '\0';
        ri = strlen(Convbuf);
        Ibase = sav_ibase;
    
        cb = cbuf;
        strcpy(cb, "ibase=A;");
        cb += strlen(cb);
    
        ctab = Convlist[Convsel][2];
        sprintf(Bb[CONVREQ] + BUFSTOP, ctab);
        rev_clear(Bb[CONVREQ] + TITSIZ);
        Basq[CONVREQ] = Bb[CONVREQ];
        update();
    
        if ( Hc != -1 && Hf != FXTER) {
            if (Hf == FVER)
                sprintf(hardbuf, "TO %s: %s\n", Convlist[Convsel][1], ctab);
            else
                sprintf(hardbuf, "TO %s\n", Convlist[Convsel][1]);
            if ((write(Hc, hardbuf, strlen(hardbuf))) !=
                strlen(hardbuf))
                fatal("hardcopy write");
        }
    
        while (*ctab != '\0') {
            if (*ctab == '\\') {
                strcpy(cb, Convbuf);
                cb += ri;
                ctab++;
            }
            else
                *cb++ = *ctab++;
        }
        sprintf(cb, ";ibase=%d\n", Ibase);
        if (write(A_write[1], cbuf, strlen(cbuf)) == -1)
            fatal("main pipe write");
        clear_accwin();
        wait_main_pipe();
    }
    if (Autoconv == DISA)
        Do_conv = FALSE;
    TR_
}

