/* amort.c */
/**********************************************************************
*    File Name     : amort.c
*    Function      : amortization (loan) routines of pac
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"
#define AMORTMAP
#include "maps.h"
#undef AMORTMAP

show_loan(play)
int play;
{
    int thisline = AMTY;
    int ck, did_input, Too_big;
    char floatbuf[LOANSIZ + 1];
    int pyp, pxp, ryr, rxr;
    static char *fid = "show_loan";

    _TR
    CYX;
    show_float(Amt, AMTY, 2);
    show_float(Rate, PRCY, 3);
    show_float(Years, YRY, 2);
    mvaddstr(DATY, LOANX, "begin mo/year");
    Too_big = show_pymt();

    if (!play)
        year();
    else {
        while(TRUE) {

            switch(thisline) {
            case AMTY:
                if (Amt == 0.)
                    clear_wline(thisline, LOANX, LOANR, 0, 1);
                break;
            case PRCY:
                if (Rate == 0.)
                    clear_wline(thisline, LOANX, LOANR, 0, 1);
                break;
            case YRY:
                if (Years == 0.)
                    clear_wline(thisline, LOANX, LOANR, 0, 1);
                break;
            }

            if ((ck = ledit(floatbuf, loan_map, thisline, LOANX,
                LOANR, 0, 1, 1)) == 1)
                break;
            did_input = strlen(floatbuf);

            if (ck == 2 && Pymt > 0. && !Too_big) {
                ryr=CY, rxr=CX;
                ck = printamort();
                move(CY=ryr, CX=rxr);
                pfresh();
                if (ck == 2)
                    break;
                continue;
            }

            if (did_input) {
                switch(thisline) {
                    case AMTY:
                        Amt = atof(floatbuf);
                        break;
                    case PRCY:
                        Rate = atof(floatbuf);
                        break;
                    case YRY:
                        Years = atof(floatbuf);
                        break;
                }
                Too_big = show_pymt();
            }

            if (++thisline > YRY)
                thisline = AMTY;
        }
        PYX;
        pfresh();
    }
    TR_
}

show_pymt()
{
    double nonzero;
    char reformat[32];
    static char *fid = "show_pymt";

    _TR
    Months = Years * 12.;
    I_mo = (Rate / 100.) / 12.;
    nonzero = 1. - pow(1. + I_mo, - Months);
    if (nonzero == 0. || I_mo == 0.)
        Pymt = Showpymt = 0.;
    else {
        Pymt = Amt * (I_mo / nonzero);
        Showpymt = Pymt + .00999999;
    }

    sprintf(reformat, "%.2f", Showpymt);
    Showpymt = atof(reformat);
    if (show_float(Showpymt, PAYY, 2)) {
        TR_
        return(-1);
    }
    TR_
    return(0);
}

show_float(value, where, decimals)
double value;
int where, decimals;
{
    char loanbuf[32];
    char *lp = loanbuf;
    register char *cp;
    static char *fid = "show_float";

    _TR
    strcpy (lp, Sp13);
    sprintf(lp,  "%.*f",decimals , value);
    (strlen(lp) < 13) ? (*(lp + strlen(lp)) = ' ') : (*(lp + 13) = 0);

    cp = lp + 13;
    if (where > YRY)
        for (; --cp >= lp;)
            if (*cp == '.')
                break;

    if (cp >= lp) {
        mvaddstr(where, LOANX, lp);
        TR_
        return(0);
    }

    mvaddstr(where, LOANX, "overflow     ");
    TR_
    return(-1);
}

printamort()
{
    double a_amt, ppay, ipay, yppay, yipay;
    FILE *fp;
    char *token, *np;
    int ck, startmonth, startyear, yr;
    int pyp, pxp;
    register int ri;
    int lastmonth;
    char round[32];
    char datebuf[LOANSIZ + 1];
    static char savedate[LOANSIZ + 1];
    char namebuf[TITSIZ + 1];
    char spaceless[TITSIZ + 1];
    int did_input;
    static char *fid = "printamort";

    _TR
    if (strlen(savedate))
        mvaddstr(DATY, LOANX, savedate);

    if ((ck = ledit(&datebuf[0], date_map, DATY,
        LOANX, LOANR, 0, 1, 0)) == 1) {
        TR_
        return(1);
    }
    if (ck == 2) {  /* types ^B, I have no idea what this does */
        TR_
        return(2);
    }
    did_input = datebuf[0];

    if ((token = pactok(&datebuf[0], " .,/:")) == ZERO)
        startmonth = 1, startyear = atoi(Thisyear);
    if ((startmonth = whichmonth(token)) == 0)
        startmonth = 1;
    if ((token = pactok(ZERO, " .,/:")) == ZERO)
        startyear = atoi(Thisyear);
    else if ((startyear = atoi(token)) < 1)
        startyear = atoi(Thisyear);
    else if (startyear < 1900)
        startyear += 1900;

    move(DATY, LOANX);
    printw("%.2d/%.4d      ", startmonth, startyear);
    if (did_input)
        sprintf(savedate, "%.2d/%.4d      ", startmonth, startyear);
    pfresh();

    Basq[EDITREQ] = Bb[LOANREQ];
    CYX;  /* to save the caller'r coordinates */
    update();  /* this returns to the original coordinates,
                  but does'nt pfresh */
retry:

    ledit(namebuf, amort_map, BOT, FBOUND, RBOUND, 1, 1, 0);

    if (strlen(namebuf) == 0) {
        strcpy(spaceless, Amortname);
        for (np = spaceless; *np > 32; np++);
        *np = '\0';
        standout();
        mvaddstr(BOT, FBOUND, Amortname);
        standend();
        pfresh();
    }
    else {
        strcpy(Amortname, namebuf);
        strcpy(spaceless, namebuf);
    }

    if ((fp = fopen(spaceless, "w")) == NULL) {
        standout();
        mvaddstr(BOT, ULEFT, "can't access:");
        pfresh();
        goto retry;
    }
    
    fprintf(fp, "\
AMORTIZATION SCHEDULE\n\n");
    fprintf(fp, "\
        PREPARED FOR    %s\n", Amortname);
    fprintf(fp, "\
        LOAN AMOUNT     %.2f\n", Amt);
    fprintf(fp, "\
        MONTHLY PAYMENT %.2f\n", Showpymt);
    fprintf(fp, "\
        LENDING RATE    %.3f%c\n", Rate, '\045');
    fprintf(fp, "\
        TERM YEARS      %.2f\n\n", Years);

/* format field widths
12345678901 1234567890123 12345678901234567890 12345678901234567890 XX
*/
    fprintf(fp, "\
PAYMENT         DUE               PRINCIPAL          INTEREST           NEW\n");
    fprintf(fp, "\
NUMBER          DATE              PAYMENT            PAYMENT            BALANCE\n\n");

    a_amt = Amt;
    ck = startmonth;
    Intrst = yppay = yipay = 0.;
    yr = 1;
    for (ri = 1, lastmonth = (int)Months; ri < lastmonth; ri++) {
        ipay = I_mo * a_amt;
        sprintf(round, "%.2f", ipay);
        ipay = atof(round);
        yipay += ipay;
        ppay = Pymt - ipay + .009999999;
        sprintf(round, "%.2f", ppay);
        ppay = atof(round);
        yppay += ppay;
        a_amt -= ppay;
        fprintf(fp, "\
  %4d      %.2d/01/%.4d    %17.2f %17.2f %17.2f\n",
            ri, ck, startyear, ppay, ipay, a_amt);
        if (++ck > 12)
            ck = 1;
        if (((ri - 1) % 12) == (12 - startmonth)) {
            fprintf(fp, "\
YEAR %.2d TOTAL:            %17.2f %17.2f\n\n", yr++, yppay, yipay);
            Intrst += yipay;
            ++startyear;
            yppay = yipay = 0.;
        }
    }
    ipay = I_mo * a_amt;
    sprintf(round, "%.2f", ipay);
    ipay = atof(round);
    yipay += ipay;
    ppay = Pymt - ipay + .009999999;
    sprintf(round, "%.2f", ppay);
    ppay = atof(round);
    a_amt -= ppay;
    ppay += a_amt;
    yppay += ppay;
    a_amt = 0.;
    Intrst += yipay;
    fprintf(fp, "\
  %4d      %.2d/01/%.4d    %17.2f %17.2f %17.2f\n",
        ri, ck, startyear, ppay, ipay, a_amt);
    fprintf(fp, "\
YEAR %.2d TOTAL:            %17.2f %17.2f\n\n", yr, yppay, yipay);
    fprintf(fp, "\
GRAND TOTAL:              %17.2f %17.2f\n", Amt, Intrst);
    fclose(fp);

    strcpy(Bb[LOANREQ] + BUFSTOP, Amortname);
    rev_clear(Bb[LOANREQ] + TITSIZ);
    Basq[EDITREQ] = ZERO;

    PYX;
    update();
    TR_
    return(0);
}

