/* toktab.h */
/**********************************************************************
*    File Name     : toktab.h
*    Function      : token definitions, token table
*    Author        : Istvan Mohos, 1987
***********************************************************************/

/* to add token:
   insert in toklist, spacefilled to WORDSIZE, in ascii alpha sequence;
   increment LISTSIZE;
   add token #define, in the SAME ORDER as in toklist;
   renumber defines (0  to  LISTSIZE - 1);
   if token contains weird char, adjust map in pac.c to allow it;
   describe action in interpret.c;
*/

#define WORDSIZE  9        /* maximum token size, not including \0 */
#define LISTSIZE  158      /* number of pac tokens */

#ifdef PACTOK
static char *toklist[] = {
"!        ",
"#        ",
"\'        ",
";        ",
"?        ",
"X        ",
"\\        ",
"amass    ",
"and      ",
"arct     ",
"astro    ",
"at       ",
"atto     ",
"au       ",
"auto     ",
"autoconv ",
"autotime ",
"avogadro ",
"boltzmann",
"break    ",
"bye      ",
"chroma   ",
"clr      ",
"cm       ",
"comma    ",
"cos      ",
"define   ",
"dontsave ",
"dp       ",
"ds       ",
"dup      ",
"earthmass",
"earthrad ",
"echarge  ",
"emass    ",
"euler    ",
"exa      ",
"exit     ",
"exp      ",
"faraday  ",
"femto    ",
"fix      ",
"fo       ",
"for      ",
"format   ",
"g        ",
"gas      ",
"giga     ",
"gravity  ",
"h        ",
"hardform ",
"heat     ",
"help     ",
"hf       ",
"i        ",
"ib       ",
"ibase    ",
"if       ",
"init     ",
"j        ",
"ju       ",
"justify  ",
"k        ",
"kilo     ",
"l        ",
"le       ",
"left     ",
"length   ",
"light    ",
"lightyear",
"log      ",
"m        ",
"mega     ",
"micro    ",
"milli    ",
"mod      ",
"mohos    ",
"moonmass ",
"moonrad  ",
"n        ",
"nano     ",
"natural  ",
"nmass    ",
"not      ",
"o        ",
"ob       ",
"obase    ",
"off      ",
"on       ",
"or       ",
"p        ",
"parallax ",
"parsec   ",
"pd       ",
"pdelta   ",
"pdiff    ",
"pe       ",
"pequal   ",
"peta     ",
"pi       ",
"pico     ",
"planck   ",
"pll      ",
"pm       ",
"pmass    ",
"pminus   ",
"po       ",
"pof      ",
"pop      ",
"pp       ",
"pplus    ",
"pr       ",
"precision",
"psh      ",
"pv       ",
"pversus  ",
"q        ",
"quit     ",
"r        ",
"ri       ",
"right    ",
"rydberg  ",
"s        ",
"sb       ",
"scale    ",
"sin      ",
"sound    ",
"sp       ",
"space    ",
"sqrt     ",
"st       ",
"stack    ",
"staybase ",
"stefan   ",
"sto      ",
"sunmass  ",
"sunrad   ",
"swp      ",
"t        ",
"te       ",
"tera     ",
"terse    ",
"to       ",
"tomoon   ",
"tosun    ",
"tw       ",
"twoscomp ",
"u        ",
"v        ",
"ver      ",
"verbose  ",
"w        ",
"while    ",
"wien     ",
"x        ",
"xor      ",
"xt       ",
"xterse   "
};
#endif

/* pac token table definitions, ordered EXACTLY as toklist,
   numbered sequentially from 0.  When adding or removing tokens, this
   list gets renumbered. */

#define BANG             0
#define SHARP            1
#define TICK             2
#define SEMI             3
#define QUESTION         4
#define X_UPPER          5
#define BACKSLASH        6
#define AMASS            7
#define AND              8
#define ARCT             9
#define ASTRO           10
#define AT              11
#define ATTO            12
#define AU              13
#define AUTO            14
#define AUTOCONV        15
#define AUTOTIME        16
#define AVOGADRO        17
#define BOLTZMANN       18
#define BREAK           19
#define BYE             20
#define CHROMA          21
#define CLR             22
#define CM              23
#define COMMA           24
#define COS             25
#define DEFINE          26
#define DONTSAVE        27
#define DP              28
#define DS              29
#define DUP             30
#define EARTHMASS       31
#define EARTHRAD        32
#define ECHARGE         33
#define EMASS           34
#define EULER           35
#define EXA             36
#define EXIT            37
#define EXP             38
#define FARADAY         39
#define FEMTO           40
#define FIX             41
#define FO              42
#define FOR             43
#define FORMAT          44
#define G_              45
#define GAS             46
#define GIGA            47
#define GRAVITY         48
#define H_              49
#define HARDFORM        50
#define HEAT            51
#define HELP            52
#define HF              53
#define I_              54
#define IB              55
#define IBASE           56
#define IF              57
#define INIT_           58
#define J_              59
#define JU              60
#define JUSTIFY         61
#define K_              62
#define KILO            63
#define L_              64
#define LE              65
#define LEFT            66
#define LENGTH          67
#define LIGHT           68
#define LIGHTYEAR       69
#define LOG             70
#define M_              71
#define MEGA            72
#define MICRO           73
#define MILLI           74
#define MOD             75
#define MOHOS           76
#define MOONMASS        77
#define MOONRAD         78
#define N_              79
#define NANO            80
#define NATURAL         81
#define NMASS           82
#define NOT             83
#define O_              84
#define OB              85
#define OBASE           86
#define OFF             87
#define ON              88
#define OR              89
#define P_              90
#define PARALLAX        91
#define PARSEC          92
#define PD              93
#define PDELTA          94
#define PDIFF           95
#define PE              96
#define PEQUAL          97
#define PETA            98
#define PI              99
#define PICO           100
#define PLANCK         101
#define PLL            102
#define PM             103
#define PMASS          104
#define PMINUS         105
#define PO             106
#define POF            107
#define POP            108
#define PP             109
#define PPLUS          110
#define PR             111
#define PRECISION      112
#define PSH            113
#define PV             114
#define PVERSUS        115
#define Q_             116
#define QUIT           117
#define R_             118
#define RI             119
#define RIGHT          120
#define RYDBERG        121
#define S_             122
#define SB             123
#define SCALE          124
#define SIN            125
#define SOUND          126
#define SP             127
#define SPACE          128
#define SQRT           129
#define ST             130
#define STACK          131
#define STAYBASE       132
#define STEFAN         133
#define STO            134
#define SUNMASS        135
#define SUNRAD         136
#define SWP            137
#define T_             138
#define TE             139
#define TERA           140
#define TERSE          141
#define TO             142
#define TOMOON         143
#define TOSUN          144
#define TW             145
#define TWOSCOMP       146
#define U_             147
#define V_             148
#define VER            149
#define VERBOSE        150
#define W_             151
#define WHILE          152
#define WIEN           153
#define X_LOWER        154
#define XOR            155
#define XT             156
#define XTERSE         157
