/* stack.c */
/**********************************************************************
*    File Name     : stack.c
*    Function      : user stack
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"

linkup()
{
    register struct stk_cell *sr;
    register int ri;
    static char *fid = "linkup";

    _TR
    sr = &Stk[0];
    for(ri = STACKDEEP+1; --ri; sr++)  /* leave last one dangling */
        sr->link = sr+1;
    TR_
}

fill_stack(from)
char *from;
{
    register struct stk_cell *sr;
    register char *rc = from;
    register int ri;
    static char *fid = "fill_stack";

    _TR
    linkup();

    sr = &Stk[0];                /* accumulator */
    if (from == ZERO) {
        strcpy(sr->cell, Emptycell+2); /* no base char */
        ++sr;
        for (ri = STACKDEEP; --ri >= 0; sr++)
            strcpy(sr->cell, Emptycell);
    }
    else {
        *(rc + STACKMAX) = 0;
        strcpy(sr->cell, Emptycell+2);  /* no base char in accum */
        ++sr;
        for (ri = STACKDEEP; --ri >= 0; sr++) {
            *(rc + STACKMAX) = 0;
            strcpy(sr->cell, rc);
            rc += STACKMAX + 1;
        }
    }
    TR_
}

show_stack()
{
    register struct stk_cell *sr;
    register int ri;
    static char *fid = "show_stack";

    _TR
    sr = Stk[0].link;                /* skip accumulator */
    for (ri = STACKTOP; ri <= STACKBOT; ri++) {
        move(ri, STACKLEFT);
        printw("%s", sr->cell);
        sr = sr->link;
    }
    standout();
    for (ri = STACKTOP; ri <= STACKBOT; ri++) {
        mvaddch(ri, LBOUND, 'h' + ri - STACKTOP);
    }
    standend();
    TR_
}

struct stk_cell *
find(stkpos)
int stkpos;    /* accumulator = 0, h = 1 */
{
    register struct stk_cell *sr;
    register int ri;
    static char *fid = "find";

    _TR
    sr = &Stk[0];
    for (ri = stkpos; --ri >= 0; sr = sr->link);
    TR_
    return(sr);
}

save_stack(to, revstrip)
char *to;
int revstrip;
{
    register struct stk_cell *sr;
    register char *rc = to;
    register int ri;
    static char *fid = "save_stack";

    _TR
    sr = Stk[0].link;                /* skip accumulator */
    for (ri = STACKDEEP; --ri >= 0; sr = sr->link) {
        strcpy(rc, sr->cell);
        rc += STACKMAX;
        if (revstrip) {
            while(*--rc == ' ');
            ++rc;
        }
        *rc++ = '\n';
    }
    *rc = '\0';
    TR_
}

popstack(stkpos)
int stkpos;    /* h = 1 */
{
    register struct stk_cell *sr, *br;
    static char *fid = "popstack";

    _TR
    sr = find(stkpos - 1);
    br = sr->link;
    sr->link = br->link;
    sr = find(STACKDEEP - 1);  /* one is already unlinked */
    sr->link = br;
    strcpy(br->cell, Emptycell);
    show_stack();
    TR_
}

clearstack(stkpos)
int stkpos;
{
    register struct stk_cell *sr;
    static char *fid = "clearstack";

    _TR
    if (stkpos == 0) {
        linkup();
        fill_stack(ZERO);
    }
    else {
        sr = find(stkpos);
        strcpy(sr->cell, Emptycell);
    }
    show_stack();
    TR_
}

pushstack(stkpos)
int stkpos;
{
    register struct stk_cell *sr, *br, *tr;
    static char *fid = "pushstack";

    _TR
    sr = find(stkpos - 1);
    tr = find(STACKDEEP);
    br = sr->link;
    sr->link = tr;
    tr->link = br;
    show_stack();
    TR_
}

onereg(stkpos)
int stkpos;
{
    register struct stk_cell *sr;
    static char *fid = "onereg";

    _TR
    sr = find(stkpos);
    strcpy(Onebuf, sr->cell);
    TR_
}

stack_reg(stkpos, source)
int stkpos, source;
{
    register struct stk_cell *sr, *br;
    static char *fid = "stack_reg";

    _TR
    sr = find(stkpos);
    br = find(source);
    strcpy(sr->cell, br->cell);
    show_stack();
    TR_
}

