/* pipes.c */
/**********************************************************************
*    File Name     : pipes.c
*    Function      : make A and B pipes to bc
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"

pipes()
{
    char tmp[LINEMAX]; /* PLUS6300 needs this --- beats me why */
    /* setup main bc function */
    if (pipe(A_write) == -1 || pipe(A_read) == -1)
        fatal("main pipe setup");
    switch (A_ret = fork()) {
    case -1:
        fatal("main fork");
    case  0:
        if (close(0) == -1 || close(1) == -1)
            fatal("main close1");
        if (dup(A_write[0]) != 0)
            fatal("main dup0");
        if (dup(A_read[1]) != 1)
            fatal("main dup1");
        if (close(A_write[0]) == -1 || close(A_read[0]) == -1 ||
            close(A_write[1]) == -1 || close(A_read[1]) == -1)
            fatal("main close2");
        execlp("/usr/bin/bc", "bc", "-l", 0);
    }
    if (close(A_write[0]) == -1 || close(A_read[1]) == -1)
        fatal("main close3");

    /* setup converter bc function */
    if (pipe(B_write) == -1 || pipe(B_read) == -1)
        fatal("conv pipe setup");
    switch (A_ret = fork()) {
    case -1:
        fatal("conv fork");
    case  0:
        if (close(0) == -1 || close(1) == -1)
            fatal("conv close1");
        if (dup(B_write[0]) != 0)
            fatal("conv dup0");
        if (dup(B_read[1]) != 1)
            fatal("conv dup1");
        if (close(B_write[0]) == -1 || close(B_read[0]) == -1 ||
            close(B_write[1]) == -1 || close(B_read[1]) == -1)
            fatal("conv close2");
        execlp("/usr/bin/bc", "bc", 0);
    }
    if (close(B_write[0]) == -1 || close(B_read[1]) == -1)
        fatal("conv close3");
}

