/* ledit.c */
/**********************************************************************
*    File Name     : ledit.c
*    Function      : line (window) editor of pac
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"

ledit(retbuf,Map,line_y,lbound,rbound,video,stripspace,intact)
char *retbuf, *Map;
int line_y, lbound, rbound, video, stripspace, intact;
{
    char c;
    register int ri;
    int rj;
    int lchar, rchar;
    int tbound, bbound;
    int control = 1, retval = 0, first = 1;
    int insert = 0;
    char *rp;
    static char *fid = "ledit";

    _TR

    if (line_y) {
        CY = tbound = bbound = line_y;
        CX = lbound;
    }
    else {
        /* calculator window */
        CY = tbound = UTOP;
        bbound = UBOT;
        CX = ULEFT;
    }
        
    move(CY, CX);
    pfresh();

    while(control) {
        c = fgetc(stdin) & 127;
        if (c == 10 || c == 13)
            break;
        if (c == 17 || c == 19)
            continue;
        if (!intact && first && c > 31) {
            standout();
            mvaddstr(MSG, MSGLEFT, Sp34); /* clear any error messages */
            standend();
            first = 0;
            if (line_y)
                clear_wline(tbound, lbound, rbound, video, 1);
            else
                clear_wline(UTOP, lbound, rbound, video, 3);
        }

        if (video)
            standout();
        switch(*(Map+c)) {

            default:                /* do nothing */
            case 0:
                break;

            case 1:                 /* exit */
                go_away(ZERO, 0);

            case 2:                 /* addch */
                if (insert) {
                    for (rj = bbound; rj >= CY + 1; rj--) {
                        for (ri = rbound; ri >= lbound + 1; ri--)
                            mvaddch(rj, ri, stdscr->_y[rj][ri - 1]);
                        mvaddch(rj, ri, stdscr->_y[rj - 1][rbound]);
                    }
                    for (ri = rbound; ri >= CX + 1; ri--)
                        mvaddch(CY, ri, stdscr->_y[CY][ri - 1]);
                }
                mvaddch(CY,CX,c);
                if(++CX > rbound)
                    if (++CY <= bbound)
                        CX = lbound;
                    else {
                        --CY;
                        --CX;
                    }
                move(CY,CX);
                break;

            case 21:                /* ignore to EOL */
                while((c = fgetc(stdin) & 127) != 10 && c != 13);
                ungetc(c, stdin);
                break;

            case 3:                 /* move left */
                if (--CX < lbound)
                    ++CX;
                move(CY, CX);
                break;

            case 4:                 /* move right */
                if (++CX > rbound)
                    --CX;
                move(CY, CX);
                break;

            case 13:                /* move up */
                if (--CY < tbound)
                    ++CY;
                move(CY, CX);
                break;

            case 14:                /* move down */
                if (++CY > bbound)
                    --CY;
                move(CY, CX);
                break;

            case 15:                /* move down and left */
                if (++CY <= bbound)
                    CX = lbound;
                else
                    --CY;
                move(CY, CX);
                break;

            case 7:                 /* clear; exit */
                clearstack(0);
                Amt = Rate = Years = 0.;
                go_away("I", 0);

            case 8:                 /* wants parent to pop */
                retval = 1;
                control = 0;
                break;

            case 9:                 /* wants parent to push */
                retval = 2;
                control = 0;
                break;

            /* give back last c, read buffer */
            case 12:
                retval = c;
                control = 0;
                break;

            /* give back last c, skip buffer */
            case 17:
                pfresh();
                TR_
                return(c);

            case 10:                /* fill to eol with spaces */
                for (ri = CX; ri <= rbound; ri++)
                    addch(' ');
                for (rj = tbound + 1; rj <= bbound; rj++) {
                    move(rj, lbound);
                    for (ri = CX; ri <= rbound; ri++)
                        addch(' ');
                }
                move(CY,CX);
                break;

            /* curr line: delete char and move 1 pos to left */
            case 11:
                for (ri = CX + 1; ri <= rbound; ri++)
                    addch(stdscr->_y[CY][ri]);
                addch(' ');
                if (--CX < lbound)
                     ++CX;
                move(CY,CX);
                break;

            /* across lines: delete char and move 1 pos to left */
            case 16:
                for (ri = CX + 1; ri <= rbound; ri++)
                    addch(stdscr->_y[CY][ri]);
                for (rj = CY + 1; rj <= bbound; rj++) {
                    addch(stdscr->_y[rj][lbound]);
                    move(rj, lbound);
                    for (ri = lbound + 1; ri <= rbound; ri++)
                        addch(stdscr->_y[rj][ri]);
                }
                addch(' ');
                if (--CX < lbound)
                     ++CX;
                move(CY,CX);
                break;

            case 18 :
                clearok(curscr, TRUE);
                break;                /* ^R redraw */

            case 19 :
                insert = 1;
                break;

            case 20 :
                insert = 0;
                break;
        }
        standend();
        pfresh();
    }

    rp = retbuf; 
    if (stripspace) { /* single line implementation only */
        /* find first non-space from the left */
        for (ri = lbound; ri <= rbound; ri++)
            if ((stdscr->_y[CY][ri] & 127) > 32)
                break;
        if ((lchar = ri) > rbound) {
            *rp = '\0';
            pfresh();
            TR_
            return(retval);
        }
    
        /* find first non-space from the right */
        for (ri = rbound; ri >= lbound; ri--)
            if ((stdscr->_y[CY][ri] & 127) > 32)
                break;
        rchar = ri;
    
        /* give back everything in between */
        for (ri = lchar; ri <= rchar; ri++)
                *rp++ = stdscr->_y[CY][ri] & 127;
    }
    else
        for (rj = tbound; rj <= bbound; rj++)
            for (ri = lbound; ri <= rbound; ri++)
                *rp++ = stdscr->_y[rj][ri] & 127;
    *rp = '\0';
    pfresh();

    if (Trace && Tf != NULL)
        fprintf(Tf, "[%s]\n", retbuf);
    TR_
    return(retval);
}

