/* ierror.c */
/**********************************************************************
*    Function      : perror, writes into global string buffer "ierbuf"
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include <stdio.h>
extern int errno, sys_nerr;
extern char *sys_errlist[];
extern char ierbuf[];

ierror(ustr, badnum)
char *ustr;
int badnum;
{
    register char *cp = NULL;

    if (errno > 0 && errno < sys_nerr) {
        badnum = errno;
        cp = sys_errlist[errno];
    }

    if (ustr != (char *)NULL)
        if (cp != (char *)NULL)
            sprintf(ierbuf, "%s: %s", cp, ustr);
        else
            strcpy(ierbuf, ustr);
    else
        if (cp != (char *)NULL)
            sprintf(ierbuf, "%s:", cp);
        else
            *ierbuf = '\0';

    errno = 0;
    return(badnum);
}
