/* display.c */
/**********************************************************************
*    File Name     : display.c
*    Function      : calculator, stack, status window displays of pac
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include "defs.h"

/* display Mainbuf after wait_main_pipe:
   trim Mainbuf; reformat Mainbuf data in Rebuf, Tmpbuf */
display_accum(showflag)
int showflag;
{
    int zerofill;
    int dp_at = -1;
    register int ri;
    register char *dpptr;
    char *tpt;
    int tmpsiz, readsiz;
    int noint = 0;
    struct stk_cell *sr = &Stk[0];
    static char *fid = "display_accum";

    _TR
    Bc_error = 0;
    Negative = Too_big = Has_dp = FALSE;
    e_syntax();
    e_divby0();
    e_exponent();
    e_bcexec();

    if (*Mainbuf == '-')
        Negative = TRUE;

    dpptr = Mainbuf;
    if (*dpptr == '.') 
        noint = 1;
    ri = 0;
    while (*dpptr != '\0') { /* wait_pipe changed last newline to \0 */
        ++ri;
        if (*dpptr++ == '.') {
            tpt = dpptr + Precision +1;
            *tpt = '\0';  /* cut overenthusiastic bc digits */
            if (tpt == dpptr + strlen(dpptr)) {
                if (round(Mainbuf, Mainbuf+strlen(Mainbuf))) {
                    ++dpptr; /* decimal point shifted 1 byte to right */
                    ++ri;
                }
            }
            Has_dp = TRUE;
            dp_at = ri;
        }
    }
    if (Has_dp) {               /* trailing zero suppression */
        while (*--dpptr == '0') {
            *dpptr = '\0';
            --ri;
        }
        if (*dpptr == '.') {
            if (noint) {
                *dpptr = '0';
                pac_err("underflow");
            }
            else {
                *dpptr = '\0';
                --ri;
            }
            Has_dp = FALSE;
        }
    }
    readsiz = ri;

    if ((strlen(Mainbuf) - Negative - Has_dp) > DIGMAX) {
        Too_big = TRUE;
        if (dp_at >= ACCUMAX)
            Has_dp = FALSE;
        e_overflow();  /* this error leaves oversize number in buffer */
        readsiz = DIGMAX + Negative + Has_dp;
        Mainbuf[readsiz] = '\0';
    }

    sprintf(sr->cell, "%c %-*.*s", *(Base_str + Obase),
        STACKMAX-2, STACKMAX-2, Mainbuf);

    if(Justify == JL) {
        strcpy(Rebuf, Mainbuf);
        strcat(Rebuf, Sp44);
        Rebuf[ACCUMAX] = '\0';
        display(Rebuf);
    }
    else if (Justify == JR) {
        strcpy(Rebuf, Sp44);
        strcpy(&Rebuf[ACCUMAX - readsiz], Mainbuf);
        Rebuf[ACCUMAX] = '\0';
        display(Rebuf);
    }
    else {   /* JF */
        strcpy(Tmpbuf, Mainbuf);
        if (!Too_big) {
            if (Has_dp) {
                strcat(Tmpbuf, Fix32);
                zerofill = Precision - (readsiz - dp_at);
                Tmpbuf[readsiz + zerofill] = '\0';
            }
            else
                sprintf(&Tmpbuf[readsiz], ".%.*s", Precision, Fix32);
        }
        Tmpbuf[DIGMAX + Negative + Has_dp] = '\0';
        tmpsiz = strlen(Tmpbuf);
        strcpy(Rebuf, Sp44);
        strcpy(&Rebuf[ACCUMAX - tmpsiz], Tmpbuf);
        display(Rebuf);
    }

    if ((Stack == ENA) && Painted) {
        pushstack(1);
        stack_reg(1, 0);
    }
    move(CY=UTOP, CX=ULEFT);
    if (showflag)
        pfresh();
    TR_
}

/* break up long digit string with spaces, for formatted display */
display(source)
char *source;
{
    char backward[MYBUF];
    register ri;
    register char *from, *to;
    char *numstart, *frommark, *tomark;
    int inlen, tail, group, int_digs;
    static char *fid = "display";
    
    _TR
    if (Format == DISA) {
        mvaddstr(ACCUM,ULEFT,source);
        if (Hc != -1 && !Hide) {
            if ((write(Hc, source, strlen(source))) !=
                strlen(source))
                fatal("hardcopy accumulator write");
            if ((write(Hc, "\n", 1)) != 1)
                fatal("hardcopy accumulator write");
        }
    }
    else {
        switch(Obase) {
        case 2:
            group = 8;
            break;
        case 8:
        case 10:
            group = 3;
            break;
        case 16:
        default:
            group = 4;
            break;
        }
        inlen = strlen(source);
        from = numstart = source;
        while ((*numstart == ' ') || (*numstart == '-')) {
                ++numstart;
                ++from;
        }
        if (*numstart == '.')
            numstart = ZERO;        /* bc does not prepend 0 before . */

        while (*from != '.' && *from != ' ' && *from != '\0')
            ++from;                 /* stop on dot, space or null */

        if (from == source + inlen)        /* no fraction */
            to = &backward[MYBUF - 1];     /* end of source: '\0' */
        else {
            tail = source - from + inlen;  /* on (include) dec. point */
            to = &backward[MYBUF - 1 - tail - (tail-2)/group];

            frommark = from;
            tomark = to;
            *to++ = *from++;
            for (ri = 0; ++ri < tail;) {
                *to++ = *from++;
                if ((ri % group == 0) && (*from != ' '))
                    *to++ = Separator;
            }
            from = frommark;
            to = tomark;
        }
        backward[MYBUF - 1] = '\0';

        if (numstart != ZERO) {
            --to;
            --from;                        /* back to last int digit */
            int_digs = from - numstart;    /* one more, really */
            for (ri = 0; ++ri <= int_digs;) {
                *to-- = *from--;
                if (ri % group == 0)
                    *to-- = Separator;
            }
            *to = *from;                   /* first integer digit */
        }
        if (Negative)
            *--to = *--from;

        if (Justify == JL) {
            strcpy(Tmpbuf, to);
            strcat(Tmpbuf, Sp44);
            Tmpbuf[ACCUMAX] = '\0';
            mvaddstr(ACCUM,ULEFT, Tmpbuf);
            if (Hc != -1 && !Hide) {
            if ((write(Hc, Tmpbuf, strlen(Tmpbuf))) !=
                strlen(Tmpbuf))
                fatal("hardcopy justified left write");
            if ((write(Hc, "\n", 1)) != 1)
                fatal("hardcopy justified left write");
            }
        }
        else {
            for (ri = from - source + 1; --ri;)
                *to-- = *from--;
            *to = *from;          /* to avoid indexing neg. address */
            to = &backward[MYBUF - 1 - ACCUMAX];
            mvaddstr(ACCUM,ULEFT, to);
            if (Hc != -1 && !Hide) {
                if ((write(Hc, to, strlen(to))) != strlen(to))
                    fatal("justified right write");
                if ((write(Hc, "\n", 1)) != 1)
                    fatal("justified right write");
            }
        }
    }
    TR_
}

/* flag values:
   2)     write to Main pipe, clear_accwin, display_accum.  The user
          input string is assumed to have completed processing.
   1)     write to Main pipe, clear_accwin, display_accum only if
          Show is ENA.  (Some functions may withold the current
          result from the stack, by temporarily disabling Stack.)
          The operation always results in a new value from bc, and
          in the clearing of the input string up to the currently
          scanned token.
   0)     write control info to main pipe, redraw Status window.
          This is a one-way  write to bc, no data is returned in
          the pipe; the accumulator and Lastob contents stay intact.
          Error bar under accum does get cleared.
*/

show_result(flag)
int flag;
{
    int Ubuflen, Controlbuflen;
    static char *fid = "show_result";

    _TR
    if (flag) {
        if ((Ubuflen = strlen(Ubuf)) != 0) {
            if (!(Ubuflen == 2 && Ubuf[0] == ';')) {
                if (Ubuf[Ubuflen - 1] != '\n')
                    Ubuf[Ubuflen++] = '\n';

#ifdef DEBUG
fprintf(Dfp, "Ubuf to A_write: %*.*s<<<\n",Ubuflen, Ubuflen, Ubuf);
#endif

                if (write(A_write[1], Ubuf, Ubuflen) == -1)
                    fatal("ubuf to main pipe write");
                clear_accwin();
                wait_main_pipe();

#ifdef DEBUG
fprintf(Dfp, "Mainbuf read: %s<<<\n", Mainbuf);
#endif

                Lastob = Obase;

                if (Do_conv) {
                    Titlq[TALYREQ] = ZERO;
                    show_uconv();
                    conv_usr();
                }

                if (Show == ENA || flag > 1)
                    display_accum(1);
                else
                    display_accum(0);
            }
            Ubuf[0] = '\0';
        }
    }
    else {
        if ((Controlbuflen = strlen(Controlbuf)) != 0) {
            if (Controlbuf[Controlbuflen - 1] != '\n')
                Controlbuf[Controlbuflen++] = '\n';

#ifdef DEBUG
fprintf(Dfp, "Control to A_write: %*.*s<<<\n", Controlbuflen,
    Controlbuflen, Controlbuf);
#endif

            if (write(A_write[1], Controlbuf, Controlbuflen) == -1)
                fatal("controlbuf to main pipe write");
        }
        show_stat();
        Controlbuf[0] = '\0';
        move(CY=UTOP, CX=ULEFT);
        pfresh();
    }
    TR_
}

show_stat()
{
    static char *statstr = "  23456789ABCDEFX";
    register int cur_y = STATY;
    int pyp, pxp;
    static char *fid = "show_stat";

    _TR
    CYX;
    standout();
    mvaddstr(STATY - 1, STATMSG - 1, "    GLOBALS     ");
    standend();

    move(cur_y++, STATMSG);
    printw("    ibase %c   " , statstr[Ibase]);

    move(cur_y++, STATMSG);
    printw("    obase %c   " , statstr[Obase]);

    mvaddstr(cur_y++, STATMSG, (Staybase == ENA) ?  " staybase on  " 
                                                :  " staybase off " );


    move(cur_y++, STATMSG);
    printw("precision %d  " , Precision);

    mvaddstr(cur_y++, STATMSG, (Autoconv == ENA) ?  " autoconv on  " 
                                                :  " autoconv off " );

    if (Format == COMMA_)
        mvaddstr(cur_y++, STATMSG,  "   format ',' " );
    else if (Format == DISA)
        mvaddstr(cur_y++, STATMSG,  "   format off " );
    else /* SPACE_ */
        mvaddstr(cur_y++, STATMSG,  "   format ' ' " );

    if (Hf == FVER)
        mvaddstr(cur_y++, STATMSG,  " hardform ver " );
    else if (Hf == FTER)
        mvaddstr(cur_y++, STATMSG,  " hardform te  " );
    else
        mvaddstr(cur_y++, STATMSG,  " hardform xt  " );

    if (Justify == JF)
        mvaddstr(cur_y++, STATMSG,  "  justify fix " );
    else if (Justify == JR)
        mvaddstr(cur_y++, STATMSG,  "  justify ri  " );
    else
        mvaddstr(cur_y++, STATMSG,  "  justify le  " );

    mvaddstr(cur_y++, STATMSG, (Stack == ENA) ?  "    stack on  " 
                                             :  "    stack off " );
    mvaddstr(cur_y++, STATMSG, (Autotime == ENA) ?  " autotime on  " 
                                             :  " autotime off " );
    Statopts = 0;

    PYX;
    pfresh();
    TR_
}

show_param()
{
    register int cur_y = STATY;
    int pyp, pxp;
    static char *fid = "show_param";

    _TR
    CYX;
    standout();
    mvaddstr(STATY - 1, STATMSG - 1, " STAT  OPTIONS  ");
    standend();

    mvaddstr(cur_y++, STATMSG, "ib   2 --- 16 ");
    mvaddstr(cur_y++, STATMSG, "ob   2 --- 16 ");
    mvaddstr(cur_y++, STATMSG, "sb     off|on ");
    mvaddstr(cur_y++, STATMSG, "pr   0 --- 32 ");
    mvaddstr(cur_y++, STATMSG, "au     off|on ");
    mvaddstr(cur_y++, STATMSG, "fo  sp|off|cm ");
    mvaddstr(cur_y++, STATMSG, "hf  te|ver|xt ");
    mvaddstr(cur_y++, STATMSG, "ju  le|fix|ri ");
    mvaddstr(cur_y++, STATMSG, "st     off|on ");
    mvaddstr(cur_y++, STATMSG, "at     off|on ");

    Statopts = 1;
    PYX;
    pfresh();
    TR_
}

