/* defs.h */
/**********************************************************************
*    File Name     : defs.h
*    Function      : definitions, declarations
*                  :    this header is included in all .c files of pac
*    Author        : Istvan Mohos, 1987
***********************************************************************/

#include <curses.h>
#ifdef REALUNIX
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include <ctype.h>
#include <signal.h>
#include <math.h>

#ifdef TRACE
#define _TR   if (Trace) fprintf(Tf,">%s%s\n",&Ttabs[Tlev--],fid);
#define TR_   if (Trace) fprintf(Tf,"<%s%s\n",&Ttabs[++Tlev],fid);
#else
#define _TR
#define TR_
#endif

#define ZERO  (char *)0

#define LBOUND    1            /* left (inverse) edge of screen */
#define RBOUND    78           /* right (inverse) edge of screen */
#define TOP       1            /* top (inverse) edge of screen */
#define BOT       23           /* bottom (inverse) edge of screen */
#define UTOP      (TOP + 1)    /* user top of calculator window */
#define UBOT      (TOP + 3)    /* user bottom of calculator window */
#define ACCUM     (TOP + 4)    /* result line under calculator window */
#define ACCUMAX   44           /* max calculator,result width */
#define URIGHT    46           /* right user boundary of calculator */
#define DIGMAX    32           /* max calculator (numeric) digits */
#define ULEFT     3            /* left user calculator boundary */
#define MSG       (TOP + 5)    /* vertical location of error message */
#define MSGLEFT   4            /* left boundary of error message */
#define STACKLEFT 3            /* left boundary of stack (base) */
#define STACKTOP  (TOP + 6)    /* upper boundary of stack */
#define STACKBOT  (TOP + 21)   /* lower boundary of stack */
#define STACKMAX  36           /* max stack width (including base) */
#define STACKDEEP 16           /* max number of stack cells */
#define MYBUF    300           /* scratch display buffer */

#define ATOIX      50          /* leftmost char printed into ATOI */
#define AMTY       7           /* vert location of loan AMT */
#define PRCY       8           /* percent */
#define YRY        9           /* years */
#define PAYY      10           /* payment */
#define DATY      11           /* start date */
#define LOANX      44          /* leftmost char printed into LOAN */
#define LOANSIZ    13          /* max width of LOAN line */
#define LOANR      (LOANX + LOANSIZ - 1)
#define STATMSG    44          /* leftmost char printed into STATUS */
#define STATX      54          /* left edge of 3 char status flag */
#define STATY      (TOP + 12)  /* ver location of first status string */

                               /* status defaults */
#define PREC_DFLT  2           /* precision (# of digits past dp) */
#define IB_DFLT    10          /* input base */
#define OB_DFLT    10          /* output base */
#define DISA       0
#define ENA        1
#define AP         2
#define STACK_DFLT ENA         /* new result gets pushed on stack */
#define COMMA_      1
#define SPACE_      2
#define FORM_DFLT  SPACE_       /* put commas or spaces in numbers */
#define ED_DFLT    ENA         /* unimplemented */
#define JL         0
#define JF         1
#define JR         2
#define JUS_DFLT   JR          /* right, left, or fixed dp on right */
#define SB_DFLT    DISA        /* radix change effects current string */
#define SHOW_DFLT  DISA        /* don't pfresh until done */
#define FVER       0
#define FTER       1
#define FXTER      2
#define HF_DFLT    FVER        /* file dump verbose, terse or xterse */

#define REGLEFT    3           /* leftmost char of stack cell (base) */
#define CONVLEFT   60          /* leftmost char of CONV. labels */
#define KEYLEFT    74          /* leftmost char of CONV. 3 char key */
#define FITCONV    (BOT - TOP - 1) /* max conv strings visible */
#define CONVCOUNT  24          /* number of predefined conversions */
#define FROMTOSIZ  14          /* conv. label size + \0 */
#define KEYSIZ     4           /* conv key size + \0 */
#define CONVMAX    (FROMTOSIZ + KEYSIZ - 1) /* conv string window siz */
#define CENTER     11          /* non_curses pos. in conv window */
#define CONVSEL    (CENTER - 1)/* original (default) selection */

#define TREQ       2           /* update requests to print top line */
#define BREQ       9           /* update requests to print bottom line */
#define MSGLEN    13
#define FBOUND    (ULEFT + MSGLEN) /* where the screen fname starts */
#define BUFSTOP   (FBOUND - ULEFT) /* where fname starts in buffer */
#define TITSIZ    (RBOUND - ULEFT + 1)
#define TALYREQ    1
#define FILEREQ    2
#define POSTREQ    3
#define TOTLREQ    4
#define TAPPREQ    5
#define LOANREQ    6
#define CONVREQ    7
#define EDITREQ    8

#define NOTINLIST -1           /* not recognized by pac tokenizer */
#define PIPEMAX   4096         /* guaranteed min size by UNIX */
#define WINLINE   81           /* max screen line + \0 */
#define LINEMAX   256          /* rough line size */

#define INIT        0          /* prior to curses, to die properly */

#define CYX       pyp=CY, pxp=CX
#define PYX       move(CY=pyp, CX=pxp)
/* all functions must return cursor to starting CY, CX coordinates */

#define E_SYNTAX    1          /* bc errors */
#define E_DIVBY0    2
#define E_EXPONENT  3
#define E_OVERFLOW  4
#define E_BCEXEC    5

struct stk_cell {
    char cell[STACKMAX + 1];
    struct stk_cell *link;
};

struct stk_cell *find();
char *pactok();                /* seems to be missing in 4.2BSD */
char *bitwise();
char *substivar();
char *numform();
char *getenv();
char *calloc(), *malloc();
char *ctime();
char *strcat(), *strncat(), *strcpy(), *strncpy();
char *gets();
FILE *fopen();
double atof();                    /* amortization variables */
long time(), lseek();
unsigned alarm();
int  go_away();
int  cdate();

#ifdef MAIN                    /* globals are defined in pac.c,
                                  declared as externs elsewhere */

FILE *Tf = NULL;
FILE *Dfp = NULL;
char *Home, Rcfile[LINEMAX];      /* pac environment */
int  Rcfd, Rcerr;

char *Cb[] = {
"pac          PANEL CALCULATOR                    ATOI    ",
"pac          PANEL CALCULATOR                    ATOI    "
};
char *Sb[] = {
"pac          PANEL CALCULATOR                    ATOI     CONVERSIONS  TO   ",
"pac          PANEL CALCULATOR                    ATOI          TOTAL        "
};
char *Titlq[TREQ];
char *Basq[BREQ];
char *Bb[] = {
"TAB bye  <CTRL> Exit Redraw File Postpend Klock Globals Loan Newconv Total  ",
"<CTRL> File Postpend Toggle_back  copy: a...t  up_down: A...S  transfer: T  ",
"file  write: hardcopy                                                       ",
"file  contd: hardcopy                                                       ",
"total write: hardtotal                                                      ",
"total contd: hardtotal                                                      ",
"amort write: hardamort                                                      ",
"new  value =                                                                ",
"new formula:                                                                "
};
char *Hardname =
"hardcopy                                                       ";
char *Totname =
"hardtotal                                                      ";
char *Amortname =
"hardamort                                                      ";

char Spreadbuf[PIPEMAX * 2];      /* expand user input for tokenizing */
char Tokbuf[PIPEMAX];             /* strcomp against key list */
char Mainbuf[PIPEMAX];            /* Mainbuf (result) from bc */
char Convbuf[PIPEMAX];            /* converter result from bc */
char Ubuf[PIPEMAX];               /* unrecognized tokens, to bc */
char Controlbuf[PIPEMAX];         /* recognized tokens effect control */
char *Tokp[PIPEMAX], *Last;       /* Spreadbuf pointers */
char Rebuf[PIPEMAX];              /* work buffers */
char Tmpbuf[PIPEMAX];
char Mop[PIPEMAX];
char Uwin_copy[(UBOT - UTOP + 1) * (URIGHT - ULEFT + 1)];

int Context   = INIT;             /* initial status values */
int Justify   = JUS_DFLT;
int Format    = FORM_DFLT;
int Stack     = STACK_DFLT;
int Hide      = 0;
int Dontsave  = 0;
int Clockstat = DISA;
int Show      = SHOW_DFLT;
int Autotime  = DISA;             /* no clock until user asks */
int Hf        = HF_DFLT;
int Ibase     = IB_DFLT;
int Obase     = OB_DFLT;
int Oldib     = IB_DFLT;
int Oldob     = OB_DFLT;
int Lastob    = OB_DFLT;
int Staybase  = DISA;
int Precision = PREC_DFLT;
int Edhelp    = ED_DFLT;
int Autoconv  = DISA;              /* Autoconverter feature */
int Convcount = CONVCOUNT;
int Convsel   = CONVSEL;
int Hardcopy  = DISA;
int Totcopy   = DISA;
int Painted   = FALSE;            /* don't push init vals on Stack */

double Amt;
double Years;
double Rate;
double Pymt;
double Showpymt;
double Intrst;
double I_mo;
double Months;

int Negative;
int Too_big;
int Has_dp;

char *Base_str = "$$23456789 bcdefx";  /* formatting aids */
char *Sp44 = "                                            ";
char *Sp34 = "                                  ";
char *Sp13 = "             ";
char *Fix32 = "00000000000000000000000000000000";
char *Emptycell = "  0                                 ";

char Separator = ' ';             /* must agree with FORM_DFLT */

int A_ret = 0;
int B_ret = 0;
int A_write[2], A_read[2];        /* main bc process pipes */
int Nread;                        /* main bc process globals */
int B_write[2], B_read[2];        /* bc converter process pipes */
int Hc = -1;                      /* Hardcopy file fd */
int Tc = -1;                      /* Total file fd */
int Tqlev = 0;
char *Thisyear;
int Do_conv, O_conv;              /* activate selected conv function */
int Convread;                     /* bc converter process */
int Topconv;                      /* top conversion of conv vindow */
char *Convhom;                    /* conv malloc pointer */
char Eq_buf[WINLINE];             /* new conv string input by user */
char K_buf[KEYSIZ];               /* 3 char new key input by user */
char L_buf[FROMTOSIZ];            /* new conv label input by user */
unsigned int Convhsiz;

                                  /* predefined user conversions */
char *Convlist[256][3] = {
{"km2      acre", "acr", "\\*247.1"},
{"gram avoir_oz", "av ", "\\*.035274"},
{"fahr. celsius", "c  ", "(\\-32)*.55555555555555555555555555555555"},
{"fluid_oz   cc", "cc ", "\\*29.573"},
{"inch       cm", "cm ", "\\*2.54"},
{"radian degree", "deg", "\\*57.295779513082321"},
{"celsius fahr.", "f  ", "\\*1.8+32"},
{"meter    foot", "ft ", "\\*3.2808"},
{"avoir_oz gram", "g  ", "\\*28.3495"},
{"liter  gallon", "gal", "\\*.26418"},
{"cm       inch", "in ", "\\*.3937"},
{"inversion    ", "inv", "1/\\"},
{"pound      kg", "kg ", "\\*.45359"},
{"mile       km", "km ", "\\*1.6093"},
{"acre      km2", "km2", "\\*.004046"},
{"kg      pound", "lb ", "\\*2.2046"},
{"gallon  liter", "lit", "\\*3.7854"},
{"foot    meter", "m  ", "\\*.3048"},
{"km       mile", "mi ", "\\*.6214"},
{"mile nautical", "nau", "\\*.8689784566"},
{"nautical mile", "nmi", "\\*1.150776515"},
{"cc   fluid_oz", "oz ", "\\*.03381"},
{"degree radian", "rad", "\\*.01745329251994329"},
{"sentinel     ", "|||", "1"}};        /* sentinel; do not remove */

int Status;                            /* exit for fatal */
int CX, CY;                            /* global cursor control */
char Onebuf[STACKMAX + 1];             /* temp store for 1 stack cell */
int Statopts;                          /* Status display window flag */
struct stk_cell Stk[STACKDEEP + 1];
int Bc_error;
int Trace;
int Tlev;
char Ttabs[] = {"\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"};
int (*Save_sig[8])();
char ierbuf[256];

#else

extern FILE *Tf;
extern FILE *Dfp;
extern char *Titlq[];
extern char *Basq[];
extern char *Cb[], *Sb[];
extern char *Bb[];
extern char Spreadbuf[];
extern char Tokbuf[];
extern char Controlbuf[];
extern char *Tokp[], *Last;
extern int Negative, Too_big, Has_dp;
extern char Rebuf[];
extern char Tmpbuf[];
extern char Mop[];
extern char Uwin_copy[];

extern int Context;
extern int Justify;
extern int Format, Stack, Hide, Dontsave;

extern int  Ibase, Obase, Oldib, Oldob, Lastob, Staybase, Precision;
extern int  Show, Clockstat, Autotime;
extern char *Base_str;
extern int  CX, CY;
extern char Ubuf[], Mainbuf[], Convbuf[];
extern char *Sp44, *Sp34, *Sp13, *Fix32, *Emptycell;
extern char Separator;
extern int  A_write[], A_read[], A_ret, Nread;
extern int  B_write[], B_read[], B_ret, Convread;
extern int  Status, Painted;
extern char *Home, Rcfile[];
extern int  Rcfd, Rcerr;
extern char Onebuf[STACKMAX + 1];
extern int  Hardcopy, Hc, Hf;
extern char *Hardname;
extern char *Amortname;
extern char *Totname;
extern int  Totcopy, Tc, Tqlev;
extern int  Autoconv;
extern int  Convcount;
extern int  Convsel;
extern int  Do_conv, O_conv;
extern int  Topconv;
extern char *Convlist[][3];
extern char *Convhom;
extern char *Thisyear;
extern char Eq_buf[];
extern char K_buf[], L_buf[];
extern unsigned int Convhsiz;
extern int  Statopts;
extern struct stk_cell Stk[];
extern int  Edhelp;
extern int  Bc_error;
extern int  Trace;
extern int  Tlev;
extern char Ttabs[];

extern double atof();
extern double Amt;
extern double Years;
extern double Rate;
extern double Pymt;
extern double Showpymt;
extern double Intrst;
extern double I_mo;
extern double Months;

extern int (*Save_sig[])();
extern char ierbuf[];

#endif
