/*
 * Main include file for 'strings'.
 * Tests Makefile flags and takes appropriate action.
 * Includes most include files and predefines global defines.
 *
 * sccsid : @(#)  strings.h  (v6.3 5/22/89)
 */

# include "config.h"

# if defined(DEBUG)
#	include <stdio.h>
# else
#	define stderr	2
#	define NULL		0
# endif DEBUG

# ifdef FCNTL
#	if FCNTL == 1
#		include <fcntl.h>
#	endif
#	if FCNTL == 2
#		include <sys/fcntl.h>
#	endif
# else FCNTL
#	define O_RDONLY	0
# endif FCNTL

# ifdef DEBUG
FILE * prot;
# endif

# ifdef I_SPECIAL
#	ifdef WHAT_LSEEK
#		if WHAT_LSEEK == 1
#			define LSEEK_TYPE	long
#		endif
#		if WHAT_LSEEK == 2
#			define LSEEK_TYPE	int
#		endif
#	endif WHAT_LSEEK

#	ifndef LSEEK_TYPE
#		include "ERROR : WHAT_LSEEK defined wrongly"
#	endif LSEEK_TYPE

extern LSEEK_TYPE lseek (/* int fd; LSEEK_TYPE offset; int whence */);

# else I_SPECIAL
/*
 * If I_SPECIAL is not defined we don't need lseek, but we need a type
 * for offsets.
 */
#	define LSEEK_TYPE	long
# endif I_SPECIAL

# if THRESHOLD < IN_BUF_LEN
#	include "ERROR : THRESHOLD must be >= IN_BUF_LEN"
# endif

extern char * malloc ();
extern char * realloc ();

# define CHAR_TYPE	char
