/*
 * This file is used within strings.
 * You can add specific defines for a machine below. Define neither
 * SAFETY_FIRST nor USE_USER_DEFINES
 * Defines for your current machine should go in tune.h. Define
 * USE_USER_DEFINES.
 *
 * sccsid : @(#)  config.h  (v6.5 5/22/89)
 *
 * FOUND will contain a string telling what defines have been used.
 */

# ifndef SAFETY_FIRST
#	ifdef USE_USER_DEFINES
#		define FOUND		"Using the user defines."
#		include "tune.h"
#	else USE_USER_DEFINES
		/*
		 * Add (all) defines for your machine here.
		 */
#		if defined(nsc32000) && defined(sinix) && defined(ns16000)
#			define FOUND						"Using defaults for sinix MX2."
#			define FCNTL						2
#			define FAST_COPY(from,to,count)		bcopy(from,to,count)
#			define WHAT_LSEEK					1
#			define I_SPECIAL
#			define IN_BUF_LEN					1024
#			define OUT_BUF_LEN					8192
#			define THRESHOLD					1024
#		endif /* nsc32000 && sinix && ns16000 */
#		if defined(unix) && defined(vax) && !defined(ultrix)
#			define FOUND						"Using defaults for VAX (BSD?)."
#			define FCNTL						1
#			define FAST_COPY(from,to,count)		bcopy(from,to,count)
#			define WHAT_LSEEK					1
#			define I_SPECIAL
#			define IN_BUF_LEN					4096
#			define OUT_BUF_LEN					16384
#			define THRESHOLD					4096
#		endif /* vax */
#		if defined(unix) && defined(sun) && defined(mc68020)
#			define FOUND						"Using defaults for SUN (SUN OS 3.*)."
#			define FCNTL						1
#			define FAST_COPY(from,to,count)		bcopy(from,to,count)
#			define WHAT_LSEEK					1
#			define I_SPECIAL
#			define IN_BUF_LEN					4096
#			define OUT_BUF_LEN					16384
#			define THRESHOLD					4096
#		endif /* sun */
#		if defined(unix) && defined(ultrix) && defined(bsd4_2)
#			define FOUND						"Using defaults for VAX (ULTRIX 2.0)"
#			define FCNTL						1
#			define FAST_COPY(from,to,count)		bcopy(from,to,count)
#			define WHAT_LSEEK					1
#			define I_SPECIAL
#			define IN_BUF_LEN					4096
#			define OUT_BUF_LEN					16384
#			define THRESHOLD					4096
#		endif /* vax ultrix */
#		if defined(vms) && defined(vax)
#			define FOUND						"Using defaults for VAX (VMS)"
/* don't define FCNTL, O_RDONLY flag is in file.h and is 0 */
#			define FAST_COPY(from,to,count)		memcpy(to,from,count)
#			define WHAT_LSEEK					2
/*			define I_SPECIAL*/
#			define IN_BUF_LEN					4096
#			define OUT_BUF_LEN					16384
#			define THRESHOLD					4096
#		endif /* vax ultrix */
#	endif USE_USER_DEFINES
# endif SAFETY_FIRST

# ifndef FOUND
/*
 * We have to use the defaults.
 */
#	define FOUND							"Using minimal defaults."
/* dont	define FCNTL */
/* FAST_COPY will be a real routine */
#	define WHAT_LSEEK						1
/* don't define I_SPECIAL */
#	define IN_BUF_LEN						1024
#	define OUT_BUF_LEN						8192
#	define THRESHOLD						1024

# endif FOUND
