/*
 *
 * sccsid = @(#)  tune.h  (v6.2 5/17/89)
 * 
 * This file contains the flags with which you can tune strings.
 * Define USE_USER_DEFINES in Makefile to really get them going.
 */

/*
 * Look in /usr/include, /usr/include/sys, ...
 * Where are the flags O_RDONLY, O_WRONLY, ... ?
 * Define FCNTL as
 * 1 : /usr/include/fcntl.h
 * 2 : /usr/include/sys/fcntl.h
 * If they are not defined, then omit FCNTL.
 * strings will use old flag 0 (read only).
 *
 * Examples:
 * vax BSD43, sun SUN OS  : 1
 * mx2 SINIX (System III) : 2
 */
# define FCNTL 2

/*
 * We copy sequences of characters with a fast memory copy routine.
 * On BSD systems this routine is called bcopy. Its usage is :
 *		bcopy (from, to, count)
 * On SYS 5 systems this routine is called memcpy. Its usage is :
 *		memcpy (to, from, count)
 * Decide what your system uses and define bcopy accordingly.
 * If you don't define FAST_COPY here, a routine of my own, called
 * FAST_COPY will be used.
 */
# define FAST_COPY(from,to,count)		bcopy(from,to,count)

/*
 * Take a look at your manual. What does it say about 'lseek' ?
 * Is it :
 * 1 : long lseek (int fd, long dist, int whence)
 * 2 : int lseek (int fd, int dist, int whence)
 * If it is something else, you will have to change the source. You can
 * ignore it of course, if int==long on your machine.
 */
# define WHAT_LSEEK	1

/*
 * As a default strings looks at the beginning of a file. If it thinks
 * it has found an object, it only examines the initialized data in it.
 * If you want this behaviour define I_SPECIAL. If you always want the
 * whole file examined, or if you are on a non-UNIX machine where the
 * identification of object files is different, do not define I_SPECIAL.
 */
# define I_SPECIAL

/*
 * How big should the buffers be?
 * IN_BUF_LEN  : Length of input buffer for reads.
 * OUT_BUF_LEN : Maximal size of output buffer.
 * TRHESHOLD   : Minimal size for writes. If the output buffer grows beyond
 *               THRESHOLD then it is output.
 */
# define IN_BUF_LEN		1024
# define OUT_BUF_LEN	8192
# define THRESHOLD		1024
