/*------------------------------------------------------------------------------
Title:	Prim's MST Algorithm for MPSim Simulator 
File:	prim_node.c
Dscrp:	Cube node program, obtain from manager the partition of the grap to
	process with the Prim's MST algorithm.
Author:	Felix E. Quevedo
Date:	Oct. 1989
------------------------------------------------------------------------------*/
#include "prim.h"

main()
{
					/* Cube System Variables */
	int node;
	int type, rcnt, rnode, rpid;
	int numnodes;

					/* Application Variables */	
	int i, j, k, n;
	int from, to, dad, mlen;
	int vec[3], rvc[3], wgt[NN][2], bs[2];

					/* SetUp system variables */
	node = mynode();
	numnodes = mpdim();

					/* receive from Host size of graph */
	recv(&rpid, &n, sizeof(int), &type, HTYPE);

					/* SetUp application variables */
	mlen=3*sizeof(int);			/* message length */
	from=node?lg2(pw2(lg2(node)+1)):0;		/* initial child node index */
	to=from+lg2(n/2)-lg2(2*node);		/* final child node index */
	dad=(node)?node-pw2(i=lg2(node)):HNODE; /* parent node index */
	bs[0]=bs[1]=0;				/* initial base */
	/*printf("NODE %d: from %d, to %d, dad %d\n", node, from, to);*/

					/* receive from Host graph partition */
	recv(&rpid, wgt, sizeof(int)*2*NN, &type, HTYPE);

			/* Loop For until all graph nodes have been on base */
	for(i=0; i<n-1; i++) {
        /*printf("%d:%d processing...\n", node, getpid());*/
					/* local minimum */
		k=(wgt[bs[1]][1]<wgt[bs[0]][0])?1:0;
		vec[0]=bs[k];			/* save minimum index from */
		vec[1]=2*node+k;		/* save minimum index to */
		vec[2]=wgt[bs[k]][k];		/* save minimum weight */
					
		for(j=from; j<to; j++) { /* receive from child their minimum */
			recv(&rpid, rvc, mlen, &type, NTYPE);
			if(rvc[2]<vec[2])	/* child has minimum: save it */
				for(k=0; k<3; vec[k]=rvc[k++]);
		}

					/* send and receive from parent */
		if(node){			/* if not first cube node */
			send(dad, vec, mlen, NTYPE);
			recv(&rpid, vec, mlen, &type, NTYPE);
					/* if parent has minimum: change base */
			if(wgt[vec[0]][0]<wgt[bs[0]][0]) bs[0]=vec[0];
			if(wgt[vec[0]][1]<wgt[bs[1]][1]) bs[1]=vec[0];
		}
		else {			/* if first cube node: send to HOST */
			send(HNODE, vec, mlen, NHTYPE);
			vec[0]=vec[1];		/* save new base! */
		}

		k=vec[0]-2*node;	/* if I have base: fill with INF */
		if(k==1||k==0) for(j=0; j<n*2; wgt[j++][k]=INF);

		for(j=from;j<to;	/* send to childs new base */
                        /*printf("%d: send to %d\n", node, node+pw2(j)),*/
			send(node+pw2(j++), vec, mlen, NTYPE));
	}
}
