/* FQSystems -------------------------------------------------------------------

    File  : mpusr.c
    Title : User library
    Author: Felix E. Quevedo Stuva.
    Date  : May 12, 1989

----------------------------------------------------------------------------- */
#define _MPLIB_
#include "mpdef.h"
#include <varargs.h>
#include <sys/stat.h>

struct stat stype[1];
char tmpbf[80];
char tbuf[20];
int bft=0; /* indicate that buffer has been touch */

static _pause_handler()
{
	(*Ptbl).prc[mynode()].ppw = 1;
}

_getpt() /* asure that MP is setup */
{
    int i;

    if(Ptbl<=0)
        if((i=shmget(geteuid(), sizeof(MP_TBL), 0777))>NIL)
            Ptbl=(MP_TBL *)shmat(i, 0, 0);
    if(Ptbl>0) return;
    mperror(1, "User: _getpt");
}

char *_trchd()
{
    _getpt();
    if(!bft) {
        tbuf[0]=0;
        bft=1;
        if(mehost())
            sprintf(tbuf, "User: HOST   ,");
        else
            sprintf(tbuf, "User: NODE %2d,", mynode());
    }
    return tbuf;
}

_imhost() /* security gateguard for host commands */
{
    _getpt();
    if (mehost()) return;
    mperror(6, "User: _imhost");
}

mprnd() /* return number of nodes running */
{
    _getpt();
    return (*Ptbl).mpr;
}

mpdim() /* return maximum number of nodes available */
{
    _getpt();
    return (*Ptbl).mpn;
}

mynode() /* return current node number */
{
    int i, j;

    _getpt();
    j = getpid();
    for(i=NIL; i<(*Ptbl).mpn && (*Ptbl).prc[i].pid != j; i++);
    if (i<(*Ptbl).mpn && (*Ptbl).prc[i].pid == j)
        return (*Ptbl).prc[i].pno;
    sprintf(tmpbf, "UNIX PID: %d is NOT a MP node!\n", getpid());
    mperror(999, tmpbf );
}

load(fn, nd) /* load node command and execute */
char *fn;
int nd;
{
    int i, j;

    mpprint("%s loading node comand\n", _trchd());
    _imhost();                          /* be sure that I'm the host */
    if((i=stat(fn, stype))==-1) {       /* is the node exec exists? */
        sprintf(tmpbf, "%s load, file %s does NOT exist!\n", _trchd(), fn);
        mperror(999, tmpbf );
    }
    else
        if ((*stype).st_mode & S_IEXEC) { /* is the node exec executable */
            if (nd>-2 && nd<MAX_PRC) {       /* is the node a legal one? */
                _mplnode(fn, nd);               /* load nodes */
                (*Ptbl).mpq=nd;                 /* start request */
                kill(getppid(), SIGUSR1);       /* ask simulator to start request */
                for(;(*Ptbl).mps!=PRUNNING;);   /* wait for MPStart to setup */
            }
            else {
                sprintf(tmpbf, "%s load, illegal node %d\n", _trchd(), nd);
                mperror(999, tmpbf);
            }
        }
        else {
            sprintf(tmpbf, "%s load, file %s is NOT executable\n", _trchd(), fn);
            mperror(999, tmpbf);
        }
}

_mvstr(from, to, len)
int len;
char *from, *to;
{
    int i;
    for(i=0; i<len; to[i]=from[i], i++);
}

_rcvm(prcn, txt, len, type, wtyp, mode) /* receive from the msg queue */
int len, *type, *prcn, wtyp, mode;
char *txt;
{
    int i, j;
    _getpt();
    i = mynode();
    (*Ptbl).prc[i].pst = PBLOCKED;
    mpprint("%s waiting for msg type %d\n", _trchd(), wtyp);
    if((j=msgrcv((*Ptbl).prc[i].cmi, &Rmsg, MSG_LEN, wtyp, mode))>NIL) {
        *type= Rmsg.mtype;
        Tmsg = (MSG_TXT *)Rmsg.mtext;		/* this command FIRST */
        *prcn= (*Tmsg).mwho;
        if(len != (*Tmsg).mlen) {       /* if expected len != recv len then abort */
            sprintf(tmpbf, "%s recv, msg len snd %d and rcv %d does NOT match!\n",
                    _trchd(), len, (*Tmsg).mlen);
            mperror(999, tmpbf);
        }
        _mvstr(&(*Tmsg).mtxt, txt, len);
										/* NO mpprint before this line!!!! */
        mpprint("%s recv from %d, len %d, type %d\n", _trchd(), *prcn, len, *type);
        (*Ptbl).prc[i].mrcv++;
    }
    if(j==NIL) mpprint("%s UNSUCCESSFUL recv len %d, type %d\n", _trchd(), len, wtyp);
    (*Ptbl).prc[i].pst = PRUNNING;
    return j;
}

recv(prcn, txt, len, type, wtyp) /* receive from the msg queue */
int len, *type, *prcn, wtyp;
char *txt;
{
    return _rcvm(prcn, txt, len, type, wtyp, 0); /* receive from the msg queue */
}

trcv(prcn, txt, len, type, wtyp) /* test and receive from the msg queue */
int len, *type, *prcn, wtyp;
char *txt;
{
    return _rcvm(prcn, txt, len, type, wtyp, IPC_NOWAIT); /* receive from the msg queue */
}

send(prcn, txt, len, type) /* send a msg */
int prcn, len, type;
char *txt;
{
    int i;
    _getpt();
    Smsg.mtype=type;
    Tmsg = (MSG_TXT *)Smsg.mtext;		/* this command FIRST */
    _mvstr(txt,&(*Tmsg).mtxt, len);
    i=(*Tmsg).mwho = mynode();
    (*Tmsg).mlen = len;
    if(msgsnd((*Ptbl).prc[prcn].cmi, &Smsg, 2*sizeof(int) + len, 0)==0) {
							/* NO mpprint before this line!!!! */
		kill((*Ptbl).prc[prcn].pid, SIGUSR2);
        mpprint("%s sent to %d, len %d, type %d\n", _trchd(), prcn, len, type);
        (*Ptbl).prc[i].msnd++;
        return 0;
    }
    mpprint("%s UNSUCCESSFUL send to %d, len %d, type %d\n", _trchd(), prcn, len, type);
    return NIL;
}

probe(i)
int i;
{
    struct msqid_ds buf[1];

    _getpt();
    if(!i)mpprint("%s testing msg queue\n", _trchd());
    if(msgctl((*Ptbl).prc[mynode()].cmi, IPC_STAT, buf) != NIL)
        return (*buf).msg_qnum;
    return 0;
}

crtshm(sz)
int sz;
{
    _imhost();                          /* be sure that I'm the host */
    mpprint("%s creating shared memory segment\n", _trchd());
    (*Ptbl).mpm = shmget(geteuid()+1, sz, 0777|IPC_CREAT);
    if((*Ptbl).mpm > 0) {
        return attshm();
    }
    else
        mperror(3, _trchd());
}

attshm()
{
    int i;
    _getpt();
    mpprint("%s attaching share memory segment\n", _trchd());
    i=(int)shmat((*Ptbl).mpm, 0, 0);
    if(i>0)
        return i;
    mperror(4, _trchd());
}

detshm()
{
    _getpt();
    mpprint("%s dettaching share memory segment\n", _trchd());
    return shmdt(shmat((*Ptbl).mpm, 0, 0));
}

slpmsq() /* sleep until new message is queued */
{
    int i=mynode();
    mpprint("%s sleeping until new message, current %d\n", _trchd(), probe());
	signal(SIGUSR2, _pause_handler);
	if(!(*Ptbl).prc[i].ppw) {
        pause();
	}
	(*Ptbl).prc[i].ppw=0;
}
