/* FQSystems -------------------------------------------------------------------

    File  : mpsys.c
    Title : MultiProcessor Simulator System File
    Author: Felix E. Quevedo Stuva.
    Date  : May 12, 1989.

----------------------------------------------------------------------------- */
#include "mpdef.h"

static _handler_req()
{
    if((*Ptbl).mpq>=0) {
        _mprun((*Ptbl).mpq);
        (*Ptbl).mps=PRUNNING;
    }
    else {
        (*Ptbl).mps=PREADY;
        _mpstart(0);
    }
}

static _handler_chl()
{
    int p, i, r, j, (*oh)();
    union wait stts[1];
    struct rusage rsg[1];
    char wht[20];

    while((p=wait3(stts, WNOHANG, rsg))>0) {
        r=(*stts).w_retcode;
        for(i=j=0, i--; (*Ptbl).prc[i].pid!=p && (*Ptbl).mpn>i; i++);
        if WIFEXITED(*stts) {
            strcpy(wht, "EXITED\n");
            (*Ptbl).prc[i].pid = 0;
            (*Ptbl).prc[i].pst = PREADY;
            if(r) {
                mpprint("Warning, NODE %d has exited with RC=%d\n", i, r);
            }
			if(i == NIL) _mpkill(9);
        }
        else
        if WIFSIGNALED(*stts) {
            strcpy(wht, "SIGNALED\n");
            (*Ptbl).prc[i].pid = 0;
            (*Ptbl).prc[i].pst = PREADY;
            mpprint("Warning, NODE %d signaled SIG=%d\n", i, (*stts).w_stopval);
        }
        else
        if WIFSTOPPED(*stts) {
            strcpy(wht, "STOPPED\n");
            (*Ptbl).prc[i].pst = PBLOCKED;
        }
        j=(*Ptbl).mpt;
        (*Ptbl).mpt=1;
        mpprint("NODE %2d: RC %2d CPU%6d SYS%6d MSND%4d MRCV%4d %s", i, r,
            (*rsg).ru_utime.tv_usec/1000, (*rsg).ru_stime.tv_usec/1000,
            (*Ptbl).prc[i].msnd, (*Ptbl).prc[i].mrcv, wht);
        (*Ptbl).mpt=j;
        if((*Ptbl).mpr>0) (*Ptbl).mpr--;
    }
    if(!(*Ptbl).mpr) (*Ptbl).mps=PREADY;
}

static _handler_sys()
{
    int i, j, k;
    struct itimerval val[1];
    struct itimerval oval[1];
    if(Ptbl) {
        for(i=0, i--; i<(*Ptbl).mpn; i++) {
            if((*Ptbl).prc[i].pid)
                kill((*Ptbl).prc[i].pid, SIGKILL);
            msgctl((*Ptbl).prc[i].cmi, IPC_RMID, 0);
        }
        shmctl((*Ptbl).mpm, IPC_RMID, 0);
        shmctl(shmget(geteuid(), sizeof(MP_TBL), 0777), IPC_RMID, 0);
    }
    (*val).it_interval.tv_usec=(*val).it_value.tv_usec=0;
    setitimer(ITIMER_REAL, val, oval);
    exit(0);
}


_mpinit(n)
int n;    /* number of starting processors */
{
    int i, j, k;

    if(n < MIN_PRC)
        printf("Minimum # of Nodes (%d) NOT REACHED!\n", MIN_PRC);
    else
    if (n > MAX_PRC)
        printf("Maximum # of Nodes (%d) EXCEEDED!\n", MAX_PRC);
    else {
        signal(SIGCHLD, _handler_chl);
        signal(SIGUSR1, _handler_req);
        signal(SIGUSR2, SIG_IGN);
        for(i=1; i<17; signal(i++, _handler_sys));
        ShmId = shmget(geteuid(), sizeof(MP_TBL), 0777|IPC_CREAT);
        if (ShmId > NIL) {
            Ptbl = (MP_TBL *)shmat(ShmId, 0, 0);
            if (Ptbl > 0) {
                (*Ptbl).mpn = n;
                (*Ptbl).mpm = 0;
                (*Ptbl).mpt = 0;
                (*Ptbl).mps = PEMPTY;
                strcpy((*Ptbl).mpl, "MPSYSLOG");
                for(i=0, i--; i<n; i++) {
                    (*Ptbl).prc[i].pid = 0;
                    (*Ptbl).prc[i].ppw = 0;
                    (*Ptbl).prc[i].pno = i;
                    (*Ptbl).prc[i].pst = PEMPTY;
                    (*Ptbl).prc[i].cmi = 0;
                    (*Ptbl).prc[i].msnd= 0;
                    (*Ptbl).prc[i].mrcv= 0;
                    (*Ptbl).prc[i].cdp[0] = 0;
                }
            }
            else mperror(3, "Sim: init");
        }
        else mperror(4, "Sim: init");
		return;
    }
	mperror(999, "Sim, init");
}

_mpkill(sig)
int sig;
{
    int i;

    if(Ptbl)
    {
        for(i=0, i--;i<(*Ptbl).mpn;i++)
            if((*Ptbl).prc[i].pid)
                kill((*Ptbl).prc[i].pid, sig);
    }
    else mperror(1, "Sim: kill");
}

_mplhost(cmd)
char *cmd;
{
    if(!cmd) return mperror(5, "Sim: lhost");
    strcpy((*Ptbl).mph.cdp, cmd);
    mpprint("HOST, Command %s loaded!\n", (*Ptbl).mph.cdp);
    (*Ptbl).mps=(*Ptbl).mph.pst=PREADY;
}

_mprun(j)
int j;
{
    int n, i, k;

    if (Ptbl > 0) { /* if Mp is setup */
        i=fork();         /* create child process */
        if(i>0) {         /* I'm still daddy. */
            (*Ptbl).prc[j].pid = i;   /* save Unix pid */
            (*Ptbl).mpr++;        /* more running successful */
            msgctl((*Ptbl).prc[j].cmi, IPC_RMID, 0);
            (*Ptbl).prc[j].cmi = msgget(geteuid()+i, 0777|IPC_CREAT);
            (*Ptbl).prc[j].msnd = 0;  /* initiate msg snd counter */
            (*Ptbl).prc[j].mrcv = 0;  /* initiate msg rcv counter */
        } else
        if(!i) {           /* I'm child */
            signal(SIGINT, SIG_IGN);  /* setup ignore INT signal */
            signal(SIGUSR2,SIG_IGN);  /* setup ignore USR2 signal */
            (*Ptbl).prc[j].pst=PBLOCKED; /* status child blocked */
            for(;(*Ptbl).mps!=PRUNNING;);/* wait for MP setup */
            (*Ptbl).prc[j].pst=PRUNNING; /* status child running */
                                         /* exec user process */
            i=execl((*Ptbl).prc[j].cdp, (char *)0);
            if(mehost()) { /* inform system error */
                printf("HOST, SYSTEM ERROR!  Couldn't EXECL\n");
                mpprint("HOST, Couldn't EXECL %s, RC %d\n",
                    (*Ptbl).prc[j].cdp, i);
            }
            else {
                printf("NODE %2d, SYSTEM ERROR!  Couldn't EXECL\n",j);
                mpprint("NODE %2d, Couldn't EXECL %s, RC %d\n",
                    j, (*Ptbl).prc[j].cdp, i);
            }
            exit(999);
        }
        else { /* SYSTEM ERROR!, terminate simulator now! */
            printf("NODE %2d, SYSTEM ERROR!  Couldn't fork \n",j);
            mpprint("NODE %2d, SYSTEM ERROR!  Couldn't fork \n",j);
            _mpterm();
        }
    }
    return 0;
}

_mpstart(b)
int b;      /* initial node to start MP simulation */
{
    int n, i, j, k;

    if (Ptbl > 0) {
        switch ((*Ptbl).mps) {
        case PEMPTY:
            printf("MPStart, MP Simulator is not ready!  MPLoad first!\n",j);
        break;
        case PREADY:
            n=(*Ptbl).mpn;
            for(j=b; j < n;j++) {
                switch ((*Ptbl).prc[j].pst) {
                case PEMPTY:
                break;
                case PREADY:
                    _mprun(j);
                break;
                case PRUNNING:
                    printf("NODE %2d, USER ERROR!  Node is running\n",j);
                break;
                case PBLOCKED:
                    printf("NODE %2d, USER ERROR!  Node is blocked\n",j);
                break;
                default:
                    printf("NODE %2d, STATUS ERROR!  Unknown type %d\n", j,
                        (*Ptbl).prc[j].pst);
                    mpprint("NODE %2d, STATUS ERROR!  Unknown type %d\n", j,
                        (*Ptbl).prc[j].pst);
                    _mpterm();
                break;
                }
            }
            (*Ptbl).mps=PRUNNING;
        break;
        default:
            printf("MPStart, USER ERROR!... MP simulator is running\n");
        break;
        }
    }
    else mperror(3, "Sim: starter");
}

_mpstatus()
{
    int i, j;

    if(Ptbl)
    {
        printf("Nodes : %5d  Logfile : %s\n", (*Ptbl).mpn, (*Ptbl).mpl);
        printf("Status: %5d  #Running: %5d\n", (*Ptbl).mps, (*Ptbl).mpr);
        printf("Node  UNIXId   MsgId  Command     MsgSnd  MsgRcv  Status\n");
        printf("----  ------  ------  ----------  ------  ------  -------\n");
        for(i=0, i--; i<(*Ptbl).mpn; i++)
        {
            if ((*Ptbl).prc[i].pst!=PEMPTY) {
                printf("%4d  %6d  %6d  %10s  %6d  %6d  ",
                 (*Ptbl).prc[i].pno, (*Ptbl).prc[i].pid,
                 (*Ptbl).prc[i].cmi, (*Ptbl).prc[i].cdp,
                 (*Ptbl).prc[i].msnd, (*Ptbl).prc[i].mrcv);
                switch ((*Ptbl).prc[i].pst) {
                case PREADY: printf("ready");
                break;
                case PRUNNING: printf("running");
                break;
                case PBLOCKED: printf("blocked");
                break;
                }
                printf("\n");
            }
        }
    }
    else mperror(1, "Sim: status");
}

_mpterm()
{
    kill(getpid(), SIGTERM);
    pause();
}

_mpwait()
{
    if(Ptbl)
    {
        jmp=0;
        for(;(*Ptbl).mpr;);
        (*Ptbl).mps=PREADY;
    }
    else mperror(1, "Sim: wait");
}
