.nr PO 1.5i
.sp 2i
.ft B
.ce 2
The MultiProcessor Simulator\(co / Experimental Version 1.0
.sp 2
.ft R
by F\*'elix E. Quevedo Stuva
.sp 4
.ad b
.fi
.ls 2
.NH 1
Introduction
.NH 2
Why a Simulator
.PP
There are several reasons that justifies a Multiprocessor
Simulator, instead of purshising the actual hardware. The first reason 
would be cost, since we assume that a Multiprocessor Computer is expensive.
Well, it is, but not much more than a commercial "Supercomputer".  Another
reason would be the availability of CPU time, but we forget that the
hardware must be running some kind of multiprogramming operating system, that
allows time sharing. So then, what is the need of a simulator if the reasons
for not having a parallel computer are trivial? Well, we must not forget the
great diversity of proposed arquitectures and the fact that we do not have
at this moment a standard hardware and implementation software.
.PP
The spirit for the simulator design, was to have a tool for designing
algorithms without having a parallel computer, regardless of the model or
arquitecture used. This meant a design flexible enough to support the most
important features of most of the parallel computer models: shared memory
and interprocessor networks. From an academic point of view, these two 
features must be handy to test algorithms that requires them.
.NH 2
Outline of the Simulator
.PP
The simulator allows the user to define an environment where to
test parallel algorithms. The user has access to the multiprocessor facilities through user
functions and an interactive environment where to execute the programs.
The user can define a number of pseudoprocessors, each one with one message
queue, and access to a single shared memory segment.
.PP
The message queue defined for a processor can contain any type of data,
including structures.
The creation of shared memory segments is a special feacture reserved for
a host programs. The access is public and with concurrent read and concurrent
write. It is the user the encharged to control the access to the SMS.
By using a layered approach, the user can design the its own parallel
computer model. As observed the simulator tries not to constrait the application
of the user.
.PP
The simulator runs in an UNIX environment with IPC facilities. This is any
UNIX release with System V support.
The number of processors that a user can define depends on the value of the
UNIX system parameter MAXUPRC, on the system program /sys/param.c.
.PP
The simulator has been implemented with all the self controls
considered at that moment. This does not guarantee that a bug could eventually pop.
The only way to avoid such inconvinience is the use of the system.
.NH 2
Unix IPC Facilities
.PP
The Interprocess Communication Facilities of UNIX System V, is the
Simulator's lower layer. The two described feature of a processor, are
actually IPC facilities with a nice user friendly presentation.
.PP
The message queue facility operates with more options than available with
the simulator. It is important to mention a constrain in the number of bytes
that the message queue together can support is defined on the value ot the
UNIX system parameters MSGPOOL, MSGSIZ, MSGNMI, etc; on /sys/h/msg.h.
.NH 2
Suggested Further Implementations
.PP
There are many upgrades that can be made in this first experimental version:
.IP a)
improve the setup and execution (mpload, mprun) functions,
.IP b)
extend the user library with a set of prefixed intercommunication networks;
.IP c)
extend the user library with a interprocess synchronization function;
.IP d)
improve the interactive module, even with windows and graphic support;
.IP e)
research in a programming language interface layer; etc.
.NH 1
Installation
.PP
The Makefile has all the setups necessary to install the simulator, just
type:
.sp
		make
.PP
The final product are two file:
.IP mpsim
: Interactive Multiprocessor Simulator Manager;
.IP libmp.a 
: user loading library.
.PP
To compile a user library just do:
.sp
	cc myfile.c libmp.a [-o myfile] [-lm] ...
.NH 1
Implementation
.PP
The simulator has been implemented on UNIX C. It is transportability
has been proved between a SUN 3/60 and a VaxStation II. In both cases
the main modules were working, but with no guarantee of full feature
capacity.
.PP
The implementation consist of the following files:
.IP a)
mpsim.c: the interactive module. Contains the
.I main()
and the
.I _stop_handler()
functions.
.IP b)
mplib.c: the common function library. Contains the
.I
mpopen(), mptime(), mpprint(), mperro(), mehost(), _mplnode()
.R
functions.
.IP c)
mpsys.c: the system function library. Contains the
.I
_handler_req(), _handler_chl(), _handler_sys(), _mpinit(), _mpkill(),
_mplhost(), _mprun(), _mpstart(), _mpstatus(), _mpterm(),
.R and
_mpwait()
.R
functions.
.IP d)
mpusr.c: the user function library. Contains the
.I
_pause_handler()*, _getpt(), _trchd(), _imhost(), mprnd(), mpdim(),
mynode(), load(), _mvstr(), _rcvm(), recv(), trcv()*, send(), 
probe(), crtshm(), attshm(), detshm()
.R and
slpmsq()*
.R
functions. The ones marked with a * are still on experimental phase.
