/* tmx_prc.c
 *
 * Cost Optimal algorithm for find maximum with
 * Mapping of Binary-Tree Machine to Linear Array.
 *
 * Processor source code
 * Felix E. Quevedo
 * November 17, 1989.
 */
#define pw2(X) (1<<X)

lg2(x) /* simple function for log base 2 */
int x;
{
	int i;
	if(x) for(i=0; x>>i+1; i++);
	return i;
}

main()
{
	int i, j, k, l, f, t;
	int ni, ne, np, mx, xm;
	int vec[20];

	ni = mynode(); /* save processor index */
	np = mpdim();  /* save number of processors */

	recv(&f, &ne, sizeof(int)   , &t, 1); /* recv # of elements */
	recv(&f, vec, sizeof(int)*ne, &t, 2); /* recv partition */

	printf("NODE %d: received vector  ", ni);
	for(i = mx = 0; i <  ne;
    	mx = mx > vec[i]? mx : vec[i], /* find partition maximum */
		printf("%3d ", vec[i]),
		i++);
	printf("\n");

	j = lg2(np); /* compute # of max steps */
	for(i = 0; i < j; i++) {
		k = (ni+1) / pw2(i); /* compute x = (j mod 2^i-1) */
		l = k * pw2(i);      /* compute y = x * 2^i-1 */
	    if( (ni+1) == l && k % 2) { 
            printf("NODE %d: send max %d to %d\n", ni, mx, ni+1);
            send(ni+1, &mx, sizeof(int), 3);
		}
		else {
	        if( (ni+1) != l) { 
                printf("NODE %d: waiting to communicate\n", ni);
	            recv(&f, &xm, sizeof(int), &t, 3);
                printf("NODE %d: send max %d to %d\n", ni, xm, ni+1);
                send(ni+1, &xm, sizeof(int), t);
    		}
        	else {
                printf("NODE %d: waiting to process\n", ni);
                recv(&f, &xm, sizeof(int), &t, 3);
	            mx = mx > xm? mx : xm;
	        }
	    }
	}
	if(ni == mpdim()-1) /* if I'm the last processor */
       send(-1, &mx, sizeof(int), t); /* send to host the result */
}
