/* mmlt_prc.c
 *
 * Mesh Matrix Multiplication
 *
 * Processor source code
 * Felix E. Quevedo
 * November 24, 1989.
 */

int M, N, O;

P(i, j)
int i, j;
{
	return i*O+j;
}

main()
{
	int i, j, f, t;
	int a, b, c;
	int pi, ni, nj;

	pi = mynode(); /* save processor index */

	recv(&f, &M, sizeof(int), &t, 11); /* recv # of elements */
	recv(&f, &N, sizeof(int), &t, 12); /* recv # of elements */
	recv(&f, &O, sizeof(int), &t, 13); /* recv # of elements */

	ni = pi / O;
	nj = pi % O;

    for(i = c = 0; i < N; i++) {
	    recv(&f, &b, sizeof(int), &t, 2); /* recv partition */
	    recv(&f, &a, sizeof(int), &t, 1); /* recv partition */
        c += a*b;
        if(ni < M) send(P(ni+1,nj), &b, sizeof(int), 2);
        if(nj < O) send(P(ni,nj+1), &a, sizeof(int), 1);
	}
    send(-1, &c, sizeof(int), 3); /* send to host the result */
}
