/* FQSystems -------------------------------------------------------------------

	File  : mpd.h
			Header file for all system files.
	Title :	MultiProcessor Macro Library.
	Author: Felix E. Quevedo Stuva.
	Date  :	May 12, 1989.

----------------------------------------------------------------------------- */

/* -----------------------------------------------------------------------------
 * System Macro Includes
 */
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/shm.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <sys/file.h>
#include <errno.h>
#include <signal.h>
#include <stdio.h>

/* -----------------------------------------------------------------------------
 * Global Macro Defines
 */
#define MAX_PRC 32
#define MIN_PRC 1
#define MSG_LEN 512
#define MAX_WAITC 80000
#define PEMPTY   0x0000
#define PREADY   0x0001
#define PRUNNING 0x0002
#define PBLOCKED 0x0003
#define NIL      -1

/* -----------------------------------------------------------------------------
 * Global Data Type Definition
 */
typedef struct {
	short pno,	/* processor number: 0..MAX_PRC */
		  ppw,  /* pause wait flag: 0 pause, 1 continue */
	      pst;	/* processor status:
			         *     0: empty,
					 *     1: ready,
					 *     2: running,
					 *     3: blocked    */
	int pid,	        /* processor UNIX PID */
		msnd,
		mrcv;
	char cdp[50];	    /* command string pointers */
	long cmi;	        /* Msg queue ID */
	struct rusage rsg;  /* processor resource usage */
} MP_NODE;

typedef struct 	/* MP SHM table */
{
	int mpn,       /* number of active processors */
	    mpr,       /* number of running processors */
	    mpq,       /* processor starting request from host */
		mpm,       /* multiprocessor shared memory id */
		mpf,       /* logfile file descriptor */
		mpt;       /* logfile tracer indicator */
	short mps;	   /* multiprocessor status:
				         *     0: empty,
						 *     1: ready,
						 *     2: running */
	char mpl[50];  /* system log file */
				   /* the following two lines MUST always be together! */
	MP_NODE mph;   /* HOST node */
	MP_NODE prc[MAX_PRC]; /* Processor nodes */
} MP_TBL;

typedef struct
{
	long mtype;
	char mtext[MSG_LEN];
} MSG_FORM;

typedef struct
{
	int  mwho;	/* Who send the message */
	int  mlen;	/* length of the message */
	char *mtxt; /* message text */
} MSG_TXT;

/* -----------------------------------------------------------------------------
 * Global external Functions
 */
extern char *shmat(), *mptime(), *ctime();
extern MP_TBL *getpt();

/* -----------------------------------------------------------------------------
 * Global Variables
 */
#ifndef  _MPLIB_

extern MSG_FORM Smsg,  /* sending message */
	            Rmsg;  /* receiving message */
extern MSG_TXT  *Tmsg; /* general message text */
extern MP_TBL   *Ptbl; /* proccesors table */
extern int MsgKey, MsgId, ShmId, _tout, jmp, mpfd, simpid, simsq;

#else

MSG_FORM Smsg,  /* sending message */
         Rmsg;  /* receiving message */
MSG_TXT  *Tmsg; /* general message text */
MP_TBL   *Ptbl; /* proccesors table */
int MsgKey, MsgId, ShmId, _tout, jmp, mpfd, simpid, simsq;

#endif
