/* tmx_hst.c
 *
 * Cost Optimal algorithm for find maximum with
 * Mapping of Binary-Tree Machine to Linear Array.
 *
 * Host source code
 * Felix E. Quevedo
 * November 17, 1989.
 */
#define NN 256

main()
{
	int i, j, k, l, f, t, max;
	int vec[NN];			/* data vector */
	if ((f = mpdim())<32) exit(); /* save # of processors */
				/* prepare data and parameter for execution */
	srandom(l = time() / 100);		/* seed of random generator */
	for(i=k=0; i < NN; i++) {		/* for all vector number */
		vec[i] = random() / l;	/* generate random integer */
	}
	printf("Input Vector:\n");
	for(i=0; i < NN-14;) {
	    for(j=0; j < 22; printf("%3d ", vec[i++]), j++);
	    printf("\n");
	}
    for(j=0; j < 14; printf("%3d ", vec[i++]), j++);
    printf("\n");

    load("tmx_prc",-1);  /* load processor */

	k = NN / f;
	printf("HOST: send partition of size %d to %d processors\n", k, f);
	for(i=0; i < f;
	    send(i,        &k,   sizeof(int), 1), /* send # of elements */
		send(i, &vec[k*i], k*sizeof(int), 2), /* send vector */
		i++
		); /* send messages to processors */

	printf("HOST: wait for result\n");
	recv(&f, &max, sizeof(int), &t, 0); /* wait for result */
	printf("HOST: Maximum %d\n", max);
}
