/*------------------------------------------------------------------------------
Title:	Prim's MST Algorithm for MPSim Simulator 
File:	prim_cm.c
Dscrp:	Cube manager program, generate random weighted graph, loads node
	program to the simulator and waits for edges of the MST given by the
	node 0.
Author:	Felix E. Quevedo
Date:	Oct. 1989
------------------------------------------------------------------------------*/
#include "prim.h"

main()
{
					/* Cube system variables */
	int type, cnt, node, pid, numnodes;

					/* Application variables */
	int wgt[NN][2], wgf[NN][NN], v[3];
	int i, j, k, mx, n, cn;

	numnodes = mpdim();		/* obtain nodes available */

	printf("Parallelized  Prim's  MST  Algorithm\n");
	printf("By Felix E. Quevedo\n");
	n = 16;

	if(n<2||n>numnodes*2) exit(0);

	cn = pw2(i=lg2(n-1));			/* cube nodes requiered */
	printf("nodes:%d, cube nodes:%d\n", n, cn);
			/* create random weighted graph and load cube nodes */
	printf("\nWeighted graph:\n");
	mx = random();				/* initial random number */
	for(i=0; i<n; i++) {			/* random weighted graph */
		wgf[i][i]=INF;
		for(j=i+1; j<n; j++) {		/* random weigth creation */
			k=(random()%mx)/10000000;
			wgf[i][j]=k>1?k:INF;
			wgf[j][i]=wgf[i][j];
		}
		for(; j<2*cn; j++) wgf[i][j]=INF; /* complete weighted graph */
		for(j=0; j<n;			/* pretty output */
			printf((wgf[i][j]==INF?"*** ":"%3d "), wgf[i][j]),j++);
		printf("\n");
		wgf[i][0]=INF;			/* initial entry node */
	}

		/* load cube nodes, prepare and send partition to cube nodes */
	for(i=k=0; i<2*cn; i+=2) {			
		load("prim_node", k=i/2); /* load program to cube node */
						/* send size of partition */
		send(k, &n, sizeof(int), HTYPE);
		for(j=0; j<n; j++) {		/* prepare partition */
			wgt[j][0]=wgf[j][i];
			wgt[j][1]=wgf[j][i+1];
		}				/* send partition */
		send(k, wgt, NN*2*sizeof(int), HTYPE);
	}

					/* wait for node to solve MST */
	printf("\nMinimum Spanning Tree:\n");
	for(i=0; i<n-1; i++) {
		recv(&node, v, sizeof(int)*3, &type, NHTYPE);
		printf("HOST  path:%2d-%2d wgt:%3d\n", v[0],v[1],v[2]);
	}
	printf("Bye, bye...\n");
}
