/* mmlt_hst.c
 *
 * Mesh Matrix Multiplication
 *
 * Host source code
 * Felix E. Quevedo
 * November 24, 1989.
 */
#define M 4
#define N 6
#define O 4

P(i, j)
int i, j;
{
    return i*O+j;
}

main()
{
	int i, j, k, l, f, t, max;
	int mA[M][N];			/* data matrix */
	int mB[N][O];			/* data matrix */
	int mC[M][O];			/* output matrix */
	if (mpdim()<M*O) {
		printf("Requires a MPSim of size %d\n", M*O);
    	exit(); /* save # of processors */
    }

	for(i=0; i < M; i++) {		/* for all ith matrix number */
	    for(j=0; j < O; j++) {		/* for all jth  matrix number */
			l = P(i, j);
            load("mmlt_prc",l);  /* load processor */
			k = M;
    	  	send(l, &k, sizeof(int), 11); /* send matrix */
			k = N;
    	  	send(l, &k, sizeof(int), 12); /* send matrix */
			k = O;
    	  	send(l, &k, sizeof(int), 13); /* send matrix */
		}
	}
				/* prepare data and parameter for execution */
	srandom(k = time() / 10);		/* seed of random generator */
    printf("Matrix A:\n");
	for(i=0; i < M; i++) {		/* for all ith matrix number */
	    for(j=0; j < N; j++) {		/* for all jth  matrix number */
	    	mA[i][j] = random() / k;	/* generate random integer */
	        printf("%3d ", mA[i][j]);
		}
	    printf("\n");
	}
    printf("Matrix B:\n");
	for(i=0; i < N; i++) {		/* for all ith matrix number */
	    for(j=0; j < O; j++) {		/* for all jth  matrix number */
	    	mB[i][j] = random() / k;	/* generate random integer */
	        printf("%3d ", mB[i][j]);
	      	send(P(0,j), &mB[i][j], sizeof(int), 2); /* send matrix */
		}
	    printf("\n");
	}
	for(j=0; j < N; j++) {		/* for all jth  matrix number */
	    for(i=0; i < M; i++) {		/* for all ith matrix number */
    	  	send(P(i,0), &mA[i][j], sizeof(int), 1); /* send matrix */
		}
	}
	for(i=0; i<M*O; i++) {
        recv(&f, &j, sizeof(int), &t, 3); /* wait for result */
        mC[f/O][f%O] = j;
    }
    printf("Matrix C: A * B\n");
	for(i=0; i < M; i++) {		/* for all ith matrix number */
	    for(j=0; j < O; j++) {		/* for all jth  matrix number */
	        printf("%4d ", mC[i][j]);
		}
	    printf("\n");
	}
}




