/* max_prc.c
 *
 * CRCW Parallel Algorithm for Finding Maximum of a set of numbers.
 *
 * Processor source code
 * Felix E. Quevedo
 * November 10, 1989.
 */
#include "max.h"

main()
{
	int i, j, k, l;
	SMSeg *seg;

	seg = (SMSeg*)attshm(sizeof(SMSeg));	/* attach share memory segment */

	i = mynode();							/* get node number */
	j = seg->ij[i][0];						/* get compare index */
	k = seg->ij[i][1];						/* get compare index */
	l = (seg->vec[j] < seg->vec[k])? j : k; /* compare */
	seg->lst[l] = 1;						/* mark looser / minimum */

	seg->flg++;								/* increment semaphore */
	printf("Prc: %2d selects index %d from %d, %d\n", i, l, j, k);
	if ( i < 6) {
		while(seg->flg>0);					/* wait for 2nd step go! */
		if (!seg->lst[i])					/* if I'm the looser */
			seg->max = seg->vec[i];				/* I'm the maximum */
	    seg->flg--;							/* decrement semaphore */
	}

}
