/* max_hst.c
 *
 * CRCW Parallel Algorithm for Finding Maximum of a set of numbers.
 *
 * Host source code
 * Felix E. Quevedo
 * November 10, 1989.
 */
#include "max.h"

main()
{
	int i, j, k, l;
	SMSeg *seg;

	seg = (SMSeg*)crtshm(sizeof(SMSeg)); /* create share memory segment */
				/* prepare data and parameter for execution */
	srandom(l = time() / 100);		/* seed of random generator */
	for(i=k=0; i < 6; i++) {		/* for all vector number */
		seg->vec[i] = random() / l;	/* generate random integer */
		seg->lst[i] = 0;			/* nobody lost */
		for(j=i+1; j < 6; j++) {	/* prepare Pi,j -> Pk*/
			seg->ij[k][0] = i;
			seg->ij[k][1] = j;
			k++;
		}
	}
	printf("Shared Memory Input Vector:\n");
	for(i=0; i < 6; printf("%d ", seg->vec[i++]));
	printf("\n");

	printf("HOST: First Step\n");
	seg->flg = 0;					/* start 1st step */
	for(i=0; i < 15; load("max_prc",i++)); /* load processors */
	while(seg->flg-i);				/* wait complete 1st step */

	printf("HOST: Second Step\n");
	seg->flg = 0;					/* start 2nd step */
	while(seg->flg+6);				/* wait complete 2nd step */

	printf("Shared Memory content:\n");
	for(i=0; i<6; printf("%d ", seg->lst[i++]));
	printf("\n");
	printf("Max: %d\n", seg->max);
}
