/* FQSystems -------------------------------------------------------------------

    File  : mpsim.c
    Title : MultiProcessor Simulator Interactive Entry.
    Author: Felix E. Quevedo Stuva.
    Date  : May 31, 1989.

----------------------------------------------------------------------------- */
#include "mpdef.h"
#include <sys/stat.h>
#include <setjmp.h>

struct stat stype[1];
int jmp;
jmp_buf env;

static _stop_handler()
{
    if(!jmp) longjmp(env, 1);
}

#define MPLNODE  1
#define MPLHOST  2
#define MPSTART  3
#define MPLSTART 4
#define MPSTATUS 5
#define MPKILL   6
#define MPLOG    7
#define BADCOM   999

main(ac, ar)
int ac;
char *ar[];
{
    int i=MAX_PRC;
    int nr, j, tc;
    char buf[BUFSIZ], *cmd, *par, *opc, fn[50], *mptime();


    if(ac>1) i = atoi(ar[1]);
    _mpinit(i);
    signal(SIGINT, _stop_handler);

    printf("University of Miami\n");
    printf("Department of Mathematics and Computer Science\n");
    printf("MultiProccessor Simulator - Experimental Ver 1.0\n");
    if (((*Ptbl).mpf=mpopen(O_CREAT | O_WRONLY | O_APPEND))==NIL) {
        printf("Sim: WARNING, NOT able to open default logfile %s!!\n",
            (*Ptbl).mpl);
    }

    setjmp(env);
    jmp=1;
    for(;;)
    {
        for(;;) {
            printf("\nMPSim\/%d >> ", (*Ptbl).mpn);
            nr=(int)fgets(buf, BUFSIZ, stdin);
            if(nr==NULL) _mpterm();
            for(i=0; buf[i]==' ' && i<BUFSIZ; i++);
            if(buf[i]!='\n') break;
        }

        for(i=i, cmd=buf+i, opc=par=0;
            i<BUFSIZ && buf[i]!=' ' && buf[i]!='\n'; i++);
        if(buf[i]==' ' || buf[i]=='\n') {
            buf[i] = 0;
            par = &buf[i]+1;
            for(; *par==' ' && i<BUFSIZ; par++, i++);
            if(*par=='\n')
                *par=0;
            else {
                if(*par=='-') {
                    opc = par+1;
                    for(j=0; i<BUFSIZ && opc[j]!='\n' && opc[j]!=' '; i++, j++);
                    if(opc[j]!='\n') par=opc+j+1;
                    opc[j]=0;
                }
                for(j=0; i<BUFSIZ && par[j]!='\n'; i++, j++);
                if(par[j] =='\n') par[j]=0;
            }
        }
        /*printf("cmd %s, par %s, opc %s\n", cmd, par, opc);*/

        tc=NIL;
        if (!strcmp("lhost", cmd)) tc=MPLHOST;
        else
        if (!strcmp("lh", cmd)) tc=MPLHOST;
        else
        if (!strcmp("lnode", cmd)) tc=MPLNODE;
        else
        if (!strcmp("ln", cmd)) tc=MPLNODE;
        else
        if (!strcmp("start", cmd)) tc=MPSTART;
        else
        if (!strcmp("s", cmd)) tc=MPSTART;
        else
        if (!strcmp("lstart", cmd)) tc=MPLSTART;
        else
        if (!strcmp("ls", cmd)) tc=MPLSTART;
        else
        if (!strcmp("kill", cmd)) tc=MPKILL;
        else
        if (!strcmp("status", cmd)) tc=MPSTATUS;
        else
        if (!strcmp("st", cmd)) tc=MPSTATUS;
        else
        if (!strcmp("log", cmd)) tc=MPLOG;
        else
        if (!strcmp("quit", cmd)) _mpterm();
        else
        if (!strcmp("q", cmd)) _mpterm();
        else
        if (!strcmp("trace", cmd) || !strcmp("t", cmd)) {
            (*Ptbl).mpt=(*Ptbl).mpt?0:1;
            printf((*Ptbl).mpt?"Sim: trace ON\n":"Sim: trace OFF\n");
        }
        else tc=BADCOM;

        switch(tc) {
        case MPLNODE:
            if(*par)
                if((i=stat(par, stype))==-1) 
                    printf("Sim: File %s, does NOT exist!\n", par);
                else
                    if ((*stype).st_mode & S_IEXEC) {
                        i=opc?atoi(opc):-1;
                        if (i>-2 && i<MAX_PRC)
                            _mplnode(par, i);
                        else
                            printf("Sim: Option %s, is invalid\n", opc);
                    }
                    else
                        printf("Sim: File %s, is NOT executable\n", par);
            else
                printf("Sim: Sintax error, ln <-node_index> file_name\n");
        break;
        case MPLHOST:
            if(*par)
                if((i=stat(par, stype))==-1) 
                    printf("Sim: File %s, does NOT exist!\n", par);
                else
                    if ((*stype).st_mode & S_IEXEC)
                        _mplhost(par);
                    else
                        printf("Sim: File %s, is NOT executable\n", par);
            else
                printf("Sim: Sintax error, lh file_name\n");
        break;
        case MPSTART:
            if((*Ptbl).mps==PREADY) {
                (*Ptbl).mps=PBLOCKED;
                _mprun(-1);
                (*Ptbl).mps=PRUNNING;
            }
            _mpwait();
        break;
        case MPLSTART:
            if((*Ptbl).mps==PREADY) _mpstart(-1);
            _mpwait();
        break;
        case MPKILL:
            _mpkill(SIGKILL);
        break;
        case MPSTATUS:
            _mpstatus();
        break;
        case MPLOG:
            if(*par) {
                strcpy((*Ptbl).mpl, par);
                strcat((*Ptbl).mpl, ".LOG");
            }
			close((*Ptbl).mpf);
            if (((*Ptbl).mpf=mpopen(O_CREAT | O_WRONLY | O_TRUNC))==NIL) {
                printf("Sim: NOT able to open log file %s!!\n", (*Ptbl).mpl);
                perror("Sim");
            }
            else {
                j=(*Ptbl).mpt;
                (*Ptbl).mpt=1;
                mpprint("Sim: Log file %s, initiated\n", (*Ptbl).mpl);
                (*Ptbl).mpt=j;
                printf("Sim: Log file %s, initiated\n", (*Ptbl).mpl);
            }
        break;
        case BADCOM:
            printf("Sim: Unknown command %s\n", cmd);
        break;
        default:
        break;
        }
    }
}
