/* FQSystems -------------------------------------------------------------------

    File  : mplib.c
    Title : MultiProcessor Functions Libraries
    Author: Felix E. Quevedo Stuva.
    Date  : May 12, 1989

----------------------------------------------------------------------------- */
#define _MPLIB_
#include <varargs.h>
#include "mpdef.h"

long MPclk[1]; /* current time of the day */

mpopen(flg)
int flg;
{
    return open((*Ptbl).mpl, flg, 00644);
}
	
char *mptime()
{
    int i=0;
    char *s, *c;

    time(MPclk);
    c = s = ctime(MPclk)+4;
    for(; *c!='\n'; c++);
    *(c-4) = '\0';

    return s;
}


void mpprint(va_alist)
va_dcl
{
    if(Ptbl && (*Ptbl).mpt) {
        va_list args;
        char *fmt, *whr;
        int l;
        va_start(args);

		whr=Smsg.mtext;
        strcpy(whr, mptime());
        fmt = va_arg(args, char *);
        (void)vsprintf(whr+16, fmt, args);
        va_end(args);
		write((*Ptbl).mpf, whr, strlen(whr));
    }
}


mperror(n, wh)
int n;      /* error number */
char *wh;   /* who am I */
{
    (*Ptbl).mpt=1;
    switch(n) {
    case  1:
        mpprint("%s, MP not Active!!\n", wh);
        printf("%s, MP not Active!!\n", wh);
    break;
    case  2:
        mpprint("%s, MP already active!!\n", wh);
        printf("%s, MP already active!!\n", wh);
    break;
    case  3:
        mpprint("%s, MP could not attach the SHM segment!!\n", wh);
        printf("%s, MP could not attach the SHM segment!!\n", wh);
    break;
    case  4:
        mpprint("%s, MP could not assign a SHM segment!!\n", wh);
        printf("%s, MP could not assign a SHM segment!!\n", wh);
    break;
    case  5:
        mpprint("%s, BAD parameter list!!\n", wh);
        printf("%s, BAD parameter list!!\n", wh);
    break;
    case  6:
        mpprint("%s, Illegal command for node process!\n", wh);
        printf("%s, Illegal command for node process!\n", wh);
    break;
    default:
        mpprint("%s", wh);
        printf("%s", wh);
    break;
    }
    exit(n);
}

mehost()
{
    if ((*Ptbl).mph.pid==getpid())
        return 1;
    return 0;
}

_mplnode(cmd, prcn)
char *cmd;
int prcn;
{
    int i, j;
    if(!cmd) return mperror(5, "Sim: lnode");
    i=(prcn<0)?0:prcn;
    j=(prcn<0)?(*Ptbl).mpn-1:i;
    for(;i<=j;
        strcpy((*Ptbl).prc[i].cdp, cmd),
        (*Ptbl).prc[i].pst = PREADY,
        mpprint("Sim:  NODE %2d, Command %s loaded!\n", i, (*Ptbl).prc[i].cdp),
        i++);
    (*Ptbl).mps=PREADY;
}
