/*****************************************************************************
 *                                                                           *
 * mmake - Program to support make on multiple systems.  This program takes  *
 *         the file MMakefile and runs the C preprocessor on it.  The result *
 *         is written to Makefile, and then "make" is invoked.  Note that    *
 *         the C preprocessor is only invoked if the file MMakefile is newer *
 *         then Makefile.                                                    *
 *                                                                           *
 *         This program is designed to allow the same makefile to be used on *
 *         unix(r) systems and MS-DOS(r) systems.  In order to make this     *
 *         program portable across systems, it is not very smart about the   *
 *         way it does certain things.  For example, in order to run the     *
 *         C preprocessor, we use a system() call, rather than something     *
 *         line popen() which is not available on MS-DOS.                    *
 *                                                                           *
 *         The file names were chosen so that once mmake has run and created *
 *         Makefile, you can run "make" rather than "mmake" unless MMakefile *
 *         changes.                                                          *
 *                                                                           *
 *         Mmake has no arguments, but certain command line arguments are    *
 *         send to either CPP or make as appropriate.  Any argument which    *
 *         begines with "-D", "-I", or "-U" is sent to CPP.  Any other flags *
 *         are passed unchanged to make.                                     *
 *                                                                           *
 *         The output from the C preprocessor is written to a temporary file *
 *         because this output contains blank lines which will cause make to *
 *         detect a syntax error.  The temporary file is read back in and    *
 *         the blank lines are removed with the result goint to Makefile.    *
 *                                                                           *
 *****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>

extern int errno;
int temp_flag;
char *temp_name;

main(argc, argv)
int argc;
char **argv;
{
    time_t mmtime, mtime;
    struct stat sb;
    int newer = 0;			/* DOS requires initialization */
    char cpp_command[1024];
    char make_command[1024];
    char *temp_file;
    char line[1024];
    FILE *fpin, *fpout;
    int cleanup();

    temp_flag = 0;			/* Indicates that temp file exists */
    signal(SIGINT,cleanup);

    if (stat("MMakefile", &sb) < 0) {
	perror("MMakefile");
	exit(1);
    } else
	mmtime = sb.st_mtime;

    if (stat("Makefile", &sb) < 0) {
	if (errno == ENOENT)
	    mtime = 0;
	else {
	    perror("Makefile");
	    exit(1);
	}
    } else
	mtime = sb.st_mtime;

    strcpy(cpp_command,"cc -E MMakefile ");
    strcpy(make_command, "make ");

    if (mmtime > mtime) {		/* do we have to run CPP? */
	newer = 1;
	temp_file = mktemp("MMXXXXXX");
    }

    /* Now scan the argument flags and put each in the appropriate
       command line */
    argc--;
    argv++;
    while(*argv) {
	if ((strncmp(*argv,"-D",2) == 0) ||
	    (strncmp(*argv,"-U",2) == 0) ||
	    (strncmp(*argv,"-I",2) == 0)) {
	    strcat(cpp_command, *argv);
	    strcat(cpp_command, " ");
	} else {
	    strcat(make_command, *argv);
	    strcat(make_command, " ");
	}
	argc--;
	argv++;
    }
    strcat(cpp_command, ">");
    if (newer) {
	temp_flag = 1;			/* Say temp file exists */
	temp_name = temp_file;		/* temp file name is temp_name */
	strcat(cpp_command, temp_file);
    } else
	strcat(cpp_command, "Makefile");

    if (newer) {
	if (system(cpp_command) != 0) {
	    fprintf(stderr, "CPP Failed!\n");
	    cleanup();
	}
	if ((fpin = fopen(temp_file, "r")) == NULL) {
	    perror(temp_file);
	    unlink(temp_file);
	    exit(1);
	}
	if ((fpout = fopen("Makefile", "w")) == NULL) {
	    perror("Makefile");
	    cleanup();
	}
	while (fgets(line, sizeof line, fpin)) {
	    if (*line != '\n')
		fputs(line, fpout);
	}
	if (!feof(fpin)) {
	    perror("Makefile");
	    cleanup();
	}
	fclose(fpin);
	fclose(fpout);
	unlink(temp_file);
	temp_flag = 0;			/* Temp file no longer exists */
    }

    return (system(make_command));
}

cleanup()
{
    if (temp_flag)
	unlink(temp_name);
    fprintf(stderr, "Mmake aborted.  %s\n", temp_flag ?
	    "temporary file removed." : "");

    exit(1);
}
