#include <stdio.h>
#include <curses.h>

#define DEF_LINE_LEN	80
#define DEF_WORD_LEN	40
#define DEF_TAB_LEN		4
#define FULL_WIDTH		80
#define PAGE_LEN		40
#define POS1			1
#define DO_ALL1 \
	col_pos = POS1;\
	for ( doo = 0; doo < ins_len; doo++ ) {\
		putcolu(insert[doo]);\
	}
#define BOT_LINES		1
#define STR				15
#define TEST_STR		25
#define GET_NUM_STR		25

int colu_chars, colu_lines;
int page_len = PAGE_LEN, columns = 1, lin = 0, bot_lines = BOT_LINES;
int got_newpage = FALSE, got_dyslexi = FALSE, full_line = FULL_WIDTH;
int tab_len = DEF_TAB_LEN, ins_tabs = 0, del_len, got_fill = FALSE;
int got_mrandom = FALSE, got_bot = FALSE, ins_len, mrandom = 1;
char **cur_page, *malloc(), *delim = "   ", **glob_argv;

main(argc, argv)
char *argv[];
int argc;
{
	int col_pos = 1, j = 0, k, in, doo, line_len = DEF_LINE_LEN, row_count = 1;
	int cnt_nwl = 0, new_wo_le, dummy = TRUE, end = 2;
	int width = FULL_WIDTH, in_2 = 0, in_3 = 0, tmp_chars = 0;
	char *cur_word, *insert = "", *s = "Bad option '  '";
	int index, start = 1, word_len = DEF_WORD_LEN;
	int got_start = FALSE, got_line_len = FALSE, got_insert = FALSE;
	int got_tab_len = FALSE, got_end = FALSE, got_width = FALSE;
	int got_columns = FALSE, got_page_len = FALSE;
	int got_newlines = FALSE, got_delim = FALSE, got_file = FALSE;
	int index_start = 0, index_insert = 0, index_line_len = 0;
	int index_tab_len = 0, index_end = 0, index_width = 0;
	int index_columns = 0, index_page_len = 0, index_delim = 0;
	int index_bot = 0, index_mrandom = 0, index_file = 0;
	FILE *fil = stdin;
	glob_argv = argv;
	for ( index = 1; index < argc; index++) {
		if ( argv[index][0] != '-' ) {
			if ( index == 1 || (argv[index - 1][0] == '-' &&
			argv[index - 1][0] != 'i' && argv[index - 1][0] != 'D' || index > 2
			&& argv[index - 2][0] == '-' && (argv[index - 2][1] == 'i'
			|| argv[index - 2][1] == 'D')) && !got_file ) {
				got_file = TRUE;
				index_file = index;
			} else {
				fprintf(stderr, "Option '%s' not allowed.\n", argv[index]);
				usage(11);
			}
		}
		doo = index_insert != index && index_delim != index
		&& index_file != index;
		switch ( argv[index][1] ) {
			case 'i':
				check_it(&got_insert, "-i", 8, doo, &index_insert, index + 1);
				break;
			case 's':
				check_it(&got_start, "-s", 9, doo, &index_start, index);
				break;
			case 'l':
				check_it(&got_line_len, "-l", 10, doo, &index_line_len, index);
				break;
			case 'e':
				check_it(&got_end, "-e", 10, doo, &index_end, index);
				break;
			case 'w':
				check_it(&got_width, "-w", 10, doo, &index_width, index);
				break;
			case 'r':
				check_it(&got_mrandom, "-r", 37, doo, &index_mrandom, index);
				break;
			case 'd':
				check_it(&got_dyslexi, "-d", 11, doo, &dummy, index);
				break;
			case 't':
				check_it(&got_tab_len, "-t", 13, doo, &index_tab_len, index);
				break;
			case 'c':
				check_it(&got_columns, "-c", 15, doo, &index_columns, index);
				break;
			case 'p':
				check_it(&got_page_len, "-p", 16, doo, &index_page_len, index);
				break;
			case 'B':
				check_it(&got_bot, "-B", 17, doo, &index_bot, index);
				break;
			case 'f':
				check_it(&got_fill, "-f", 33, doo, &dummy, index);
				break;
			case 'n':
				check_it(&got_newlines, "-n", 18, doo, &dummy, index);
				break;
			case 'L':
				check_it(&got_newpage, "-L", 19, doo, &dummy, index);
				break;
			case 'D':
				check_it(&got_delim, "-D", 36, doo, &index_delim, index + 1);
				break;
			case '\0':
				write_err(doo, "Empty flag '-'", 31);
				break;
			default:
				s[12] = argv[index][0];
				s[13] = argv[index][1];
				write_err(doo, s, 20);
				break;
		}
	}
	ext_num(got_start, &start, argv[index_start],
	"Line zero, for start, not allowed", 21);
	ext_num(got_page_len, &page_len, argv[index_page_len],
	"Page length zero, not allowed", 24);
	ext_num(got_tab_len, &tab_len, argv[index_tab_len],
	"Tab length zero, not allowed", 27);
	ext_num(got_line_len, &line_len, argv[index_line_len],
	"Line length zero, not allowed", 25);
	write_err(line_len < 2, "Too short line length, not allowed", 32);
	ext_num(got_end, &end, argv[index_end],
	"End length zero, not allowed", 25);
	write_err(got_end && end <= start,
	"End not greater than start line, not allowed", 33);
	ext_num(got_width, &width, argv[index_width],
	"Line length zero, not allowed", 25);
	ext_num(got_mrandom, &mrandom, argv[index_mrandom],
	"Zero fill length, not allowed", 36);
	if ( got_bot ) get_num(&bot_lines, argv[index_bot]);
	if ( got_file ) {
		write_err( (fil = fopen(argv[index_file], "r")) == NULL,
		"Unable to open your text file", 50);
	}
	if ( got_insert ) {
		if ( index_insert < argc ) {
			insert = argv[index_insert];
		} else {
			insert = "";
		}
	}
	if ( got_delim ) {
		if ( index_delim < argc ) {
			delim = argv[index_delim];
		} else {
			delim = "";
		}
	}
	del_len = str_len(delim);
	if ( got_columns ) {
		get_num(&columns, argv[index_columns]);
		write_err(columns == 0, "columns count zero, not allowed", 26);
		write_err(line_len % columns,
		"Lines not an even multiple of columns length", 27);
	}
/* colu_chars is the chars on one column. colu_lines is the total number of
lines in all the columns in one page. page_len is the number of lines in one
page. */
	ins_len = str_len(insert);
	colu_chars = line_len / columns + ins_len;
	colu_lines = page_len * columns;
	write_err( !(cur_page = (char**) malloc(colu_lines * sizeof(char*))),
	"Can not malloc that page length", 39);
	for ( in = 0; in < colu_lines; in++ ) {
		if ( !(cur_page[in] = malloc(colu_chars * sizeof(char))) ) {
			write_err(TRUE, "Can not malloc that page length", 40);
		}
	}
	for ( doo = 0; doo < ins_len; doo++ ) {
		if ( insert[doo] == '\t' ) {
			ins_tabs++;
		}
	}
	full_line = line_len + ins_len * columns + del_len * ( columns - 1);
	full_line += ( tab_len - 1 ) * columns * ins_tabs;
	line_len = line_len / columns;
	word_len = line_len;
	write_err( !(cur_word = malloc(word_len * sizeof(char))),
	"Can not malloc that word (line?) length", 41);
	if ( width > full_line ) initrev(width);
	else initrev(full_line);
/* ************* Write text according to the '-s' flag **** */
	while ( row_count < start ) {
		in = getc(fil);
		if ( in == EOF ) exit(0);
		if ( in == '\n' ) {
			if ( got_dyslexi ) {
				flushrev();
			}
			putchar('\n');
			row_count++;
		} else if ( got_dyslexi ) {
			putrev(in);
		} else {
			putchar(in);
		}
	}
	if ( !got_end ) end = row_count + 1;
	lin = ( ( start - 1 ) % page_len ) * columns;
	new_wo_le = word_len - 1;
/* ******************** The fold follows ******************** */
	DO_ALL1
	while ( 1 ) {
		if ( row_count > end ) {
			in = EOF;
		} else if ( j == new_wo_le && tmp_chars == 0 ) {
			in_2 = getc(fil);
			if ( in_2 == ' ' || in_2 == '\n' || in_2 == '\t' ) {
				in = in_2;
			} else {
				in_3 = getc(fil);
				if ( in_3 == ' ' || in_3 == '\n' || in_3 == '\t' ) {
					in = in_2;
					tmp_chars = 1;
				} else {
					in = '-';
					tmp_chars = 2;
				}
			}
		} else if ( j == word_len ) { 
			in = ' ';
		} else if ( tmp_chars > 0 ) {
			if ( tmp_chars == 1 && j == 0 ) {
				in = in_3;
				tmp_chars = 0;
			} else if ( tmp_chars == 1 && j == 1 ) {
				in_2 = in_3;
				tmp_chars = 0;
				if ( line_len != 2 || in_2 == ' ' || in_2 == '\n'
				|| in_2 == '\t' ) {
					in = in_2;
				} else {
					in_3 = getc(fil);
					if ( in_3 == ' ' || in_3 == '\n' || in_3 == '\t' ) {
						in = in_2;
						tmp_chars = 1;
					} else {
						in = '-';
						tmp_chars = 2;
					}
				}
			} else {
				in = in_2;
				tmp_chars = 1;
			}
		} else { 
			in = getc(fil);
		}
		if ( in != '\n' ) {
			if ( cnt_nwl > 1 && got_newlines ) {
				while ( --cnt_nwl ) {
					putcolu('\n');
					putcolu(' ');
				}
				putcolu('\n');
				DO_ALL1
			}
			cnt_nwl = 0;
			if ( in == '\t' ) in = ' ';
		} else {
			if ( got_end ) row_count++;
			if ( got_newlines ) cnt_nwl++;
			in = ' ';
		}
		if ( in == EOF ) {
			putcolu('\n');
			flushpage(columns);
			if ( !got_end ) exit(0);
			else break;
		}
		if ( in != ' ' ) {
			write_err( j >= word_len || j < 0 ,
			"Internal error or to long text word", 3);
			cur_word[j++] = in;
		} else {
			if ( col_pos != POS1 && (col_pos + j) <= line_len &&
			j != 0 ) {
				putcolu(' ');
				col_pos++;
			} else if ( (col_pos + j) > line_len && col_pos != POS1 ) {
				putcolu('\n');
				DO_ALL1
			}
			for ( k = 0; k < j; k++ ) {
				putcolu(cur_word[k]);
			}
			col_pos += j;
			j = 0;
		}
	}
/* ***************** End of the fold ********************** */
/* ************* Write text according to the '-e' flag **** */
	if ( cnt_nwl > 1 && got_newlines ) {
		while ( --cnt_nwl ) {
			putcolu('\n');
			putcolu(' ');
		}
		putcolu('\n');
		flushpage(columns);
	}
	while ( 1 ) {
		in = getc(fil);
		if ( in == EOF ) exit(0);
		if ( in == '\n' ) {
			if ( got_dyslexi ) {
				flushrev();
			}
			putchar('\n');
		} else if ( got_dyslexi ) {
			putrev(in);
		} else {
			putchar(in);
		}
	}
}

char *buff;
int gl_i = 0, len;
/* lin is the line index in the one long column before it is pasted out onto the
page. len is the lenght of each line in the one long column. */

putrev(c)
{
	int i;

	if ( gl_i >= 0 && gl_i < len ) {
		if ( c != '\t' ) {
			buff[gl_i++] = c;
		} else {
			int k = tab_len - gl_i % tab_len;
			for ( i = 0; i < k; i++ ) {
				putrev(' ');
			}
		}
	} else {
		write_err(TRUE,
		"Internal error in reverse buffer. Specify bigger buffer", 4);
	}
}

flushrev() {
	int i, first = 0;

	if ( buff[first] == ' ' ) while ( buff[++first] == ' ' );
	for ( i = len - 1; i >= first; i--) {
		if ( buff[i] != '\0' ) {
			putchar(buff[i]);
			buff[i] = '\0';
		} else {
			putchar(' ');
		}
	}
	gl_i = 0;
}

initrev(l)
int l;
{
	int i;

	len = l;
	write_err( !(buff = malloc((len + 1) * sizeof(char))),
	"Can not malloc that internal reverse buffer length", 42);
	for ( i = 0; i < len; i++ ) {
		buff[i] = '\0';
	}
	buff[len] = '#'; /* To help flushrev swallow blank lines */
}

check_it(got_flag, s, err, boole, index_flag, index)
int *got_flag, *index_flag;
char *s;
{
	test(*got_flag, s, err);
	test_two(boole, index_flag, index, got_flag);
}

test(flag, s1, err)
char *s1;
{
	char *s2 = "Multiple '  ' not allowed";

	s2[10] = s1[0];
	s2[11] = s1[1];
	write_err(flag, s2, err);
}

test_two(boole, index_flag, index, got_flag)
int *index_flag, *got_flag;
{
	if ( boole ) {
		if ( *index_flag && glob_argv[index][2] != '\0' ) {
			fprintf(stderr, "Flag '%c%c' doesn't want any argument.\n",
			glob_argv[index][0], glob_argv[index][1]);
			usage(35);
		}
		*index_flag = index;
		*got_flag = TRUE;
	}
}

write_err(flag, s, err)
char *s;
{
	if ( flag ) {
		fprintf(stderr, "%s.\n", s);
		usage(err);
	}
}

ext_num(bulle, tal, arg, s, err)
int *tal;
char *arg, *s;
{
	if ( bulle ) {
		get_num(tal, arg);
		write_err(*tal == 0, s, err);
	}
}

get_num(number, argv) 
int *number;
char argv[];
{
	int k, in, tmp;
	char *s = "Not a number in flag '  '";

	s[22] = argv[0];
	s[23] = argv[1];
	*number = 0;
	k = str_len(argv);
	write_err(k == 1, s, 9);
	for( in = 2; in < k; in++) {
		tmp = argv[in] - '0';
		write_err(tmp < 0 || tmp > 9, "Bad flag, N-A-P-N", 5);
		*number = tmp + *number * 10;
	}
}

str_len(s)
char *s;
{
	int m = 0;

	if ( s[m] != '\0' ) while ( s[++m] != '\0' );
	return m;
}

usage(t) {
	fprintf(stderr, "[ %d ]  Usage: mfold [ -sn -ln -en -wn -f -d -rn -tn -cn -pn -n -L -Bn\n-D '<text>' -i '<text>' file]\n", t);
	exit(t);
}

int col = 0;

putcolu(c)
char c;
{
	if ( c == '\n' || col == colu_chars ) {
		advance_line();
		return;
	}
	cur_page[lin][col++] = c;
}

advance_line() {
		col = 0;
		if ( ++lin == colu_lines ) {
			flushpage(columns);
			end_page();
		}
}

end_page() {
	int i;

	if ( columns > 1 || got_bot ) {
		for ( i = 0; i < bot_lines; i++ ) {
			putchar('\n');
		}
	}
	if ( got_newpage ) putchar(12);		/* 12 == ^L  (ascii) */
}

flushpage(columns) {
	int line_sta = 0, cs, tmpl, lin_diff, lin_end;
	int end_col = columns - 1, lin_sto = colu_lines, end_char = colu_chars - 1;

	for ( lin = 0; lin < colu_lines; lin++ ) {
		if ( cur_page[lin][0] != '\0' ) {
			line_sta = lin;
			break;
		}
	}
	for ( lin = line_sta; lin < colu_lines; lin += columns ) {
		if ( cur_page[lin][0] == '\0' ) {
			lin_sto =  lin;
			break;
		}
	}
	lin_diff = (lin_sto - line_sta) / columns;
	lin_end = line_sta + lin_diff;
	for ( lin = line_sta; lin < lin_end; lin++) {
		if ( cur_page[lin][0] != ' ' || cur_page[lin][1] != '\0'
		|| columns != 1 ) {
			for ( cs = 0; cs < columns; cs++ ) {
				tmpl = lin + lin_diff * cs;
				if ( cur_page[tmpl][end_char] == '\0' && got_mrandom ) {
					fill_sp(tmpl, end_char);
				}
				for ( col = 0; col < colu_chars; col++ ) {
					if ( cur_page[tmpl][col] == '\0' ) {
						if ( cs == end_col && !got_fill ) break;
						if ( got_dyslexi ) putrev(' ');
						else putchar(' ');
					} else {
						if ( got_dyslexi ) putrev(cur_page[tmpl][col]);
						else putchar(cur_page[tmpl][col]);
						cur_page[tmpl][col] = '\0';
					}
				}
				if ( cs < end_col ) {
					for ( col = 0; col < del_len; col++ ) {
						if ( got_dyslexi ) putrev(delim[col]);
						else putchar(delim[col]);
					}
				}
			}
			if ( got_dyslexi ) flushrev();
		}
		putchar('\n');
	}
	lin = col = 0;
}

fill_sp(line, end_char) {
	int pass = 0, last, nulls = end_char, words = 0, i, found_sp = FALSE;
	int found_word = FALSE, moves, new_end, old_end;

	while ( cur_page[line][--nulls] == '\0' && nulls != 1 );
	nulls = end_char - nulls;
	last = end_char - nulls;
	for ( i = ins_len; i <= last; i++) {
		if ( cur_page[line][i] != ' ' ) {
			if ( !found_word ) {
				words++;
				found_word = TRUE;
			}
		} else {
			found_word = FALSE;
		}
	}
	if ( words < 2 ) return;
	old_end = last;
	while ( ++pass < mrandom ) {
		if ( words > nulls ) moves = nulls;
		else moves = words - 1;
		i = moves;
		new_end = moves + old_end;
		last = new_end;
		while( 1 ) {
			cur_page[line][new_end--] = cur_page[line][old_end--];
			if ( old_end < 0 ) break;
			if ( cur_page[line][old_end] == ' ' ) {
				if ( !found_sp ) {
					if ( moves-- > 0 ) cur_page[line][new_end--] = ' ' ;
				}
				found_sp = TRUE;
			} else {
				found_sp = FALSE;
			}
		}
		if ( cur_page[line][end_char] != '\0' ) return;
		nulls = nulls - i;
		old_end = last;
	}
}
