	/* @(#)dumb_menu.l	1.2 90/03/08 */
	/* copyrite (c) Miller/Howard Investments, 1990 */

%{
/* this thing is designed to use flex, not lex.  If you don't have
   it, then you'll have to re-write the lexical analyser */

#include <ctype.h>

  char *saved_text;
%}

	/* global definitions */

%x P_STATE T_STATE

%%

item	return ITEM;
parm	return PARM;
title	return TITLE;
clear	return CLEAR;
bold	return BOLD;
"always-show"	return ALWAYS_SHOW;
"{"	{ BEGIN T_STATE ; }
\"	{ BEGIN P_STATE; }
";"	return ';';
[ \t]+	;
\n	line_number++;
.	return ERROR;

<T_STATE>"\\}"	add_text("}");
<T_STATE>"}"	{
	strip_white_space();
  	yylval.txt = saved_text;
	saved_text = (char *)0;
	BEGIN 0;
	return TEXT; }
<T_STATE>"\\\n"	{
	line_number++;
	add_text(yytext);
	}
<T_STATE>\\.	add_text(yytext);
<T_STATE>[^\\}\n]+	add_text(yytext);
<T_STATE>"\n"	{
	line_number++;
	add_text("\n");
	}

<P_STATE>[A-Za-z0-9_]+	add_text(yytext);
<P_STATE>\"	{
	if (saved_text) {
	  strip_white_space();
	  yylval.txt = saved_text;
	  saved_text = (char *)0;
	  BEGIN 0;
	  return PARM_NAME;
	}
	fprintf(stderr, "lex error\n");
	lex_errors++;
	return ERROR;
	}
%%

/* c program text */

#define INIT_SIZE	256
#define INC_SIZE	64

add_text(s)
char *s;
{
  static int saved_length;
  static int room_left;
  int len = strlen(s);
  static int saved_size;

  if (!saved_text) {
    memset(saved_text = malloc(INIT_SIZE), '\0', INIT_SIZE);
    room_left = INIT_SIZE;
    saved_size = INIT_SIZE;
    saved_length = 0;
  }

  len++;			/* inc len to account for terminating null */
  while (len >= room_left) {
    saved_text = realloc(saved_text, saved_size += INC_SIZE);
    room_left += INC_SIZE;
  }

  memcpy(saved_text + saved_length, s, len);
  /* the trailing null will be overwritten next time
     so it doesn't count in computing room left */
  room_left -= --len;
  saved_length += len;
}

strip_white_space()
{
  char *cp;
  char *sp;

  if (!saved_text)
    return;

  for (cp = saved_text + strlen(saved_text) - 1;cp > saved_text;cp--) {
    if (!isspace(*cp))
      break;
  }
  *++cp = '\0';

  for (cp=saved_text;*cp && isspace(*cp);cp++)
    ;

  /* is it all white? */
  if (!*cp && cp > saved_text) {
    saved_text = realloc(saved_text, 1);
    *saved_text = '\0';
    return;
  }

  /* is there any leading white space? */
  if (cp > saved_text) {
    char *tmp;
    int len;

    tmp = malloc(len = strlen(cp) + 1);
    memcpy(tmp, cp, len);
    free(saved_text);
    saved_text = tmp;

    return;
  }

  saved_text = realloc(saved_text, strlen(saved_text) + 1);
}

#ifdef yywrap
#undef yywrap
#endif
