#

/*LINTLIBRARY*/

#include "stdio.h"

#if !defined lint && !defined NOID
static char	elsieid[] = "@(#)substrings.c	8.2";
#endif /* !defined lint && !defined NOID */

#include "ctype.h"

#if !defined TRUE
#define TRUE	1
#define FALSE	0
#endif /* !defined TRUE */

extern char *	imalloc();
extern char *	strchr();

char **
substrings(string, separators)
char *	string;
char *	separators;
{
	register char **	array;
	register char *		cp;
	register int		nsubs;
	register int		lastsepprint;

	if (string == NULL || separators == NULL || *separators == '\0')
		return NULL;
	array = (char **) imalloc((strlen(string) + 2) * sizeof *array);
	if (array == NULL)
		return NULL;
	if (*string == '\0') {
		array[0] = NULL;
		return array;
	}
	nsubs = 0;
	lastsepprint = TRUE;
	for (cp = string; *cp != '\0'; ++cp)
		if (strchr(separators, *cp) != 0) {
			if (isascii(*cp) && isprint(*cp) && *cp != ' ' &&
				lastsepprint)
					array[nsubs++] = cp;
			lastsepprint = isascii(*cp) && isprint(*cp) &&
				*cp != ' ';
			*cp = '\0';
		} else {
			lastsepprint = FALSE;
			if (cp == string || *(cp - 1) == '\0')
				array[nsubs++] = cp;
		}
	if (lastsepprint && *(cp - 1) == '\0')
		array[nsubs++] = cp;
	array[nsubs] = NULL;
	return array;
}
