#

#include "stdio.h"

#if !defined lint && !defined NOID
static char elsieid[] = "@(#)measures.c	1.23";
#endif /* !defined lint && !defined NOID */

#include "math.h"

#if !defined NBPI
#define NBPI	(8 * sizeof (int))	/* Number of Bits Per Int */
#endif /* !defined NBPI */

#if !defined MAXLINE
#define MAXLINE	1000			/* MAXimum LINE length */
#endif /* !defined MAXLINE */

#define SKIPPED	'\0'

#if defined __TURBOC__
#define HUGE	HUGE_VAL
#define float	double
#undef SKIPPED
#define SKIPPED	(-1)
#endif /* defined __TURBOC__ */

extern char *	ecpyalloc();
extern char *	erealloc();
extern char *	strchr();
extern char **	substrings();
extern char *	wildname();

struct range {
	float	lo;
	float	hi;
};

struct range **	ranges;		/* measured ranges of traits, -/+ errors */

int		itemcount;	/* number of items  with traits */
int		traitcount;	/* number of traits of each item */

struct trait {
	char *	name;
	float	error;
	char	errtype;
	float	cost;
};

struct trait	traits[NBPI];

apartbits(i, j)
{
	register struct range *	rp1;
	register struct range *	rp2;
	register int		n, result;

	result = 0;
	n = traitcount;
	rp1 = ranges[i + 1];
	rp2 = ranges[j + 1];
	while (--n >= 0) {
		--rp1;
		--rp2;
		if (rp1->lo > rp2->hi || rp1->hi < rp2->lo)
			result |= 1 << n;
	}
	return result;
}

char *	oopsname;
long	oopsline;

oops(message)
char *	message;
{
	(void) fprintf(stderr, "\"%s\", line %ld: wild %s\n",
		oopsname, oopsline, message);
	for ( ; ; )
		wildexit(message);
}

dofiled(innames)
char **	innames;
{
	register int	i;

	for (i = 0; i < traitcount; ++i)
		if (traits[i].name != NULL)
			if (strcmp(innames[i], traits[i].name) == 0)
				continue;
			else	oops("mismatched `Filed' lines");
		else traits[i].name = ecpyalloc(innames[i]);
}

doerrors(inerrors)
char **	inerrors;
{
	register int	i;
	float		f;
	char		c;

	for (i = 0; i < traitcount; ++i) {
		c = '\0';
		if ((sscanf(inerrors[i], "%f%c", &f, &c) == 1 &&
			c != SKIPPED) || (c != SKIPPED && c != '%'))
				oops("`Errors' line");
		if (f < 0)
			oops("negative `Errors' value");
		if (c == '%' && f > 100)
			oops("Error percentage > 100");
		if (traits[i].error != 0 &&
			(f != traits[i].error || c != traits[i].errtype))
				oops("mismatched `Errors' lines");
		traits[i].error = f;
		traits[i].errtype = c;
	}
}

docosts(incosts)
char **	incosts;
{
	register int	i;
	float		f;
	char		c;

	for (i = 0; i < traitcount; ++i) {
		c = '\0';
		if (sscanf(incosts[i], "%f%c", &f, &c) != 1 || c != SKIPPED)
			oops("`Costs' line");
		if (f <= 0)
			oops("non-positive `Costs' value");
		if (traits[i].cost != 0 && f != traits[i].cost)
			oops("mismatched `Costs' lines");
		traits[i].cost = f;
	}
}

getanum(string, address)
char *	string;
float *	address;
{
	double	d;
	char	c;

	/*
	** Some buggy sscanfs think that "-" is a number.
	*/
	if (strcmp(string, "-") == 0)
		return 0;
	c = '\0';
	if (sscanf(string, "%f%c", &d, &c) == 1 && c == SKIPPED) {
		*address = d;
		return 1;
	}
	if (*string == '-') {
		*address = -HUGE;
		++string;
	} else	*address = HUGE;
	return strcmp(string, "HUGE") == 0 || strcmp(string, "huge") == 0 ||
		strcmp(string, "Huge") == 0;
}

#define ATATIME	500

doranges(inranges)
register char **	inranges;
{
	register char *	cp;
	register int	i;
	register int	ok;

	if ((itemcount % ATATIME) == 0) {
		ranges = (struct range **) erealloc((char *) ranges,
			(itemcount + ATATIME) * sizeof *ranges);
		ranges[0] = (struct range *) erealloc((char *) ranges[0],
			(itemcount + ATATIME) * traitcount * sizeof *ranges[0]);
		for (i = 1; i < itemcount + ATATIME; ++i)
			ranges[i] = ranges[i - 1] + traitcount;
	}
	for (i = 0; i < traitcount; ++i) {
		if (getanum(inranges[i], &ranges[itemcount][i].lo)) {
			ranges[itemcount][i].hi = ranges[itemcount][i].lo;
			continue;
		}
		cp = inranges[i];
		for ( ; ; ) {
			cp = strchr(cp + 1, '-');
			if (cp == 0) {
				ranges[itemcount][i].lo = -HUGE;
				ranges[itemcount][i].hi = HUGE;
				break;
			}
			*cp = '\0';
			ok = getanum(inranges[i], &ranges[itemcount][i].lo) &&
				getanum(cp + 1, &ranges[itemcount][i].hi);
			*cp++ = '-';
			if (!ok)
				continue;
			if (ranges[itemcount][i].lo > ranges[itemcount][i].hi)
				oops("range");
			break;
		}
	}
	++itemcount;
}

infile(filename)
char *	filename;
{
	register FILE *		fp;
	register char *		cp;
	register char **	cpp;
	register int		i;
	char			buf[MAXLINE + 2];	/* +2 for "\n\0" */

	if (strcmp(filename, "-") == 0) {
		fp = stdin;
		filename = "standard input";
	}
	else if ((fp = fopen(filename, "r")) == NULL)
		for ( ; ; )
			wild2exit("result opening", filename);
	oopsname = filename;
	for (oopsline = 1; fgets(buf, sizeof buf, fp) == buf; ++oopsline) {
		cp = strchr(buf, '\n');
		if (cp == 0)
			oops("long line");
		*cp = '\0';		/* Zap the trailing newline */
		if (strchr(buf, '#') != 0)
			*strchr(buf, '#') = '\0';	/* Zap comments */
		cpp = substrings(buf, ": \t");
		if (cpp == NULL)
			for ( ; ; )
				wildrexit("substrings");
		for (i = 0; cpp[i] != NULL; ++i)
			;
		if (i == 0) {
			free((char *) cpp);
			continue;
		}
		if (traitcount == 0) {
			traitcount = i - 1;
			if (traitcount <= 0)
				oops("lack of traits");
			if (traitcount > NBPI)
				oops("large number of traits");
		} else if (traitcount != i - 1)
			oops("number of traits");
		cp = cpp[0];
		if (strcmp(cp, "Filed") == 0)
			dofiled(&cpp[1]);
		else if (strcmp(cp, "Errors") == 0)
			doerrors(&cpp[1]);
		else if (strcmp(cp, "Costs") == 0)
			docosts(&cpp[1]);
		else	doranges(&cpp[1]);
		(void) free((char *) cpp);
	}
	if (ferror(fp) || !feof(fp))
		for ( ; ; )
			wild2exit("result reading", filename);
	if (fp != stdin)
		(void) fclose(fp);
}

int *	aparts;		/* traits to measure to tell two items apart */
int	apartcount;	/* number of elements in above table */
int	mustbits;	/* tells which traits MUST be measured */
int	mustcount;	/* tells how many traits MUST be measured */

main(argc, argv)
int	argc;
char *	argv[];
{
	register int	argind;
	register int	i, j;
	float		lo, hi;
	char		buf[NBPI];	/* Wildly generous! */

	argv[0] = wildname(argv[0]);
	argind = 1;
	if (strcmp(argv[argind], "--") == 0)
		++argind;
	if (argind == (argc - 1) && strcmp(argv[argind], "=") == 0) {
		(void) fprintf(stderr, "%s: usage is %s [file...]\n",
			argv[0], argv[0]);
		for ( ; ; )
			tameexit();
	}
	if (argind == argc)
		infile("-");
	else for (i = argind; i < argc; ++i)
		infile(argv[i]);
	if (itemcount == 0)
		for ( ; ; )
			wildrexit("lack of items");
/*
** Set all costs to one if no costs were given.
*/
	for (i = 0; i < traitcount; ++i)
		if (traits[i].cost != 0)
			break;
	if (i >= traitcount)
		for (i = 0; i < traitcount; ++i)
			traits[i].cost = 1;
/*
** Set all labels if no labels were given.
*/
	if (traits[0].name == NULL)
		for (i = 0; i < traitcount; ++i) {
			(void) sprintf(buf, "%d", i + 1);
			traits[i].name = ecpyalloc(buf);
		}
/*
** Adjust the ranges to reflect the errors.
*/
	for (i = 0; i < itemcount; ++i)
		for (j = 0; j < traitcount; ++j) {
			if (traits[j].error == 0)
				continue;
			lo = ranges[i][j].lo;
			if (lo > -HUGE && lo < HUGE) {
				if (traits[j].errtype == '\0')
					lo -= traits[j].error;
				else	lo -= lo * (traits[j].error / 100.);
				ranges[i][j].lo = lo;
			}
			hi = ranges[i][j].hi;
			if (hi > -HUGE && hi < HUGE) {
				if (traits[j].errtype == '\0')
					hi += traits[j].error;
				else	hi += hi * (traits[j].error / 100.);
				ranges[i][j].hi = hi;
			}
		}
/*
** Build the "tell apart" table.
*/
	for (i = 0; i < itemcount - 1; ++i) {
		aparts = (int *) erealloc((char *) aparts,
			(apartcount + itemcount + 1 - i) * sizeof *aparts);
		for (j = i + 1; j < itemcount; ++j)
			newbits(apartbits(i, j));
	}
	if (mustcount + apartcount == 0)
		for ( ; ; )
			wildexit("indistinguishable items (given errors)");
	finish();
	for ( ; ; )
		tameexit();
}

newbits(new)
register int	new;
{
	register int *	ip;
	register int	i;

	if ((mustbits & new) != 0)
		return;	/* A test we must do can tell these two apart */
	if (new == 0)
		return;	/* We can't tell these two apart! */
	/*
	** Is the new case (or a harder one) already in the table?
	*/
	ip = aparts;
	ip[apartcount] = new;
	while ((*ip++ & ~new) != 0)
		;
	if (ip <= &aparts[apartcount])
		return;
	/*
	** Get rid of any old entries that this new one is harder than.
	*/
	ip = aparts;
	for ( ; ; )
		if ((new & ~*ip++) == 0) {
			if (*--ip == new)
				break;
			*ip = aparts[--apartcount];
			aparts[apartcount] = new;
		}
	/*
	** Is more than one test involved?
	*/
	i = 1;
	while ((new & i) == 0)
		i <<= 1;
	if (new != i) {
		++apartcount;
		return;
	}
	/*
	** A single test is involved.
	*/
	mustbits |= i;
	if (++mustcount < traitcount)
		return;
	/*
	** Oh well. . .
	*/
	finish();
	for ( ; ; )
		tameexit();
}

float	lowcost;
int *	lowbits;
int	lowcount;

finish()
{
	register int	i, j;

	lowcost = HUGE;
	aparts[apartcount] = 0;
	dobits(mustbits, 0, 0., aparts);
	for (i = 0; i < lowcount; ++i) {
		for (j = 0; j < traitcount; ++j)
			if ((lowbits[i] & (1 << j)) != 0)
				(void) printf("%s ", traits[j].name);
		printf("\n");
	}
}

dobits(todo, done, cost, ip)
register int	todo, done;
register float	cost;
register int *	ip;
{
	register int	i, nextbit;

	while((todo & *ip++) != 0)
		;
	if (*--ip == 0) {
		if (cost < lowcost) {
			lowcost = cost;
			lowcount = 0;
		}
		lowbits = (int *) erealloc((char *) lowbits,
			(lowcount + 1) * sizeof *lowbits);
		lowbits[lowcount++] = todo;
		return;
	}
	if (cost >= lowcost)
		return;		/* cost can't get smaller! */
	i = *ip++ & ~(todo | done);
	for (nextbit = 0; nextbit < traitcount; ++nextbit) {
		if ((i & (1 << nextbit)) == 0 ||
			cost + traits[nextbit].cost > lowcost)
				continue;
		dobits(todo | ( 1 << nextbit), done,
			cost + traits[nextbit].cost, ip);
		done |= 1 << nextbit;
	}
}
