/*
 * Created 1989 by greg yachuk.  Placed in the public domain.
 */

#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "mdiskio.h"

#ifndef	THE_TTY
#ifdef	MSDOS
#define	THE_TTY	"CON"			/* device name of user's keyboard */
#else
#define	THE_TTY	"/dev/tty"		/* device name of user's keyboard */
#endif
#endif

/*
 * mdopen -	allocate an mdiskbuf and initialise some values in it.
 *		open the named file, in the requested mode.
 *
 * mode:	"r"	read only
 *		"w"	write/truncate (create)
 *		"a"	write/append (create)
 *		"r+"	read/write (create)
 *		"w+"	read/write/truncate (create)
 *		"a+"	read/write/append (create)
 *
 *	additionally, a "b" or "t" may be appended to specify BINARY
 *	or TEXT mode.  Note:  "ab+" <==> "a+b"
 */
MDFILE *
mdopen(name, mode, fnfilenm, seq)
char   *name;
char   *mode;
char   *(*fnfilenm)();
int	seq;
{
	MDFILE *mdp;
	char   *_mdfilenm();
	int	_mdprompt();

	/* allocate the diskbuffer */

	if ((mdp = (MDFILE *) calloc(1, sizeof (MDFILE))) == NULL)
		return (NULL);

	/* default buffer size of 512 */

	mdp->buffer = NULL;
	mdp->bufptr = mdp->buffer + BUFSIZ;
	mdp->basename = name;

	/* default filename-generation and prompt routines */

	mdp->filenm = (fnfilenm != NULL) ? fnfilenm : _mdfilenm;
	mdp->ateof = mdateof;
	mdp->prompt = _mdprompt;
	mdp->seq = seq;

	/* translate mode to bits that `open' expects */

	mdp->flags = _MDEMPTY;
	mdp->oflag = 0;
	while (*mode)
	{
		switch (*mode++)
		{
		case 'r':		/* read only, so far */
			mdp->oflag |= O_RDONLY;
			mdp->flags |= _MDREAD;
			break;
		case 'w':		/* write only, so far */
			mdp->oflag |= O_CREAT|O_TRUNC|O_WRONLY;
			mdp->flags |= _MDWRITE;
			break;
		case 'a':		/* append only, so far */
			mdp->oflag |= O_APPEND|O_CREAT|O_WRONLY;
			mdp->flags |= _MDWRITE;
			break;
		case '+':		/* read-write */
			mdp->oflag |= O_RDWR;
			mdp->oflag &= ~(O_WRONLY|O_RDONLY);
			mdp->flags |= _MDRDWR;
			mdp->flags &= ~(_MDWRITE|_MDREAD);
			break;
		case 't':		/* text mode */
			mdp->oflag |= O_TEXT;
			break;
		case 'b':		/* binary mode */
			mdp->oflag |= O_BINARY;
			break;
		}
	}

	/* and open up the file */

	if (_mdopen(mdp) == -1)
	{
		free(mdp);
		return (NULL);
	}

	return (mdp);
}

/*
 * _mdfilenm -	stupid default filename generator.
 *		just save the basename and return it.
 */
char   *
_mdfilenm(mdp)
MDFILE *mdp;
{
	mdp->filename = mdp->basename;
	return (mdp->basename);
}

/*
 * _mdprompt -	stupid default prompter.  just ask for next diskette.
 */
_mdprompt(mdp)
MDFILE *mdp;
{
	FILE   *tty;

	fputs("Insert next diskette and press RETURN...", stderr);

	if ((tty = fopen(THE_TTY, "r")) == NULL)
	{
		perror(THE_TTY);
		return (0);
	}

	while (getc(tty) != '\n');
	fclose(tty);
	return (1);
}

/*
 * md_ateof -	stupid default `at eof' function.  input files
 *		are always at EOF, and output file are never.
 */
mdateof(mdp, mode)
MDFILE *mdp;
int	mode;
{
	return (mode == _MDREAD);
}

/*
 * mdalleof -	always at EOF.
 */
mdalleof(mdp, mode)
MDFILE *mdp;
int	mode;
{
	return (1);
}

/*
 * mdnoteof -	never at EOF.
 */
mdnoteof(mdp, mode)
MDFILE *mdp;
int	mode;
{
	return (0);
}
